/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.AbstractLLRPTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Task_GET_ROSPECS
extends AbstractLLRPTask {
    private static final String TASKNAME = "Task_GET_ROSPECS";
    private Map rospecsList;

    public Task_GET_ROSPECS(CommandService command, Map parameters, SignalService signal) {
        super(command, parameters, signal);
    }

    public Task_GET_ROSPECS(CommandService command, Map parameters, SignalService signal, long timeout) {
        super(command, parameters, signal, timeout);
    }

    public boolean containsROSpecId(int rospecId) {
        if (this.rospecsList != null && !this.rospecsList.isEmpty()) {
            return this.rospecsList.containsKey(new Integer(rospecId));
        }
        return false;
    }

    public boolean duplicateTask(ITask task) {
        return this.isSameTaskType(task);
    }

    public int getROSpecState(int rospecId) {
        Map rospec;
        Integer state;
        if (this.containsROSpecId(rospecId) && (state = (Integer)(rospec = (Map)this.rospecsList.get(new Integer(rospecId))).get("ROSpec_CurrentState")) != null) {
            return state;
        }
        return -1;
    }

    public List getROSpecs() {
        ArrayList rospecs = new ArrayList();
        if (this.rospecsList != null && this.rospecsList.size() > 0) {
            rospecs.addAll(this.rospecsList.entrySet());
        }
        return rospecs;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        Map responseMap;
        if (source == this.getSignal() && data instanceof Map && this.successInLLRPStatus(responseMap = (Map)data)) {
            this.populateROSpecsList(responseMap);
            this.log(4, "Task " + this.getTaskName() + " received success response.");
            this.notifyListener(this.getTaskName(), 1, responseMap);
        }
    }

    protected boolean isSameTaskType(ITask task) {
        return task instanceof Task_GET_ROSPECS;
    }

    public boolean launchTask() {
        this.rospecsList = null;
        return super.launchTask();
    }

    private void populateROSpecsList(Map responseMap) {
        List existingROSpecs = (List)responseMap.get("ROSpecParameter");
        this.rospecsList = new Hashtable();
        if (existingROSpecs != null && existingROSpecs.size() > 0) {
            int i = 0;
            while (i < existingROSpecs.size()) {
                Map rospec = (Map)existingROSpecs.get(i);
                if (rospec != null) {
                    Integer rospecId = (Integer)rospec.get("ROSpecID");
                    this.rospecsList.put(rospecId, rospec);
                }
                ++i;
            }
        }
    }
}

