/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;

public abstract class AbstractTask
extends EscObject
implements ITask {
    private Set taskListeners;
    private int state;
    private Byte stateLock = new Byte(0);
    private Byte listenerLock = new Byte(0);
    private Timer taskTimer;

    protected AbstractTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(ITaskListener listener) {
        Byte by = this.listenerLock;
        synchronized (by) {
            if (this.taskListeners == null) {
                this.taskListeners = Collections.synchronizedSet(new HashSet());
            }
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getState() {
        Byte by = this.stateLock;
        synchronized (by) {
            return this.state;
        }
    }

    public Set getTaskListeners() {
        return this.taskListeners;
    }

    protected boolean isRemoveListenerRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener(String taskName, int status, Object result) {
        Byte by = this.listenerLock;
        synchronized (by) {
            if (this.taskListeners != null) {
                Iterator listeners = this.taskListeners.iterator();
                while (listeners.hasNext()) {
                    ITaskListener taskListener = (ITaskListener)listeners.next();
                    taskListener.taskNotice(taskName, status, result);
                }
            }
        }
    }

    public void removeTaskListener(final ITaskListener listener) {
        if (!this.isRemoveListenerRequired()) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                AbstractTask.this.removeTaskListenerNoThread(listener);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTaskListenerNoThread(ITaskListener listener) {
        Byte by = this.listenerLock;
        synchronized (by) {
            if (this.taskListeners != null) {
                this.taskListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Byte by = this.listenerLock;
        synchronized (by) {
            this.taskListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int state) {
        Byte by = this.stateLock;
        synchronized (by) {
            this.state = state;
        }
    }

    public void setTaskListeners(Set taskListeners) {
        this.taskListeners = taskListeners;
    }

    protected void startTimer(long millis) {
        if (millis <= 0L) {
            return;
        }
        this.stopTimer();
        this.taskTimer = new Timer(millis);
        this.taskTimer.start();
    }

    protected void stopTimer() {
        if (this.taskTimer != null && this.taskTimer.isAlive()) {
            this.taskTimer.interrupt();
        }
    }

    protected void timeOutOccurred() {
        this.notifyListener(this.getTaskName(), 2, "Task timeout:" + this.getTaskName());
    }

    class Timer
    extends Thread {
        private long millis;

        public Timer() {
        }

        public Timer(long millis) {
            this.millis = millis;
        }

        public void run() {
            try {
                Thread.sleep(this.millis);
                AbstractTask.this.timeOutOccurred();
            }
            catch (InterruptedException interruptedException) {}
        }

        public void setMillis(long millis) {
            this.millis = millis;
        }
    }
}

