/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager;

import java.util.LinkedList;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class TaskManager
extends AbstractTask
implements ITaskListener {
    public static final int STOPPED = 0;
    public static final int STANDBY = 1;
    private static final int TOPTASKRUNNING = 2;
    private LinkedList taskList;
    private Byte taskListLock = new Byte(0);
    private String name;

    public TaskManager(String name) {
        this(name, 1);
    }

    public TaskManager(String name, int state) {
        this.taskList = new LinkedList();
        this.setState(state);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTaskToBottom(ITask task, boolean checkDup) {
        this.log(4, "Add task: " + task.getTaskName() + " in " + this.getTaskName());
        Byte by = this.taskListLock;
        synchronized (by) {
            ITask bottomTask;
            if (checkDup && !this.taskList.isEmpty() && (bottomTask = (ITask)this.taskList.getLast()).duplicateTask(task)) {
                this.log(4, " Detect duplicate task at bottom in " + this.getTaskName());
                return;
            }
            this.taskList.addLast(task);
        }
        if (this.getState() == 1) {
            this.launchTopTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTaskToTop(ITask task, boolean checkDup) {
        Byte by = this.taskListLock;
        synchronized (by) {
            if (checkDup && !this.taskList.isEmpty()) {
                ITask topTask = (ITask)this.taskList.getFirst();
                if (topTask.duplicateTask(task)) {
                    this.log(4, "Detect duplicate task on top in " + this.getTaskName());
                    return;
                }
                this.taskList.addFirst(task);
            }
        }
        if (this.getState() == 1) {
            this.launchTopTask();
        }
    }

    public boolean duplicateTask(ITask task) {
        return task.getTaskName().equals(this.name);
    }

    public String getTaskName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITask getTopTask() {
        Byte by = this.taskListLock;
        synchronized (by) {
            if (!this.taskList.isEmpty()) {
                return (ITask)this.taskList.getFirst();
            }
            return null;
        }
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        ITask topTask;
        this.log(4, String.valueOf(this.getTaskName()) + " received response: " + source + ", current state: " + this.getState());
        if (this.getState() == 2 && (topTask = this.getTopTask()) != null) {
            topTask.handleResponse(source, timestamp, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskListEmpty() {
        Byte by = this.taskListLock;
        synchronized (by) {
            return this.taskList.isEmpty();
        }
    }

    public boolean launchTask() {
        this.setState(1);
        return true;
    }

    protected boolean launchTopTask() {
        ITask task = this.getTopTask();
        if (task != null) {
            if (task.launchTask()) {
                task.addTaskListener(this);
                this.log(4, "Started task: " + task.getTaskName() + " in " + this.getTaskName());
                this.setState(2);
                return true;
            }
            this.log(4, "Fail to start task: " + task.getTaskName() + " in " + this.getTaskName());
        }
        this.setState(1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ITask task;
        this.log(4, "Reset " + this.getTaskName());
        if (this.getState() == 2 && (task = this.getTopTask()) != null) {
            task.removeTaskListener(this);
        }
        Byte by = this.taskListLock;
        synchronized (by) {
            this.taskList.clear();
        }
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void taskNotice(String taskName, int status, Object result) {
        if (status == 3) {
            this.notifyListener(taskName, status, result);
            return;
        }
        ITask topTask = this.getTopTask();
        if (topTask != null && topTask.getTaskName().equals(taskName)) {
            switch (status) {
                case 1: {
                    this.log(4, "Finished task: " + topTask.getTaskName() + " in " + this.getTaskName());
                    this.notifyListener(taskName, status, result);
                    break;
                }
                case 2: {
                    this.log(4, "Task timeout: " + topTask.getTaskName() + " in " + this.getTaskName());
                    this.notifyListener(taskName, status, result);
                    break;
                }
                case 0: {
                    this.log(4, "Task error: " + topTask.getTaskName() + " in " + this.getTaskName());
                    this.notifyListener(taskName, status, result);
                }
            }
            Byte by = this.taskListLock;
            synchronized (by) {
                topTask.removeTaskListener(this);
                this.taskList.remove(topTask);
            }
            this.launchTopTask();
        }
    }
}

