/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.inventory.profile;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DISABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DISABLE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_ACCESSSPECS;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_ROSPECS;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_START_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_STOP_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.TaskManager;
import org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.service.EpcglobalLlrpInventoryProfileService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class EpcglobalLlrpInventoryProfile
extends RfidInventoryProfile
implements ProfileService,
EpcglobalLlrpInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.EpcglobalLlrpInventoryProfile";
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration;
    protected CommandService epcglobalLlrpDeviceServiceGetRospecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteRospec;
    protected CommandService epcglobalLlrpDeviceServiceAddRospec;
    protected CommandService epcglobalLlrpDeviceServiceEnableRospec;
    protected CommandService epcglobalLlrpDeviceServiceDisableRospec;
    protected CommandService epcglobalLlrpDeviceServiceStartRospec;
    protected CommandService epcglobalLlrpDeviceServiceStopRospec;
    protected CommandService epcglobalLlrpDeviceServiceGetAccessspecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceAddAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceEnableAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceDisableAccessspec;
    protected SignalService epcglobalLlrpDeviceServiceSetReaderConfigResponse;
    protected SignalService epcglobalLlrpDeviceServiceGetRospecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStartRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStopRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceRoAccessReport;
    protected SignalService epcglobalLlrpDeviceServiceGetAccessspecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableAccessspecResponse;
    private int rOSpecID = 1;
    private int accessSpecID = 1;
    private boolean autonomousModeOn = false;
    private TaskManager taskManager = new TaskManager("org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.EpcglobalLlrpInventoryProfile.TaskManager");
    private ITask getROSpecsTask;
    private ITask deleteROSpecTask;
    private ITask addROSpecTask;
    private ITask enableROSpecTask;
    private ITask disableROSpecTask;
    private ITask startROSpecTask;
    private ITask stopROSpecTask;
    private ITask deleteExistROSpecTask;
    private ITask getAccessSpecTask;
    private ITask deleteAccessSpecTask;
    private ITask enableAccessSpecTask;
    private ITask disableAccessSpecTask;
    private ITask addAccessSpecTask;
    private ITask deleteExistAccessSpecTask;
    private ITaskListener taskListner = new ITaskListener(){

        public void taskNotice(String taskName, int status, Object result) {
            if (status == 0) {
                String errorMsg = LLRPUtils.handleErrorResponse((String)taskName, (Map)((Map)result));
                EpcglobalLlrpInventoryProfile.this.handleError(new RuntimeException(errorMsg), 1);
                return;
            }
            if (status == 1 && taskName.equals("Task_STOP_ROSPEC")) {
                EpcglobalLlrpInventoryProfile.this.setAutonomousModeOn(false);
                return;
            }
        }
    };

    public EpcglobalLlrpInventoryProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        this.taskManager.addTaskListener(this.taskListner);
        this.taskManager.reset();
        this.populateTasks();
        super.activate();
    }

    protected boolean autonomousModeOff() {
        if (this.getDevice() != null && this.getDevice().isStarted() && this.isAutonomousModeOn()) {
            this.taskManager.reset();
            this.taskManager.addTaskToBottom(this.stopROSpecTask, true);
            this.taskManager.addTaskToBottom(this.disableROSpecTask, true);
            this.taskManager.addTaskToBottom(this.disableAccessSpecTask, true);
            return true;
        }
        return false;
    }

    protected boolean autonomousModeOn() {
        if (this.getDevice() != null && this.getDevice().isStarted()) {
            this.taskManager.reset();
            this.initROSpec();
            this.initAccessSpec();
            this.taskManager.addTaskToBottom(this.enableAccessSpecTask, true);
            this.taskManager.addTaskToBottom(this.startROSpecTask, true);
            this.setAutonomousModeOn(true);
            return true;
        }
        return false;
    }

    protected void cleanAccessSpec() {
        this.taskManager.addTaskToBottom(this.deleteExistAccessSpecTask, true);
    }

    protected void cleanROSpec() {
        this.taskManager.addTaskToBottom(this.deleteExistROSpecTask, true);
    }

    private Integer extractAntennaId(Map antennaIdParam) {
        if (antennaIdParam != null) {
            return (Integer)antennaIdParam.get("AntennaID");
        }
        return null;
    }

    private Integer extractTagSeenCount(Map tagSeenCountParam) {
        if (tagSeenCountParam != null) {
            return (Integer)tagSeenCountParam.get("TagCount");
        }
        return null;
    }

    protected Map getAISpecParameter(int[] antennaIds) {
        ArrayList<Map> inventoryParameterSpecParameters = new ArrayList<Map>();
        inventoryParameterSpecParameters.add(ParameterFactory.getInventoryParameterSpecParameter((int)12345, (int)1));
        return ParameterFactory.getAISpecParameter((int[])antennaIds, (Map)ParameterFactory.getAISpecStopTriggerParameter((int)0, (int)0, null, null), inventoryParameterSpecParameters);
    }

    protected Map getAccessCommandParameter() {
        ArrayList<Map> tagSpecs = new ArrayList<Map>();
        tagSpecs.add(this.getC1G2TagSpecParameter());
        ArrayList<Map> accessCmdOps = new ArrayList<Map>();
        accessCmdOps.add(ParameterFactory.getC1G2ReadParameter((int)1, (int)0, (int)3, (int)0, (int)2));
        accessCmdOps.add(ParameterFactory.getC1G2ReadParameter((int)2, (int)0, (int)2, (int)0, (int)2));
        return ParameterFactory.getAccessCommandParameter(tagSpecs, accessCmdOps);
    }

    public int getAccessSpecID() {
        return this.accessSpecID;
    }

    protected Map getAddAccessSpecCommandParameters(int accessSpecId) {
        return ParameterFactory.getAddAccessSpecCommandParameters((int)accessSpecId, (int)0, (int)1, (int)0, (int)this.getROSpecID(), (Map)ParameterFactory.getAccessSpecStopTriggerParameter((int)0, (int)0), (Map)this.getAccessCommandParameter(), (Map)ParameterFactory.getAccessReportSpecParameter((int)1));
    }

    protected Map getAddROSpecCommandParameters(int rospecId) {
        Map rOBoundarySpecParameter = this.getROBoundarySpecParameter();
        ArrayList<Map> specParameterChoice = new ArrayList<Map>();
        specParameterChoice.add(this.getAISpecParameter(new int[1]));
        Map rOReportSpecParameter = this.getROReportSpecParameter(0, 1);
        return ParameterFactory.getAddROSpecCommandParameters((int)rospecId, (int)0, (int)0, (Map)rOBoundarySpecParameter, specParameterChoice, (Map)rOReportSpecParameter);
    }

    protected Map getC1G2TagSpecParameter() {
        return ParameterFactory.getC1G2TagSpecParameter((Map)ParameterFactory.getC1G2TargetTagParameter((int)1, (boolean)true, (int)32, (String)"00,00,00,00,00,00,00,00,00,00,00,00", (String)"00,00,00,00,00,00,00,00,00,00,00,00"));
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)EpcglobalLlrpInventoryProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice");
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpInventoryProfile";
    }

    protected Map getROBoundarySpecParameter() {
        return ParameterFactory.getROBoundarySpecParameter((Map)ParameterFactory.getROSpecStartTriggerParameter((int)0), (Map)ParameterFactory.getROSpecStopTriggerParameter((int)0, (int)0));
    }

    protected Map getROReportSpecParameter(int trigger, int tagNum) {
        return ParameterFactory.getROReportSpecParameter((int)trigger, (int)tagNum, (Map)ParameterFactory.getTagReportContentSelectorParameter());
    }

    public int getROSpecID() {
        return this.rOSpecID;
    }

    private void handleEpcglobalLlrpDeviceServiceRoAccessReport(SignalService source, Object timestamp, Object data) {
        Map paramMap = (Map)data;
        if (!this.isAutonomousModeOn()) {
            this.handleError(new RuntimeException("Receive tag report after the ROSpec is stopped."), 3008);
        } else {
            List tagReportDataParams = (List)paramMap.get("TagReportDataParameter");
            if (tagReportDataParams != null) {
                this.log(4, "LLRP Inventory profile, tags in the report: " + tagReportDataParams.size());
                int i = 0;
                while (i < tagReportDataParams.size()) {
                    Integer tagSeenCount;
                    Map tagReportData = (Map)tagReportDataParams.get(i);
                    String tag = LLRPUtils.extractTag((Map)((Map)tagReportData.get("EPCParameterChoice")));
                    Integer antennaId = this.extractAntennaId((Map)tagReportData.get("AntennaIDParameter"));
                    if (tag == null) {
                        this.handleError(new NullPointerException("EPC is null"), 3008);
                    }
                    if ((tagSeenCount = this.extractTagSeenCount((Map)tagReportData.get("TagSeenCountParameter"))) == null) {
                        tagSeenCount = new Integer(1);
                    }
                    Hashtable<String, Object> readData = new Hashtable<String, Object>();
                    if (antennaId != null) {
                        readData.put("antenna", antennaId);
                    }
                    readData.put("reader", this.getId());
                    readData.put("timestampFirst", timestamp);
                    readData.put("timestampLast", timestamp);
                    readData.put("count", tagSeenCount);
                    List accessCommandOpSpecResultChoices = (List)tagReportData.get("AccessCommandOpSpecResultChoice");
                    if (accessCommandOpSpecResultChoices != null) {
                        int j = 0;
                        while (j < accessCommandOpSpecResultChoices.size()) {
                            Map resultParam = (Map)accessCommandOpSpecResultChoices.get(j);
                            String key = (String)resultParam.get("key");
                            if ("C1G2ReadOpSpecResultParameter".equals(key)) {
                                List readDatas = (List)resultParam.get("ReadDatas");
                                byte[] readDataBytes = LLRPUtils.convertIntListToBytes((List)readDatas);
                                int opSpecId = (Integer)resultParam.get("OpSpecID");
                                switch (opSpecId) {
                                    case 1: {
                                        readData.put("userdata", readDataBytes);
                                        break;
                                    }
                                    case 2: {
                                        readData.put("tid", readDataBytes);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (tag != null) {
                        this.notifyTagRead(tag.toString(), readData);
                    }
                    ++i;
                }
            }
        }
    }

    protected void initAccessSpec() {
        this.taskManager.addTaskToBottom(this.deleteExistAccessSpecTask, true);
        this.taskManager.addTaskToBottom(this.addAccessSpecTask, true);
    }

    protected void initROSpec() {
        this.taskManager.addTaskToBottom(this.deleteExistROSpecTask, true);
        this.taskManager.addTaskToBottom(this.addROSpecTask, true);
        this.taskManager.addTaskToBottom(this.enableROSpecTask, true);
    }

    private void initialize() {
    }

    public boolean isAutonomousModeOn() {
        return this.autonomousModeOn;
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    protected void populateTasks() {
        Map rospecIdParameter = ParameterFactory.getROSpecIDParameter((int)this.getROSpecID());
        this.getROSpecsTask = new Task_GET_ROSPECS(this.epcglobalLlrpDeviceServiceGetRospecs, null, this.epcglobalLlrpDeviceServiceGetRospecsResponse);
        this.deleteROSpecTask = new Task_DELETE_ROSPEC(this.epcglobalLlrpDeviceServiceDeleteRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceDeleteRospecResponse);
        this.deleteExistROSpecTask = new Task_DELETE_EXIST_ROSPEC((Task_GET_ROSPECS)this.getROSpecsTask, (Task_DELETE_ROSPEC)this.deleteROSpecTask);
        this.addROSpecTask = new Task_ADD_ROSPEC(this.epcglobalLlrpDeviceServiceAddRospec, this.getAddROSpecCommandParameters(this.getROSpecID()), this.epcglobalLlrpDeviceServiceAddRospecResponse);
        this.enableROSpecTask = new Task_ENABLE_ROSPEC(this.epcglobalLlrpDeviceServiceEnableRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceEnableRospecResponse);
        this.disableROSpecTask = new Task_DISABLE_ROSPEC(this.epcglobalLlrpDeviceServiceDisableRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceDisableRospecResponse);
        this.startROSpecTask = new Task_START_ROSPEC(this.epcglobalLlrpDeviceServiceStartRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceStartRospecResponse);
        this.stopROSpecTask = new Task_STOP_ROSPEC(this.epcglobalLlrpDeviceServiceStopRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceStopRospecResponse);
        Map accessspecIdParameter = ParameterFactory.getAccessSpecIDParameter((int)this.getAccessSpecID());
        this.getAccessSpecTask = new Task_GET_ACCESSSPECS(this.epcglobalLlrpDeviceServiceGetAccessspecs, null, this.epcglobalLlrpDeviceServiceGetAccessspecsResponse);
        this.deleteAccessSpecTask = new Task_DELETE_ACCESSSPEC(this.epcglobalLlrpDeviceServiceDeleteAccessspec, accessspecIdParameter, this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse);
        this.addAccessSpecTask = new Task_ADD_ACCESSSPEC(this.epcglobalLlrpDeviceServiceAddAccessspec, this.getAddAccessSpecCommandParameters(this.getAccessSpecID()), this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
        this.enableAccessSpecTask = new Task_ENABLE_ACCESSSPEC(this.epcglobalLlrpDeviceServiceEnableAccessspec, accessspecIdParameter, this.epcglobalLlrpDeviceServiceEnableAccessspecResponse);
        this.disableAccessSpecTask = new Task_DISABLE_ACCESSSPEC(this.epcglobalLlrpDeviceServiceDisableAccessspec, accessspecIdParameter, this.epcglobalLlrpDeviceServiceDisableAccessspecResponse);
        this.deleteExistAccessSpecTask = new Task_DELETE_EXIST_ACCESSSPEC((Task_GET_ACCESSSPECS)this.getAccessSpecTask, (Task_DELETE_ACCESSSPEC)this.deleteAccessSpecTask);
    }

    public void setAccessSpecID(int AccessSpecID) {
        this.accessSpecID = AccessSpecID;
    }

    public void setAutonomousModeOn(boolean autonomousModeOn) {
        this.autonomousModeOn = autonomousModeOn;
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecs != null) {
                this.epcglobalLlrpDeviceServiceGetRospecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospec != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospec != null) {
                this.epcglobalLlrpDeviceServiceAddRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospec != null) {
                this.epcglobalLlrpDeviceServiceEnableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospec != null) {
                this.epcglobalLlrpDeviceServiceDisableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospec != null) {
                this.epcglobalLlrpDeviceServiceStartRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospec != null) {
                this.epcglobalLlrpDeviceServiceStopRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecs != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspec != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfigResponse != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfigResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetRospecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStartRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStopRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceRoAccessReport != null) {
                this.epcglobalLlrpDeviceServiceRoAccessReport.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory = device.getCommand("SetReaderConfig_ForInventory");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration = device.getCommand("SetReaderConfig_AntennaConfiguration");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration);
            this.epcglobalLlrpDeviceServiceGetRospecs = device.getCommand("GetRospecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetRospecs);
            this.epcglobalLlrpDeviceServiceDeleteRospec = device.getCommand("DeleteRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteRospec);
            this.epcglobalLlrpDeviceServiceAddRospec = device.getCommand("AddRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddRospec);
            this.epcglobalLlrpDeviceServiceEnableRospec = device.getCommand("EnableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableRospec);
            this.epcglobalLlrpDeviceServiceDisableRospec = device.getCommand("DisableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableRospec);
            this.epcglobalLlrpDeviceServiceStartRospec = device.getCommand("StartRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStartRospec);
            this.epcglobalLlrpDeviceServiceStopRospec = device.getCommand("StopRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStopRospec);
            this.epcglobalLlrpDeviceServiceGetAccessspecs = device.getCommand("GetAccessspecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetAccessspecs);
            this.epcglobalLlrpDeviceServiceDeleteAccessspec = device.getCommand("DeleteAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteAccessspec);
            this.epcglobalLlrpDeviceServiceAddAccessspec = device.getCommand("AddAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddAccessspec);
            this.epcglobalLlrpDeviceServiceEnableAccessspec = device.getCommand("EnableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableAccessspec);
            this.epcglobalLlrpDeviceServiceDisableAccessspec = device.getCommand("DisableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableAccessspec);
            this.epcglobalLlrpDeviceServiceSetReaderConfigResponse = device.getSignal("SetReaderConfigResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceSetReaderConfigResponse);
            this.epcglobalLlrpDeviceServiceGetRospecsResponse = device.getSignal("GetRospecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetRospecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteRospecResponse = device.getSignal("DeleteRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteRospecResponse);
            this.epcglobalLlrpDeviceServiceAddRospecResponse = device.getSignal("AddRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddRospecResponse);
            this.epcglobalLlrpDeviceServiceEnableRospecResponse = device.getSignal("EnableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableRospecResponse);
            this.epcglobalLlrpDeviceServiceDisableRospecResponse = device.getSignal("DisableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableRospecResponse);
            this.epcglobalLlrpDeviceServiceStartRospecResponse = device.getSignal("StartRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStartRospecResponse);
            this.epcglobalLlrpDeviceServiceStopRospecResponse = device.getSignal("StopRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStopRospecResponse);
            this.epcglobalLlrpDeviceServiceRoAccessReport = device.getSignal("RoAccessReport");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceRoAccessReport);
            this.epcglobalLlrpDeviceServiceGetAccessspecsResponse = device.getSignal("GetAccessspecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetAccessspecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse = device.getSignal("DeleteAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse);
            this.epcglobalLlrpDeviceServiceAddAccessspecResponse = device.getSignal("AddAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
            this.epcglobalLlrpDeviceServiceEnableAccessspecResponse = device.getSignal("EnableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableAccessspecResponse);
            this.epcglobalLlrpDeviceServiceDisableAccessspecResponse = device.getSignal("DisableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableAccessspecResponse);
        }
        super.setDevice(device);
    }

    public void setROSpecID(int ROSpecID) {
        this.rOSpecID = ROSpecID;
    }

    public void setup() {
        super.setup();
        this.setROSpecID(this.getInt("epcgloballlrpinventoryprofile.ROSpecID", this.getROSpecID()));
        this.setAccessSpecID(this.getInt("epcgloballlrpinventoryprofile.AccessSpecID", this.getAccessSpecID()));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.epcglobalLlrpDeviceServiceRoAccessReport == source) {
            this.handleEpcglobalLlrpDeviceServiceRoAccessReport(source, timestamp, data);
            return;
        }
        this.taskManager.handleResponse(source, timestamp, data);
    }
}

