/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.WriteProfileServlet;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.service.http.HttpService;

public class WriteProfileConsole
extends BaseBundleActivator
implements NotificationListener {
    private WriteProfileServlet writeProfileServlet;
    private final String writeOperationRequestTopic = "/RfidWrite/WriteOperationsExecuteRequest/execute";
    private final String writeOperationStopTopic = "/RfidWrite/WriteOperationsStopRequest/execute";
    private final String tagWriteMaskSettingTopic = "/RfidWrite/TagWriteMaskSetting/write";
    private final String writeOperationsTopic = "/RfidWrite/WriteOperations/write";
    private final String tagWriteReportTopic = "/RfidWrite/TagWriteReport";
    private final String tagWriteAggregationTopic = "/RfidWrite/TagWriteAggregationReport";
    private final String tagWriteMaskSetting = "/RfidWrite/TagWriteMaskSetting/write";
    private final String tagAggregationWriteMaskSetting = "/RfidWrite/TagAggregationWriteMaskSetting/write";
    private final String tagWriteAggregating = "/RfidWrite/TagWriteAggregating/write";
    private final List reports = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void activate() {
        this.writeProfileServlet = new WriteProfileServlet();
        this.writeProfileServlet.bind(this.getHttpService(), this);
    }

    private HttpService getHttpService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (HttpService)this.getImportedService(clazz.getName());
    }

    protected String[] getImportedServiceNames() {
        return new String[]{"org.osgi.service.http.HttpService", "org.eclipse.soda.dk.notification.service.NotificationService"};
    }

    private NotificationService getNotificationService() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.dk.notification.service.NotificationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (NotificationService)this.getImportedService(clazz.getName());
    }

    protected InputStream getPropertiesInputStream() throws IOException {
        return this.getResourcePropertiesInputStream();
    }

    public List getReports() {
        return this.reports;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        Map tags;
        System.out.println("Receive tag report: " + externalKey);
        Map tagWriteReport = (Map)data.get("value");
        if (tagWriteReport != null && (tags = (Map)tagWriteReport.get("tags")) != null) {
            this.reports.add(tags);
        }
    }

    protected void sendRequest(String topic, Object request) {
        Hashtable<String, Object> value = new Hashtable<String, Object>();
        value.put("value", request);
        this.getNotificationService().broadcast(topic, value);
    }

    public void sendTagAggregating(String prefix, Boolean request) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagWriteAggregating/write", request);
    }

    public void sendTagAggregationMaskSetting(String prefix, String mask) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagAggregationWriteMaskSetting/write", mask);
    }

    public void sendTagWriteMaskSetting(String prefix, String mask) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagWriteMaskSetting/write", mask);
    }

    public void sendTagWriteMaskSettingRequest(String prefix, Map tagWriteMaskSettingParameter) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagWriteMaskSetting/write", tagWriteMaskSettingParameter);
    }

    public void sendWriteOperationsExecuteRequest(String prefix, String request) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/WriteOperationsExecuteRequest/execute", request);
        this.reports.clear();
    }

    public void sendWriteOperationsRequest(String prefix, String writeOperationsParameter) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/WriteOperations/write", writeOperationsParameter);
        this.getNotificationService().register(String.valueOf(prefix) + "/RfidWrite/TagWriteReport", (NotificationListener)this);
        this.getNotificationService().register(String.valueOf(prefix) + "/RfidWrite/TagWriteAggregationReport", (NotificationListener)this);
    }

    public void sendWriteOperationsStopRequest(String prefix, String request) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/WriteOperationsStopRequest/execute", request);
    }
}

