/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.write.profile;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_Array;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_BLOCKERASE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_BLOCKWRITE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_ACCESSSPECS;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_ROSPECS;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_INCREMENT_WRITE;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_KILL_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_LOCK_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_READ_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_START_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_STOP_EXIST_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_STOP_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_WRITE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.TaskManager;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.service.EpcglobalLlrpWriteProfileService;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.write.profile.RfidWriteProfile;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class EpcglobalLlrpWriteProfile
extends RfidWriteProfile
implements ProfileService,
EpcglobalLlrpWriteProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.write.profile.EpcglobalLlrpWriteProfile";
    private static final String TASKARRAY_STOP_ROSPEC = "TaskArray_Stop_ROSPEC";
    private static final String TASKARRAY_START_ROSPEC = "TaskArray_Start_ROSPEC";
    private static final long DEFAULT_TASK_TIMEOUT = 5000L;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration;
    protected CommandService epcglobalLlrpDeviceServiceGetRospecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteRospec;
    protected CommandService epcglobalLlrpDeviceServiceAddRospec;
    protected CommandService epcglobalLlrpDeviceServiceEnableRospec;
    protected CommandService epcglobalLlrpDeviceServiceDisableRospec;
    protected CommandService epcglobalLlrpDeviceServiceStartRospec;
    protected CommandService epcglobalLlrpDeviceServiceStopRospec;
    protected CommandService epcglobalLlrpDeviceServiceGetAccessspecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceAddAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceEnableAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceDisableAccessspec;
    protected SignalService epcglobalLlrpDeviceServiceSetReaderConfigResponse;
    protected SignalService epcglobalLlrpDeviceServiceGetRospecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStartRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStopRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceRoAccessReport;
    protected SignalService epcglobalLlrpDeviceServiceGetAccessspecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableAccessspecResponse;
    private int rOSpecID = 1;
    private int accessSpecID = 1;
    private short accessOpId = 0;
    private final Byte accessOpIdLock = new Byte(0);
    private TaskManager taskManager = new TaskManager("org.eclipse.soda.dk.epcglobal.llrp.write.profile.EpcglobalLlrpWriteProfile.TaskManager");
    private Task_ENABLE_ACCESSSPEC enableAccessSpecTask;
    private Task_Array stopROSpecTaskArray;
    private Task_Array startROSpecTaskArray;
    private Map targetTagFilterParameters;
    private ITaskListener taskListner = new ITaskListener(){

        public void taskNotice(String taskName, int status, Object result) {
            if (taskName.equals(EpcglobalLlrpWriteProfile.TASKARRAY_START_ROSPEC)) {
                switch (status) {
                    case 0: 
                    case 2: {
                        EpcglobalLlrpWriteProfile.this.startOperationsFailed(this.getErrorMsg(taskName, result));
                        return;
                    }
                }
            }
            if (taskName.equals(EpcglobalLlrpWriteProfile.TASKARRAY_STOP_ROSPEC)) {
                switch (status) {
                    case 0: 
                    case 2: {
                        EpcglobalLlrpWriteProfile.this.stopOperationsFailed(this.getErrorMsg(taskName, result));
                        return;
                    }
                    case 1: {
                        EpcglobalLlrpWriteProfile.this.stopOperationsSucceeded();
                        return;
                    }
                }
            }
            if (taskName.equals("Task_Read_Tag") || taskName.equals("Task_Write_Tag") || taskName.equals("Task_INCREMENT_WRITE") || taskName.equals("Task_Kill_Tag") || taskName.equals("Task_Lock_Tag") || taskName.equals("Task_BlockErase_Tag") || taskName.equals("Task_BlockWrite_Tag")) {
                switch (status) {
                    case 0: {
                        EpcglobalLlrpWriteProfile.this.log(4, this.getErrorMsg(taskName, result));
                        return;
                    }
                    case 2: {
                        EpcglobalLlrpWriteProfile.this.log(4, String.valueOf(taskName) + " timeout.");
                        return;
                    }
                    case 1: {
                        EpcglobalLlrpWriteProfile.this.log(4, String.valueOf(taskName) + " finished.");
                        return;
                    }
                    case 3: {
                        EpcglobalLlrpWriteProfile.this.log(4, String.valueOf(taskName) + " reports.");
                        if (result != null && result instanceof Map) {
                            EpcglobalLlrpWriteProfile.this.sendTagReport((Map)result, true);
                        }
                        return;
                    }
                }
            }
        }

        private String getErrorMsg(String taskName, Object result) {
            return result == null ? "Task Error: " + taskName : (result instanceof Map ? LLRPUtils.handleErrorResponse((String)taskName, (Map)((Map)result)) : result.toString());
        }
    };

    public EpcglobalLlrpWriteProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        this.taskManager.addTaskListener(this.taskListner);
        this.taskManager.reset();
        this.populateTasks();
        super.activate();
    }

    protected void endOperations() {
        if (this.isOperationsRunning()) {
            this.taskManager.addTaskToBottom((ITask)this.stopROSpecTaskArray, true);
        }
    }

    protected boolean executeBlockErase(String[] op_params) {
        if (op_params.length != 7 && op_params.length != 8) {
            this.handleError(new RuntimeException("Invalid parameters number for the BlockErase command: " + op_params.length + ",Format: " + "BlockErase;MemoryBank;WordPointer;WordCount;Password;OpCount;Timeout[;OperationId]"), 3008);
            return false;
        }
        if (this.getTargetTagFilterParameters() == null) {
            this.handleError(new RuntimeException("Target Tag Filter can't be NULL for BlockErase"), 3008);
            return false;
        }
        int memoryBank = Integer.valueOf(op_params[1]);
        int wordPointer = Integer.valueOf(op_params[2]);
        int wordCount = Integer.valueOf(op_params[3]);
        int password = Integer.valueOf(op_params[4]);
        int opCount = Integer.valueOf(op_params[5]);
        long timeout = Long.valueOf(op_params[6]);
        short opId = this.getCurrAccessOpId();
        String operationId = op_params.length == 8 ? op_params[7] : String.valueOf(opId);
        Map blockEraseOpParameters = ParameterFactory.getC1G2BlockEraseParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (int)wordCount);
        Task_BLOCKERASE_TAG blockEraseTagTask = new Task_BLOCKERASE_TAG((int)opId, opCount, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters(), blockEraseOpParameters, 0), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
        this.taskManager.addTaskToBottom((ITask)blockEraseTagTask, true);
        return true;
    }

    protected boolean executeBlockWrite(String[] op_params) {
        if (op_params.length != 7 && op_params.length != 8) {
            this.handleError(new RuntimeException("Invalid parameters number for the BlockWrite command: " + op_params.length + ",Format: " + "BlockWrite;MemoryBank;WordPointer;WriteData;Password;OpCount;Timeout[;OperationId]"), 3008);
            return false;
        }
        if (this.getTargetTagFilterParameters() == null) {
            this.handleError(new RuntimeException("Target Tag Filter can't be NULL for BlockWrite"), 3008);
            return false;
        }
        try {
            int memoryBank = Integer.valueOf(op_params[1]);
            int wordPointer = Integer.valueOf(op_params[2]);
            String writeData = op_params[3];
            int password = Integer.valueOf(op_params[4]);
            int opCount = Integer.valueOf(op_params[5]);
            long timeout = Long.valueOf(op_params[6]);
            short opId = this.getCurrAccessOpId();
            String operationId = op_params.length == 8 ? op_params[7] : String.valueOf(opId);
            Map writeOpParameters = ParameterFactory.getC1G2BlockWriteParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (String)writeData);
            Task_BLOCKWRITE_TAG writeTagTask = new Task_BLOCKWRITE_TAG((int)opId, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters(), writeOpParameters, opCount), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
            this.taskManager.addTaskToBottom((ITask)writeTagTask, true);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleError(e, 3008);
            return false;
        }
    }

    protected boolean executeCleanFilter(String[] op_params) {
        this.setTargetTagFilterParameters(null);
        return true;
    }

    protected boolean executeFilter(String[] op_params) {
        if (op_params.length != 6 && op_params.length != 11) {
            this.handleError(new RuntimeException("Invalid parameters number for the Set Filter command: " + op_params.length + ",Format: " + "Filter;MemoryBank;Match;BitPointer;TagMask;TagData[;MemoryBank;Match;BitPointer;TagMask;TagData]"), 3008);
            return false;
        }
        try {
            int targetTag1_memoryBank = Integer.valueOf(op_params[1]);
            boolean targetTag1_match = Boolean.valueOf(op_params[2]);
            int targetTag1_pointer = Integer.valueOf(op_params[3]);
            String targetTag1_tagMask = op_params[4];
            String targetTag1_tagData = op_params[5];
            Map c1G2TargetTag1Params = ParameterFactory.getC1G2TargetTagParameter((int)targetTag1_memoryBank, (boolean)targetTag1_match, (int)targetTag1_pointer, (String)targetTag1_tagMask, (String)targetTag1_tagData);
            switch (op_params.length) {
                case 11: {
                    int targetTag2_memoryBank = Integer.valueOf(op_params[6]);
                    boolean targetTag2_match = Boolean.valueOf(op_params[7]);
                    int targetTag2_pointer = Integer.valueOf(op_params[8]);
                    String targetTag2_tagMask = op_params[9];
                    String targetTag2_tagData = op_params[10];
                    Map c1G2TargetTag2Params = ParameterFactory.getC1G2TargetTagParameter((int)targetTag2_memoryBank, (boolean)targetTag2_match, (int)targetTag2_pointer, (String)targetTag2_tagMask, (String)targetTag2_tagData);
                    this.setTargetTagFilterParameters(ParameterFactory.getC1G2TagSpecParameter((Map)c1G2TargetTag1Params, (Map)c1G2TargetTag2Params));
                    break;
                }
                case 6: {
                    this.setTargetTagFilterParameters(ParameterFactory.getC1G2TagSpecParameter((Map)c1G2TargetTag1Params));
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.handleError(e, 3008);
            return false;
        }
    }

    protected boolean executeIncrementWrite(String[] op_params) {
        if (op_params.length != 8 && op_params.length != 9) {
            this.handleError(new RuntimeException("Invalid parameters number for the Increment Write command: " + op_params.length + ",Format: " + "Increment Write;MemoryBank;WordPointer;WriteData;Increment;Password;Repeat;Timeout[;OperationId]"), 3008);
            return false;
        }
        if (this.getTargetTagFilterParameters() == null) {
            this.handleError(new RuntimeException("Target Tag Filter can't be NULL for Increment Write"), 3008);
            return false;
        }
        try {
            int memoryBank = Integer.valueOf(op_params[1]);
            String baseWriteData = op_params[3];
            int wordPointer = Integer.valueOf(op_params[2]);
            int increment = Integer.valueOf(op_params[4]);
            int repeat = Integer.valueOf(op_params[6]);
            long timeout = Long.valueOf(op_params[7]);
            int password = Integer.valueOf(op_params[5]);
            short writeOpId = this.getCurrAccessOpId();
            String operationId = op_params.length == 9 ? op_params[8] : String.valueOf(writeOpId);
            Map incrementWriteOpParameters = ParameterFactory.getAccessCommandParameter((Map)this.getTargetTagFilterParameters(), new ArrayList());
            Task_INCREMENT_WRITE incrementWriteTask = new Task_INCREMENT_WRITE((int)writeOpId, memoryBank, wordPointer, password, baseWriteData, increment, repeat, timeout, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters(), incrementWriteOpParameters, 1), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, operationId);
            this.taskManager.addTaskToBottom((ITask)incrementWriteTask, true);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleError(e, 3008);
            return false;
        }
    }

    protected boolean executeKill(String[] op_params) {
        if (op_params.length != 4 && op_params.length != 5) {
            this.handleError(new RuntimeException("Invalid parameters number for the Kill command: " + op_params.length + ",Format: " + "Kill;Password;OpCount;Timeout[;OperationId]"), 3008);
            return false;
        }
        try {
            int password = Integer.valueOf(op_params[1]);
            int opCount = Integer.valueOf(op_params[2]);
            long timeout = Long.valueOf(op_params[3]);
            short opId = this.getCurrAccessOpId();
            String operationId = op_params.length == 5 ? op_params[4] : String.valueOf(opId);
            Map killOpParameters = ParameterFactory.getC1G2KillParameter((int)opId, (int)password);
            Task_KILL_TAG killTagTask = new Task_KILL_TAG((int)opId, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters(), killOpParameters, opCount), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
            this.taskManager.addTaskToBottom((ITask)killTagTask, true);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleError(e, 3008);
            return false;
        }
    }

    protected boolean executeLock(String[] op_params) {
        if (op_params.length < 6) {
            this.handleError(new RuntimeException("Invalid parameters number for the Lock command: " + op_params.length + ",Format: " + "Lock;Password;OpCount;Timeout;Privilege;DataField[;Privilege;DataField...][;OperationId]"), 3008);
            return false;
        }
        try {
            int password = Integer.valueOf(op_params[1]);
            int opCount = Integer.valueOf(op_params[2]);
            long timeout = Long.valueOf(op_params[3]);
            short opId = this.getCurrAccessOpId();
            String operationId = String.valueOf(opId);
            int privilege = Integer.valueOf(op_params[4]);
            int datafield = Integer.valueOf(op_params[5]);
            ArrayList<Map> payloadParameter = new ArrayList<Map>();
            payloadParameter.add(ParameterFactory.getC1G2LockPayloadParameter((int)privilege, (int)datafield));
            int current_index = 6;
            while (op_params.length - current_index > 0) {
                if (op_params.length - current_index >= 2) {
                    privilege = Integer.valueOf(op_params[current_index++]);
                    datafield = Integer.valueOf(op_params[current_index++]);
                    payloadParameter.add(ParameterFactory.getC1G2LockPayloadParameter((int)privilege, (int)datafield));
                    continue;
                }
                operationId = op_params[current_index++];
            }
            Map lockOpParameters = ParameterFactory.getC1G2LockParameter((int)opId, (int)password, payloadParameter);
            Task_LOCK_TAG lockTagTask = new Task_LOCK_TAG((int)opId, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters(), lockOpParameters, opCount), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
            this.taskManager.addTaskToBottom((ITask)lockTagTask, true);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleError(e, 3008);
            return false;
        }
    }

    protected boolean executeRead(String[] op_params) {
        if (op_params.length != 7 && op_params.length != 8) {
            this.handleError(new RuntimeException("Invalid parameters number for the Read command: " + op_params.length + ",Format: " + "Read;MemoryBank;WordPointer;WordCount;Password;OpCount;Timeout[;OperationId]"), 3008);
            return false;
        }
        int memoryBank = Integer.valueOf(op_params[1]);
        int wordPointer = Integer.valueOf(op_params[2]);
        int wordCount = Integer.valueOf(op_params[3]);
        int password = Integer.valueOf(op_params[4]);
        int opCount = Integer.valueOf(op_params[5]);
        long timeout = Long.valueOf(op_params[6]);
        short opId = this.getCurrAccessOpId();
        String operationId = op_params.length == 8 ? op_params[7] : String.valueOf(opId);
        Map readOpParameters = ParameterFactory.getC1G2ReadParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (int)wordCount);
        Task_READ_TAG readTagTask = new Task_READ_TAG((int)opId, opCount, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters() != null ? this.getTargetTagFilterParameters() : ParameterFactory.getC1G2TagSpecParameter((Map)ParameterFactory.getC1G2TargetTagParameter((int)1, (boolean)true, (int)32, (String)"00,00,00,00,00,00,00,00,00,00,00,00", (String)"00,00,00,00,00,00,00,00,00,00,00,00")), readOpParameters, 0), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
        this.taskManager.addTaskToBottom((ITask)readTagTask, true);
        return true;
    }

    protected void executeStop() {
        this.log(4, "Stop all the WriteOperations.");
        this.resetTaskManager();
        this.endOperations();
    }

    protected boolean executeWrite(String[] op_params) {
        if (op_params.length != 7 && op_params.length != 8) {
            this.handleError(new RuntimeException("Invalid parameters number for the Write command: " + op_params.length + ",Format: " + "Write;MemoryBank;WordPointer;WriteData;Password;OpCount;Timeout[;OperationId]"), 3008);
            return false;
        }
        if (this.getTargetTagFilterParameters() == null) {
            this.handleError(new RuntimeException("Target Tag Filter can't be NULL for Write"), 3008);
            return false;
        }
        try {
            int memoryBank = Integer.valueOf(op_params[1]);
            int wordPointer = Integer.valueOf(op_params[2]);
            String writeData = op_params[3];
            int password = Integer.valueOf(op_params[4]);
            int opCount = Integer.valueOf(op_params[5]);
            long timeout = Long.valueOf(op_params[6]);
            short opId = this.getCurrAccessOpId();
            String operationId = op_params.length == 8 ? op_params[7] : String.valueOf(opId);
            Map writeOpParameters = ParameterFactory.getC1G2WriteParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (String)writeData);
            Task_WRITE_TAG writeTagTask = new Task_WRITE_TAG((int)opId, this.getTask_DELETE_EXIST_ACCESSSPEC(), this.getAddAccessSpecTask(this.getTargetTagFilterParameters(), writeOpParameters, opCount), this.enableAccessSpecTask, this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
            this.taskManager.addTaskToBottom((ITask)writeTagTask, true);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleError(e, 3008);
            return false;
        }
    }

    protected Map getAISpecParameter(int[] antennaIds) {
        ArrayList<Map> inventoryParameterSpecParameters = new ArrayList<Map>();
        inventoryParameterSpecParameters.add(ParameterFactory.getInventoryParameterSpecParameter((int)12345, (int)1));
        return ParameterFactory.getAISpecParameter((int[])antennaIds, (Map)ParameterFactory.getAISpecStopTriggerParameter((int)0, (int)0, null, null), inventoryParameterSpecParameters);
    }

    public int getAccessSpecID() {
        return this.accessSpecID;
    }

    protected Task_ADD_ACCESSSPEC getAddAccessSpecTask(Map targetTagFilterParameters, Map accessOpParameters, int opCount) {
        Map accessLockCommandParameter = ParameterFactory.getAccessCommandParameter((Map)targetTagFilterParameters, (Map)accessOpParameters);
        Map addAccessSpecCommandParameter = ParameterFactory.getAddAccessSpecCommandParameters((int)this.getAccessSpecID(), (int)this.getOpAntennaId(), (int)this.getAirProtocol(), (int)0, (int)this.getROSpecID(), (Map)ParameterFactory.getAccessSpecStopTriggerParameter((int)1, (int)opCount), (Map)accessLockCommandParameter, (Map)ParameterFactory.getAccessReportSpecParameter((int)1));
        Task_ADD_ACCESSSPEC addAccessSpecTask = new Task_ADD_ACCESSSPEC(this.epcglobalLlrpDeviceServiceAddAccessspec, addAccessSpecCommandParameter, this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
        return addAccessSpecTask;
    }

    protected Map getAddROSpecCommandParameters(int rospecId) {
        Map rOBoundarySpecParameter = ParameterFactory.getROBoundarySpecParameter((Map)ParameterFactory.getROSpecStartTriggerParameter((int)0), (Map)ParameterFactory.getROSpecStopTriggerParameter((int)0, (int)0));
        ArrayList<Map> specParameterChoice = new ArrayList<Map>();
        specParameterChoice.add(this.getAISpecParameter(new int[1]));
        Map rOReportSpecParameter = ParameterFactory.getROReportSpecParameter((int)0, (int)1, (Map)ParameterFactory.getTagReportContentSelectorParameter());
        return ParameterFactory.getAddROSpecCommandParameters((int)rospecId, (int)0, (int)0, (Map)rOBoundarySpecParameter, specParameterChoice, (Map)rOReportSpecParameter);
    }

    protected int getAirProtocol() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCurrAccessOpId() {
        Byte by = this.accessOpIdLock;
        synchronized (by) {
            this.accessOpId = this.accessOpId < Short.MAX_VALUE ? (short)(this.accessOpId + 1) : (short)0;
            return this.accessOpId;
        }
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)EpcglobalLlrpWriteProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice");
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpWriteProfile";
    }

    protected int getOpAntennaId() {
        MeasurementService antennaConfiguration = this.getAntennaConfiguration();
        Map antennaConfigs = (Map)antennaConfiguration.getValue();
        int antennaId_enabled = 0;
        if (antennaConfigs != null) {
            Iterator ids = antennaConfigs.keySet().iterator();
            while (ids.hasNext()) {
                Boolean enabled;
                Integer antennaId = (Integer)ids.next();
                Map antennaConfig = (Map)antennaConfigs.get(antennaId);
                if (antennaConfig == null || (enabled = (Boolean)antennaConfig.get("ANTENNA_ENABLED")) == null || !enabled.booleanValue() || antennaId_enabled != 0) continue;
                antennaId_enabled = antennaId;
            }
        }
        return antennaId_enabled;
    }

    public int getROSpecID() {
        return this.rOSpecID;
    }

    private Map getReportReadData(Integer tagSeenCount, Integer antennaId, Object timestamp, Integer resultCode) {
        Hashtable<String, Object> readData = new Hashtable<String, Object>();
        if (antennaId != null) {
            readData.put("antenna", antennaId);
        }
        readData.put("reader", this.getId());
        readData.put("timestampFirst", timestamp);
        readData.put("timestampLast", timestamp);
        readData.put("count", tagSeenCount != null ? tagSeenCount : new Integer(0));
        readData.put("resultCode", resultCode);
        return readData;
    }

    public Map getTargetTagFilterParameters() {
        return this.targetTagFilterParameters;
    }

    private Task_DELETE_EXIST_ACCESSSPEC getTask_DELETE_EXIST_ACCESSSPEC() {
        Task_GET_ACCESSSPECS getAccessSpecTask = new Task_GET_ACCESSSPECS(this.epcglobalLlrpDeviceServiceGetAccessspecs, null, this.epcglobalLlrpDeviceServiceGetAccessspecsResponse, 5000L);
        Task_DELETE_ACCESSSPEC deleteAccessSpecTask = new Task_DELETE_ACCESSSPEC(this.epcglobalLlrpDeviceServiceDeleteAccessspec, ParameterFactory.getAccessSpecIDParameter((int)this.getAccessSpecID()), this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse, 5000L);
        return new Task_DELETE_EXIST_ACCESSSPEC(getAccessSpecTask, deleteAccessSpecTask);
    }

    private void initialize() {
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    protected void populateTasks() {
        Map rospecIdParameter = ParameterFactory.getROSpecIDParameter((int)this.getROSpecID());
        Task_GET_ROSPECS getROSpecsTask = new Task_GET_ROSPECS(this.epcglobalLlrpDeviceServiceGetRospecs, null, this.epcglobalLlrpDeviceServiceGetRospecsResponse, 5000L);
        Task_DELETE_ROSPEC deleteROSpecTask = new Task_DELETE_ROSPEC(this.epcglobalLlrpDeviceServiceDeleteRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceDeleteRospecResponse, 5000L);
        Task_DELETE_EXIST_ROSPEC deleteExistROSpecTask = new Task_DELETE_EXIST_ROSPEC(getROSpecsTask, deleteROSpecTask);
        Task_ADD_ROSPEC addROSpecTask = new Task_ADD_ROSPEC(this.epcglobalLlrpDeviceServiceAddRospec, this.getAddROSpecCommandParameters(this.getROSpecID()), this.epcglobalLlrpDeviceServiceAddRospecResponse, 5000L);
        Task_ENABLE_ROSPEC enableROSpecTask = new Task_ENABLE_ROSPEC(this.epcglobalLlrpDeviceServiceEnableRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceEnableRospecResponse, 5000L);
        Task_START_ROSPEC startROSpecTask = new Task_START_ROSPEC(this.epcglobalLlrpDeviceServiceStartRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceStartRospecResponse, 5000L);
        Task_STOP_ROSPEC stopROSpecTask = new Task_STOP_ROSPEC(this.epcglobalLlrpDeviceServiceStopRospec, rospecIdParameter, this.epcglobalLlrpDeviceServiceStopRospecResponse, 5000L);
        Task_STOP_EXIST_ROSPEC stopExistROSpecTask = new Task_STOP_EXIST_ROSPEC(getROSpecsTask, stopROSpecTask);
        this.enableAccessSpecTask = new Task_ENABLE_ACCESSSPEC(this.epcglobalLlrpDeviceServiceEnableAccessspec, ParameterFactory.getAccessSpecIDParameter((int)this.getAccessSpecID()), this.epcglobalLlrpDeviceServiceEnableAccessspecResponse, 5000L);
        ITask[] stop_rospec_tasks = new ITask[]{this.getTask_DELETE_EXIST_ACCESSSPEC(), stopExistROSpecTask, deleteExistROSpecTask};
        ITask[] start_rospec_tasks = new ITask[]{deleteExistROSpecTask, addROSpecTask, enableROSpecTask, startROSpecTask};
        this.stopROSpecTaskArray = new Task_Array(TASKARRAY_STOP_ROSPEC, stop_rospec_tasks);
        this.startROSpecTaskArray = new Task_Array(TASKARRAY_START_ROSPEC, start_rospec_tasks);
    }

    protected void resetTaskManager() {
        this.taskManager.reset();
    }

    protected void sendTagReport(Map tagReport, boolean isReadOperation) {
        Map resultParam;
        String key;
        List accessCommandOpSpecResultChoices;
        Map tagReportData = (Map)tagReport.get("TagReportData_Key");
        Object timestamp = tagReport.get("Timestamp_Key");
        Integer resultCode = (Integer)tagReport.get("ResultCode_Key");
        String operationId = (String)tagReport.get("OperationId_Key");
        String tag = LLRPUtils.extractTag((Map)((Map)tagReportData.get("EPCParameterChoice")));
        if (tag == null) {
            this.handleError(new NullPointerException("EPC is null"), 3008);
            return;
        }
        Integer tagSeenCount = LLRPUtils.extractTagSeenCount((Map)((Map)tagReportData.get("TagSeenCountParameter")));
        Integer antennaId = LLRPUtils.extractAntennaId((Map)((Map)tagReportData.get("AntennaIDParameter")));
        Map readData = this.getReportReadData(tagSeenCount, antennaId, timestamp, resultCode);
        if (isReadOperation && (accessCommandOpSpecResultChoices = (List)tagReportData.get("AccessCommandOpSpecResultChoice")) != null && accessCommandOpSpecResultChoices.size() >= 1 && "C1G2ReadOpSpecResultParameter".equals(key = (String)(resultParam = (Map)accessCommandOpSpecResultChoices.get(0)).get("key"))) {
            List readDatas = (List)resultParam.get("ReadDatas");
            byte[] readDataBytes = LLRPUtils.convertIntListToBytes((List)readDatas);
            readData.put("readData", readDataBytes);
        }
        this.log(4, "Report on tag " + tag + ", result code: " + resultCode);
        this.notifyTagReport(tag, operationId, readData);
    }

    public void setAccessSpecID(int AccessSpecID) {
        this.accessSpecID = AccessSpecID;
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecs != null) {
                this.epcglobalLlrpDeviceServiceGetRospecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospec != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospec != null) {
                this.epcglobalLlrpDeviceServiceAddRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospec != null) {
                this.epcglobalLlrpDeviceServiceEnableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospec != null) {
                this.epcglobalLlrpDeviceServiceDisableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospec != null) {
                this.epcglobalLlrpDeviceServiceStartRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospec != null) {
                this.epcglobalLlrpDeviceServiceStopRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecs != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspec != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfigResponse != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfigResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetRospecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStartRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStopRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceRoAccessReport != null) {
                this.epcglobalLlrpDeviceServiceRoAccessReport.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory = device.getCommand("SetReaderConfig_ForInventory");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration = device.getCommand("SetReaderConfig_AntennaConfiguration");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration);
            this.epcglobalLlrpDeviceServiceGetRospecs = device.getCommand("GetRospecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetRospecs);
            this.epcglobalLlrpDeviceServiceDeleteRospec = device.getCommand("DeleteRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteRospec);
            this.epcglobalLlrpDeviceServiceAddRospec = device.getCommand("AddRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddRospec);
            this.epcglobalLlrpDeviceServiceEnableRospec = device.getCommand("EnableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableRospec);
            this.epcglobalLlrpDeviceServiceDisableRospec = device.getCommand("DisableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableRospec);
            this.epcglobalLlrpDeviceServiceStartRospec = device.getCommand("StartRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStartRospec);
            this.epcglobalLlrpDeviceServiceStopRospec = device.getCommand("StopRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStopRospec);
            this.epcglobalLlrpDeviceServiceGetAccessspecs = device.getCommand("GetAccessspecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetAccessspecs);
            this.epcglobalLlrpDeviceServiceDeleteAccessspec = device.getCommand("DeleteAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteAccessspec);
            this.epcglobalLlrpDeviceServiceAddAccessspec = device.getCommand("AddAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddAccessspec);
            this.epcglobalLlrpDeviceServiceEnableAccessspec = device.getCommand("EnableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableAccessspec);
            this.epcglobalLlrpDeviceServiceDisableAccessspec = device.getCommand("DisableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableAccessspec);
            this.epcglobalLlrpDeviceServiceSetReaderConfigResponse = device.getSignal("SetReaderConfigResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceSetReaderConfigResponse);
            this.epcglobalLlrpDeviceServiceGetRospecsResponse = device.getSignal("GetRospecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetRospecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteRospecResponse = device.getSignal("DeleteRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteRospecResponse);
            this.epcglobalLlrpDeviceServiceAddRospecResponse = device.getSignal("AddRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddRospecResponse);
            this.epcglobalLlrpDeviceServiceEnableRospecResponse = device.getSignal("EnableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableRospecResponse);
            this.epcglobalLlrpDeviceServiceDisableRospecResponse = device.getSignal("DisableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableRospecResponse);
            this.epcglobalLlrpDeviceServiceStartRospecResponse = device.getSignal("StartRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStartRospecResponse);
            this.epcglobalLlrpDeviceServiceStopRospecResponse = device.getSignal("StopRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStopRospecResponse);
            this.epcglobalLlrpDeviceServiceRoAccessReport = device.getSignal("RoAccessReport");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceRoAccessReport);
            this.epcglobalLlrpDeviceServiceGetAccessspecsResponse = device.getSignal("GetAccessspecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetAccessspecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse = device.getSignal("DeleteAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse);
            this.epcglobalLlrpDeviceServiceAddAccessspecResponse = device.getSignal("AddAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
            this.epcglobalLlrpDeviceServiceEnableAccessspecResponse = device.getSignal("EnableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableAccessspecResponse);
            this.epcglobalLlrpDeviceServiceDisableAccessspecResponse = device.getSignal("DisableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableAccessspecResponse);
        }
        super.setDevice(device);
    }

    public void setROSpecID(int ROSpecID) {
        this.rOSpecID = ROSpecID;
    }

    public void setTargetTagFilterParameters(Map targetTagFilterParameters) {
        this.targetTagFilterParameters = targetTagFilterParameters;
    }

    public void setup() {
        super.setup();
        this.setROSpecID(this.getInt("epcgloballlrpwriteprofile.ROSpecID", this.getROSpecID()));
        this.setAccessSpecID(this.getInt("epcgloballlrpwriteprofile.AccessSpecID", this.getAccessSpecID()));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.taskManager.handleResponse(source, timestamp, data);
    }

    protected void startOperations() {
        this.taskManager.addTaskToBottom((ITask)this.startROSpecTaskArray, true);
    }

    protected void startOperationsFailed(String errorMsg) {
        this.log(4, errorMsg);
        this.resetTaskManager();
        this.endOperations();
    }

    protected void stopOperationsFailed(String errorMsg) {
        this.log(4, errorMsg);
        this.setOperationsStatusFinished();
    }

    protected void stopOperationsSucceeded() {
        this.setOperationsStatusFinished();
    }
}

