/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.io.device;

import java.util.Map;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.io.device.service.GenericIoDeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class GenericIoDevice
extends Device
implements DeviceService,
GenericIoDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.io.device.GenericIoDevice";
    protected final MethodMeasurement digitalInputCount = new MethodMeasurement("DigitalInputCount");
    protected final MethodMeasurement digitalOutputCount = new MethodMeasurement("DigitalOutputCount");
    protected final MethodMeasurement analogInputCount = new MethodMeasurement("AnalogInputCount");
    protected final MethodMeasurement analogOutputCount = new MethodMeasurement("AnalogOutputCount");
    protected final MethodMeasurement digitalOutputs = new MethodMeasurement("DigitalOutputs");
    protected final MethodMeasurement digitalInputs = new MethodMeasurement("DigitalInputs");
    protected final MethodMeasurement analogOutputs = new MethodMeasurement("AnalogOutputs");
    protected final MethodMeasurement analogInputs = new MethodMeasurement("AnalogInputs");
    public static final String AO_DATA_KEY_PREFIX = "ao";
    public static final String AI_DATA_KEY_PREFIX = "ai";

    public GenericIoDevice() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getDefaultKey() {
        return "GenericIoDevice";
    }

    public TransportService getDefaultTransport() {
        return null;
    }

    public int getControlCapacity() {
        return 13;
    }

    public int getMessageCapacity() {
        return 2;
    }

    public MeasurementService getDigitalInputCount() {
        return this.digitalInputCount;
    }

    public MeasurementService getDigitalOutputCount() {
        return this.digitalOutputCount;
    }

    public MeasurementService getAnalogInputCount() {
        return this.analogInputCount;
    }

    public MeasurementService getAnalogOutputCount() {
        return this.analogOutputCount;
    }

    public MeasurementService getDigitalOutputs() {
        return this.digitalOutputs;
    }

    public MeasurementService getDigitalInputs() {
        return this.digitalInputs;
    }

    public MeasurementService getAnalogOutputs() {
        return this.analogOutputs;
    }

    public MeasurementService getAnalogInputs() {
        return this.analogInputs;
    }

    private void initialize() {
        this.put((ControlService)this.digitalInputCount);
        this.put((ControlService)this.digitalOutputCount);
        this.put((ControlService)this.analogInputCount);
        this.put((ControlService)this.analogOutputCount);
        this.put((ControlService)this.digitalOutputs);
        this.put((ControlService)this.digitalInputs);
        this.put((ControlService)this.analogOutputs);
        this.put((ControlService)this.analogInputs);
    }

    protected abstract Map getAnalogInputValue();

    protected abstract long getDigitalInputState();

    public int getNumberOfAnalogInputs() {
        return ((Number)this.analogInputCount.getValue()).intValue();
    }

    public int getNumberOfAnalogOutputs() {
        return ((Number)this.analogOutputCount.getValue()).intValue();
    }

    public int getNumberOfDigitalInputs() {
        return ((Number)this.digitalInputCount.getValue()).intValue();
    }

    public int getNumberOfDigitalOutputs() {
        return ((Number)this.digitalOutputCount.getValue()).intValue();
    }

    public Object handleMethodAnalogInputCount(int code, Measurement measurement, Object data) {
        return this.initializeIntegerMeasurement(code, measurement, data);
    }

    public Object handleMethodAnalogInputs(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: 
            case 1: {
                Map inputState = this.getAnalogInputValue();
                measurement.setValue((Object)inputState, GenericIoDevice.getCurrentTimestamp());
                return inputState;
            }
            case 2: 
            case 3: {
                measurement.setValue(data, GenericIoDevice.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodAnalogOutputCount(int code, Measurement measurement, Object data) {
        return this.initializeIntegerMeasurement(code, measurement, data);
    }

    public Object handleMethodAnalogOutputs(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: 
            case 1: {
                return measurement.getValueRaw();
            }
            case 2: 
            case 3: {
                this.setAnalogOutputValue((Map)data);
                measurement.setValue(data, GenericIoDevice.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodDigitalInputCount(int code, Measurement measurement, Object data) {
        return this.initializeIntegerMeasurement(code, measurement, data);
    }

    public Object handleMethodDigitalInputs(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: 
            case 1: {
                Long inputState = new Long(this.getDigitalInputState());
                measurement.setValue((Object)inputState, GenericIoDevice.getCurrentTimestamp());
                return inputState;
            }
            case 2: 
            case 3: {
                measurement.setValue(data, GenericIoDevice.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodDigitalOutputCount(int code, Measurement measurement, Object data) {
        return this.initializeIntegerMeasurement(code, measurement, data);
    }

    public Object handleMethodDigitalOutputs(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: 
            case 1: {
                return measurement.getValueRaw();
            }
            case 2: 
            case 3: {
                this.setDigitalOutputState((Long)data);
                measurement.setValue(data, GenericIoDevice.getCurrentTimestamp());
            }
        }
        return null;
    }

    protected Object initializeIntegerMeasurement(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                Object value = measurement.getValueRaw();
                if (value == null) {
                    String key = String.valueOf(this.getSimpleClassName().toLowerCase()) + '.' + measurement.getKey();
                    return new Integer(this.getInt(key, 0));
                }
                return value;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                measurement.setValue(this.toInteger(data), GenericIoDevice.getCurrentTimestamp());
            }
        }
        return null;
    }

    protected Object initializeStringMeasurement(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                Object value = measurement.getValueRaw();
                if (value == null) {
                    String key = String.valueOf(this.getSimpleClassName().toLowerCase()) + '.' + measurement.getKey();
                    return this.getString(key, null);
                }
                return value;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                measurement.setValue(this.toInteger(data), GenericIoDevice.getCurrentTimestamp());
            }
        }
        return null;
    }

    protected abstract void setAnalogOutputValue(Map var1);

    protected abstract void setDigitalOutputState(long var1);

    private Object toInteger(Object data) {
        if (data != null) {
            try {
                return Integer.valueOf(data.toString());
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
        return null;
    }
}

