/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.io.gpio.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.core.Worker;
import org.eclipse.soda.dk.core.service.WorkerService;
import org.eclipse.soda.dk.device.DevicePoller;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.io.gpio.profile.service.GenericIoGpioProfileService;
import org.eclipse.soda.dk.gpio.profile.GpioProfile;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.service.ProfileService;

public class GenericIoGpioProfile
extends GpioProfile
implements ProfileService,
GenericIoGpioProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.io.gpio.profile.GenericIoGpioProfile";
    protected MeasurementService genericIoDeviceServiceDigitalInputCount;
    protected MeasurementService genericIoDeviceServiceDigitalOutputCount;
    protected MeasurementService genericIoDeviceServiceAnalogInputCount;
    protected MeasurementService genericIoDeviceServiceAnalogOutputCount;
    protected MeasurementService genericIoDeviceServiceDigitalInputs;
    protected MeasurementService genericIoDeviceServiceDigitalOutputs;
    protected MeasurementService genericIoDeviceServiceAnalogInputs;
    protected MeasurementService genericIoDeviceServiceAnalogOutputs;
    private int pollingrate = 250;
    private static final long ALL_ON_OUTPUT = 0xFFFFFFFFL;
    private static final long ALL_OFF_OUTPUT = 0L;
    private Worker pollerWorker;

    public GenericIoGpioProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.genericIoDeviceServiceDigitalInputCount != null) {
                this.genericIoDeviceServiceDigitalInputCount.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceDigitalOutputCount != null) {
                this.genericIoDeviceServiceDigitalOutputCount.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceAnalogInputCount != null) {
                this.genericIoDeviceServiceAnalogInputCount.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceAnalogOutputCount != null) {
                this.genericIoDeviceServiceAnalogOutputCount.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceDigitalInputs != null) {
                this.genericIoDeviceServiceDigitalInputs.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceDigitalOutputs != null) {
                this.genericIoDeviceServiceDigitalOutputs.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceAnalogInputs != null) {
                this.genericIoDeviceServiceAnalogInputs.removeMeasurementListener((MeasurementListener)this);
            }
            if (this.genericIoDeviceServiceAnalogOutputs != null) {
                this.genericIoDeviceServiceAnalogOutputs.removeMeasurementListener((MeasurementListener)this);
            }
        }
        if (device != null) {
            this.genericIoDeviceServiceDigitalInputCount = device.getMeasurement("DigitalInputCount");
            this.initializeMeasurement(this.genericIoDeviceServiceDigitalInputCount);
            this.genericIoDeviceServiceDigitalOutputCount = device.getMeasurement("DigitalOutputCount");
            this.initializeMeasurement(this.genericIoDeviceServiceDigitalOutputCount);
            this.genericIoDeviceServiceAnalogInputCount = device.getMeasurement("AnalogInputCount");
            this.initializeMeasurement(this.genericIoDeviceServiceAnalogInputCount);
            this.genericIoDeviceServiceAnalogOutputCount = device.getMeasurement("AnalogOutputCount");
            this.initializeMeasurement(this.genericIoDeviceServiceAnalogOutputCount);
            this.genericIoDeviceServiceDigitalInputs = device.getMeasurement("DigitalInputs");
            this.initializeMeasurement(this.genericIoDeviceServiceDigitalInputs);
            this.genericIoDeviceServiceDigitalOutputs = device.getMeasurement("DigitalOutputs");
            this.initializeMeasurement(this.genericIoDeviceServiceDigitalOutputs);
            this.genericIoDeviceServiceAnalogInputs = device.getMeasurement("AnalogInputs");
            this.initializeMeasurement(this.genericIoDeviceServiceAnalogInputs);
            this.genericIoDeviceServiceAnalogOutputs = device.getMeasurement("AnalogOutputs");
            this.initializeMeasurement(this.genericIoDeviceServiceAnalogOutputs);
        }
        super.setDevice(device);
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        super.deviceChanged(source, timestamp, newState, oldState);
        if (newState == 5) {
            if (this.genericIoDeviceServiceDigitalInputCount != null) {
                this.genericIoDeviceServiceDigitalInputCount.executeRead();
            }
            if (this.genericIoDeviceServiceDigitalOutputCount != null) {
                this.genericIoDeviceServiceDigitalOutputCount.executeRead();
            }
            if (this.genericIoDeviceServiceAnalogInputCount != null) {
                this.genericIoDeviceServiceAnalogInputCount.executeRead();
            }
            if (this.genericIoDeviceServiceAnalogOutputCount != null) {
                this.genericIoDeviceServiceAnalogOutputCount.executeRead();
            }
            if (this.genericIoDeviceServiceDigitalInputs != null) {
                this.genericIoDeviceServiceDigitalInputs.executeRead();
            }
            if (this.genericIoDeviceServiceDigitalOutputs != null) {
                this.genericIoDeviceServiceDigitalOutputs.executeRead();
            }
            if (this.genericIoDeviceServiceAnalogInputs != null) {
                this.genericIoDeviceServiceAnalogInputs.executeRead();
            }
            if (this.genericIoDeviceServiceAnalogOutputs != null) {
                this.genericIoDeviceServiceAnalogOutputs.executeRead();
            }
        }
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.genericIoDeviceServiceDigitalInputCount == source) {
            this.handleGenericIoDeviceServiceDigitalInputCount(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceDigitalOutputCount == source) {
            this.handleGenericIoDeviceServiceDigitalOutputCount(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceAnalogInputCount == source) {
            this.handleGenericIoDeviceServiceAnalogInputCount(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceAnalogOutputCount == source) {
            this.handleGenericIoDeviceServiceAnalogOutputCount(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceDigitalInputs == source) {
            this.handleGenericIoDeviceServiceDigitalInputs(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceDigitalOutputs == source) {
            this.handleGenericIoDeviceServiceDigitalOutputs(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceAnalogInputs == source) {
            this.handleGenericIoDeviceServiceAnalogInputs(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.genericIoDeviceServiceAnalogOutputs == source) {
            this.handleGenericIoDeviceServiceAnalogOutputs(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public String getDefaultKey() {
        return "GenericIoGpioProfile";
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)GenericIoGpioProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.generic.io.device.GenericIoDevice");
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    private void initialize() {
    }

    public void setPollingrate(int pollingrate) {
        this.pollingrate = pollingrate;
    }

    public int getPollingrate() {
        return this.pollingrate;
    }

    public void setup() {
        super.setup();
        this.setPollingrate(this.getInt("genericiogpioprofile.pollingrate", this.getPollingrate()));
    }

    public void activate() {
        super.activate();
        if (this.pollingrate > 0) {
            ControlService[] controls = new ControlService[]{this.genericIoDeviceServiceDigitalInputs, this.genericIoDeviceServiceAnalogInputs};
            DevicePoller poller = new DevicePoller(controls, (long)this.pollingrate);
            this.pollerWorker = new Worker("GenericIoGpioProfile-poller", (WorkerService)poller);
            this.pollerWorker.start();
        }
    }

    private Map createMapFromState(long data, String[] keys, long count) {
        long value = data;
        Hashtable<String, Boolean> pins = new Hashtable<String, Boolean>(keys.length + 7);
        int i = 0;
        while ((long)i < count) {
            int isOn = (int)value & 1;
            pins.put(keys[i + 1], isOn == 1 ? Boolean.TRUE : Boolean.FALSE);
            value >>= 1;
            ++i;
        }
        return pins;
    }

    protected long createOutputStateFromMap(Map states, String[] keys, long count) {
        long allPinsState = 0L;
        int i = 1;
        while ((long)i <= count) {
            boolean out;
            Object pinState = states.get(keys[i]);
            boolean bl = out = pinState == null ? false : this.getBooleanValue(pinState);
            if (out) {
                allPinsState |= 1L << i - 1;
            }
            ++i;
        }
        return allPinsState;
    }

    public void deactivate() {
        if (this.pollerWorker != null) {
            this.pollerWorker.stop();
            this.pollerWorker = null;
        }
        super.deactivate();
    }

    protected long getAnalogInputCountValue() {
        Integer count = (Integer)this.genericIoDeviceServiceAnalogInputCount.getValue();
        return count.intValue();
    }

    protected long getAnalogOutputCountValue() {
        Integer count = (Integer)this.genericIoDeviceServiceAnalogOutputCount.getValue();
        return count.intValue();
    }

    protected long getInputCountValue() {
        Integer count = (Integer)this.genericIoDeviceServiceDigitalInputCount.getValue();
        return count.intValue();
    }

    protected long getOutputCountValue() {
        Integer count = (Integer)this.genericIoDeviceServiceDigitalOutputCount.getValue();
        return count.intValue();
    }

    private void handleGenericIoDeviceServiceAnalogInputCount(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    private void handleGenericIoDeviceServiceAnalogInputs(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (!this.isStarted()) {
            return;
        }
        if (!(newValue instanceof Map)) {
            return;
        }
        this.analogInput.setValue(newValue, GenericIoGpioProfile.getCurrentTimestamp());
    }

    private void handleGenericIoDeviceServiceAnalogOutputCount(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    private void handleGenericIoDeviceServiceAnalogOutputs(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    private void handleGenericIoDeviceServiceDigitalInputCount(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    private void handleGenericIoDeviceServiceDigitalInputs(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (!this.isStarted()) {
            return;
        }
        if (!(newValue instanceof Number)) {
            return;
        }
        Map newInputState = this.createMapFromState(((Number)newValue).longValue(), INPUT_NAMES, this.getInputCountValue());
        this.input.setValue((Object)newInputState, GenericIoGpioProfile.getCurrentTimestamp());
    }

    private void handleGenericIoDeviceServiceDigitalOutputCount(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    private void handleGenericIoDeviceServiceDigitalOutputs(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    protected void setOutputPins(long value) {
        if (this.isStarted() && this.getDevice() != null && this.getDevice().isStarted()) {
            this.genericIoDeviceServiceDigitalOutputs.executeWrite((Object)new Long(value));
        }
    }

    protected void turnOffAllOutputs() {
        this.setOutputPins(0L);
    }

    protected void turnOnAllOutputs() {
        this.setOutputPins(0xFFFFFFFFL);
    }

    protected void updateOutputs(Map fullState, Map individualRequest) {
        long output = this.createOutputStateFromMap(fullState, OUTPUT_NAMES, this.getOutputCountValue());
        this.setOutputPins(output);
    }

    protected void updateAnalogOutputs(Map fullState, Map individualRequest) {
        if (this.isStarted() && this.getDevice() != null && this.getDevice().isStarted()) {
            this.genericIoDeviceServiceAnalogOutputs.executeWrite((Object)fullState);
        }
    }
}

