/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileAnalogOutputExpressionTestCase
extends GpioProfileAbstractTestCase {
    private int digitalOutputCount;
    private int analogInputCount;
    static /* synthetic */ Class class$0;

    public GpioProfileAnalogOutputExpressionTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAnalogOutputExpressionTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
        this.digitalOutputCount = Integer.parseInt(this.getMeasurement(this.gpioProfileServiceOutputCountExternalKey).toString());
        this.analogInputCount = Integer.parseInt(this.getMeasurement(this.gpioProfileServiceAnalogInputCountExternalKey).toString());
    }

    public void test010_ClearOutputExpressions() throws InterruptedException {
        if (this.digitalOutputCount < 1) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        long counter = 1L;
        while (counter <= (long)this.digitalOutputCount) {
            String topic = this.prependPrefix("Gpio/Output" + counter + "Expression");
            String filter = "";
            Boolean v = new Boolean(this.getString("keyGpioOutputExpressionValue" + counter, "false"));
            if (!v.booleanValue()) {
                v = Boolean.FALSE;
            }
            expectedValue.put(new String("o" + counter), v);
            this.writeMeasurement(topic, filter);
            ++counter;
        }
    }

    public void test020_SetOutputExpressions() throws InterruptedException, IOException {
        if (this.digitalOutputCount < 1 || this.analogInputCount < 1) {
            return;
        }
        String inputProperty = this.getString("expected.analog.input.value", "");
        long[] lowerRange = new long[this.analogInputCount];
        long[] upperRange = new long[this.analogInputCount];
        this.setAnalogInputRanges(inputProperty, lowerRange, upperRange);
        int counter = 1;
        while (counter <= this.digitalOutputCount) {
            String topic = this.prependPrefix("Gpio/Output" + counter + "Expression");
            String filterLower = "(ai" + counter + ">=" + lowerRange[counter - 1] + ')';
            String filterUpper = "(ai" + counter + "<=" + upperRange[counter - 1] + ')';
            String filter = "(&" + filterLower + filterUpper + ')';
            this.writeMeasurement(topic, filter);
            ++counter;
        }
        GpioProfileAnalogOutputExpressionTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7514))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceAnalogInputExternalKey);
        int i = 0;
        while (i < realValue.size()) {
            long keyValue = Long.parseLong(realValue.get("ai" + (i + 1)).toString());
            Object[] inputAndValue = new Object[]{new Integer(i + 1), new Long(keyValue)};
            GpioProfileAnalogOutputExpressionTestCase.assertTrue((String)Nls.format((String)GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7515)), (Object[])inputAndValue), (boolean)this.analogInputWithinRange(keyValue, lowerRange[i], upperRange[i]));
            ++i;
        }
        GpioProfileAnalogOutputExpressionTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7518))));
    }
}

