/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileAnalogOutputTestCase
extends GpioProfileAbstractTestCase {
    static /* synthetic */ Class class$0;

    public GpioProfileAnalogOutputTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAnalogOutputTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
    }

    public void test000_AnalogOutputValues() throws InterruptedException, IOException {
        int outputCount = Integer.parseInt(this.getMeasurement(this.gpioProfileServiceAnalogOutputCountExternalKey).toString());
        if (outputCount < 1) {
            return;
        }
        String outputProperty = this.getString("expected.analog.output.value", "");
        long[] outputValues = this.setAnalogOutputValues(outputProperty, outputCount);
        Hashtable<String, Long> data = new Hashtable<String, Long>();
        Hashtable<String, Long> expectedValue = new Hashtable<String, Long>();
        int i = 1;
        while (i <= outputCount) {
            data.put(new String("ao" + i), new Long(outputValues[i - 1]));
            expectedValue.put(new String("ao" + i), new Long(outputValues[i - 1]));
            ++i;
        }
        this.executeCommand(this.gpioProfileServiceAnalogOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceAnalogOutputExternalKey);
        GpioProfileAnalogOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileAnalogOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7517))));
    }

    public void test010_AnalogOutputValuesZero() throws InterruptedException, IOException {
        long outputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceAnalogOutputCountExternalKey).toString());
        if (outputCount < 1L) {
            return;
        }
        Hashtable<String, Long> data = new Hashtable<String, Long>();
        Hashtable<String, Long> expectedValue = new Hashtable<String, Long>();
        int i = 1;
        while ((long)i <= outputCount) {
            data.put(new String("ao" + i), Long.valueOf("0"));
            expectedValue.put(new String("ao" + i), Long.valueOf("0"));
            ++i;
        }
        this.executeCommand(this.gpioProfileServiceAnalogOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceAnalogOutputExternalKey);
        GpioProfileAnalogOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileAnalogOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7516))));
    }
}

