/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.MethodCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.gpio.profile.service.GpioProfileService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.ReadOnlyMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class GpioProfile
extends Profile
implements ProfileService,
GpioProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gpio.profile.GpioProfile";
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    protected String controlProfileServiceBitsExternalKey = null;
    protected String controlProfileServiceBitsGetExternalKey = null;
    protected String controlProfileServiceLongsExternalKey = null;
    protected String controlProfileServiceLongsGetExternalKey = null;
    protected final MethodCommand outputRequest = new MethodCommand("Gpio/OutputRequest");
    protected final MethodCommand analogOutputRequest = new MethodCommand("Gpio/AnalogOutputRequest");
    protected final ReadOnlyMeasurement inputCount = new ReadOnlyMeasurement("Gpio/InputCount", (Object)new Long(0L));
    protected final ReadOnlyMeasurement outputCount = new ReadOnlyMeasurement("Gpio/OutputCount", (Object)new Long(0L));
    protected final ReadOnlyMeasurement input = new ReadOnlyMeasurement("Gpio/Input");
    protected final ReadOnlyMeasurement output = new ReadOnlyMeasurement("Gpio/Output");
    protected final MethodMeasurement output1Expression = new MethodMeasurement("Gpio/Output1Expression");
    protected final MethodMeasurement output2Expression = new MethodMeasurement("Gpio/Output2Expression");
    protected final MethodMeasurement output3Expression = new MethodMeasurement("Gpio/Output3Expression");
    protected final MethodMeasurement output4Expression = new MethodMeasurement("Gpio/Output4Expression");
    protected final MethodMeasurement output5Expression = new MethodMeasurement("Gpio/Output5Expression");
    protected final MethodMeasurement output6Expression = new MethodMeasurement("Gpio/Output6Expression");
    protected final MethodMeasurement output7Expression = new MethodMeasurement("Gpio/Output7Expression");
    protected final MethodMeasurement output8Expression = new MethodMeasurement("Gpio/Output8Expression");
    protected final MethodMeasurement output9Expression = new MethodMeasurement("Gpio/Output9Expression");
    protected final MethodMeasurement output10Expression = new MethodMeasurement("Gpio/Output10Expression");
    protected final MethodMeasurement output11Expression = new MethodMeasurement("Gpio/Output11Expression");
    protected final MethodMeasurement output12Expression = new MethodMeasurement("Gpio/Output12Expression");
    protected final MethodMeasurement output13Expression = new MethodMeasurement("Gpio/Output13Expression");
    protected final MethodMeasurement output14Expression = new MethodMeasurement("Gpio/Output14Expression");
    protected final MethodMeasurement output15Expression = new MethodMeasurement("Gpio/Output15Expression");
    protected final MethodMeasurement output16Expression = new MethodMeasurement("Gpio/Output16Expression");
    protected final MethodMeasurement output17Expression = new MethodMeasurement("Gpio/Output17Expression");
    protected final MethodMeasurement output18Expression = new MethodMeasurement("Gpio/Output18Expression");
    protected final MethodMeasurement output19Expression = new MethodMeasurement("Gpio/Output19Expression");
    protected final MethodMeasurement output20Expression = new MethodMeasurement("Gpio/Output20Expression");
    protected final MethodMeasurement output21Expression = new MethodMeasurement("Gpio/Output21Expression");
    protected final MethodMeasurement output22Expression = new MethodMeasurement("Gpio/Output22Expression");
    protected final MethodMeasurement output23Expression = new MethodMeasurement("Gpio/Output23Expression");
    protected final MethodMeasurement output24Expression = new MethodMeasurement("Gpio/Output24Expression");
    protected final MethodMeasurement output25Expression = new MethodMeasurement("Gpio/Output25Expression");
    protected final MethodMeasurement output26Expression = new MethodMeasurement("Gpio/Output26Expression");
    protected final MethodMeasurement output27Expression = new MethodMeasurement("Gpio/Output27Expression");
    protected final MethodMeasurement output28Expression = new MethodMeasurement("Gpio/Output28Expression");
    protected final MethodMeasurement output29Expression = new MethodMeasurement("Gpio/Output29Expression");
    protected final MethodMeasurement output30Expression = new MethodMeasurement("Gpio/Output30Expression");
    protected final MethodMeasurement output31Expression = new MethodMeasurement("Gpio/Output31Expression");
    protected final MethodMeasurement output32Expression = new MethodMeasurement("Gpio/Output32Expression");
    protected final ReadOnlyMeasurement analogInputCount = new ReadOnlyMeasurement("Gpio/AnalogInputCount", (Object)new Long(0L));
    protected final ReadOnlyMeasurement analogOutputCount = new ReadOnlyMeasurement("Gpio/AnalogOutputCount", (Object)new Long(0L));
    protected final ReadOnlyMeasurement analogInput = new ReadOnlyMeasurement("Gpio/AnalogInput");
    protected final ReadOnlyMeasurement analogOutput = new ReadOnlyMeasurement("Gpio/AnalogOutput");
    protected Map outputOnMap = null;
    protected Map outputOffMap = null;
    protected Map analogOutputOffMap = null;
    protected Map inputFalseMap = null;
    protected Map analogInputOffMap = null;
    protected Hashtable ldapMap = new Hashtable(13);
    protected Filter[] outputFilters = new Filter[33];

    public GpioProfile() {
        super("GpioProfile/Capabilities", "GpioProfile/Status", "GpioProfile/Configuration", "GpioProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void setupNotification() {
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs/get");
        this.register(new String[]{this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey});
        super.setupNotification();
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.input == source) {
            this.handleInput(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.analogInput == source) {
            this.handleAnalogInput(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public String getDefaultKey() {
        return "GpioProfile";
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public int getControlCapacity() {
        return 59;
    }

    public int getMessageCapacity() {
        return 2;
    }

    public CommandService getOutputRequest() {
        return this.outputRequest;
    }

    public CommandService getAnalogOutputRequest() {
        return this.analogOutputRequest;
    }

    public MeasurementService getInputCount() {
        return this.inputCount;
    }

    public MeasurementService getOutputCount() {
        return this.outputCount;
    }

    public MeasurementService getInput() {
        return this.input;
    }

    public MeasurementService getOutput() {
        return this.output;
    }

    public MeasurementService getOutput1Expression() {
        return this.output1Expression;
    }

    public MeasurementService getOutput2Expression() {
        return this.output2Expression;
    }

    public MeasurementService getOutput3Expression() {
        return this.output3Expression;
    }

    public MeasurementService getOutput4Expression() {
        return this.output4Expression;
    }

    public MeasurementService getOutput5Expression() {
        return this.output5Expression;
    }

    public MeasurementService getOutput6Expression() {
        return this.output6Expression;
    }

    public MeasurementService getOutput7Expression() {
        return this.output7Expression;
    }

    public MeasurementService getOutput8Expression() {
        return this.output8Expression;
    }

    public MeasurementService getOutput9Expression() {
        return this.output9Expression;
    }

    public MeasurementService getOutput10Expression() {
        return this.output10Expression;
    }

    public MeasurementService getOutput11Expression() {
        return this.output11Expression;
    }

    public MeasurementService getOutput12Expression() {
        return this.output12Expression;
    }

    public MeasurementService getOutput13Expression() {
        return this.output13Expression;
    }

    public MeasurementService getOutput14Expression() {
        return this.output14Expression;
    }

    public MeasurementService getOutput15Expression() {
        return this.output15Expression;
    }

    public MeasurementService getOutput16Expression() {
        return this.output16Expression;
    }

    public MeasurementService getOutput17Expression() {
        return this.output17Expression;
    }

    public MeasurementService getOutput18Expression() {
        return this.output18Expression;
    }

    public MeasurementService getOutput19Expression() {
        return this.output19Expression;
    }

    public MeasurementService getOutput20Expression() {
        return this.output20Expression;
    }

    public MeasurementService getOutput21Expression() {
        return this.output21Expression;
    }

    public MeasurementService getOutput22Expression() {
        return this.output22Expression;
    }

    public MeasurementService getOutput23Expression() {
        return this.output23Expression;
    }

    public MeasurementService getOutput24Expression() {
        return this.output24Expression;
    }

    public MeasurementService getOutput25Expression() {
        return this.output25Expression;
    }

    public MeasurementService getOutput26Expression() {
        return this.output26Expression;
    }

    public MeasurementService getOutput27Expression() {
        return this.output27Expression;
    }

    public MeasurementService getOutput28Expression() {
        return this.output28Expression;
    }

    public MeasurementService getOutput29Expression() {
        return this.output29Expression;
    }

    public MeasurementService getOutput30Expression() {
        return this.output30Expression;
    }

    public MeasurementService getOutput31Expression() {
        return this.output31Expression;
    }

    public MeasurementService getOutput32Expression() {
        return this.output32Expression;
    }

    public MeasurementService getAnalogInputCount() {
        return this.analogInputCount;
    }

    public MeasurementService getAnalogOutputCount() {
        return this.analogOutputCount;
    }

    public MeasurementService getAnalogInput() {
        return this.analogInput;
    }

    public MeasurementService getAnalogOutput() {
        return this.analogOutput;
    }

    private void initialize() {
        this.put((ControlService)this.outputRequest);
        this.put((ControlService)this.analogOutputRequest);
        this.put((ControlService)this.inputCount);
        this.put((ControlService)this.outputCount);
        this.put((ControlService)this.input);
        this.input.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.output);
        this.put((ControlService)this.output1Expression);
        this.put((ControlService)this.output2Expression);
        this.put((ControlService)this.output3Expression);
        this.put((ControlService)this.output4Expression);
        this.put((ControlService)this.output5Expression);
        this.put((ControlService)this.output6Expression);
        this.put((ControlService)this.output7Expression);
        this.put((ControlService)this.output8Expression);
        this.put((ControlService)this.output9Expression);
        this.put((ControlService)this.output10Expression);
        this.put((ControlService)this.output11Expression);
        this.put((ControlService)this.output12Expression);
        this.put((ControlService)this.output13Expression);
        this.put((ControlService)this.output14Expression);
        this.put((ControlService)this.output15Expression);
        this.put((ControlService)this.output16Expression);
        this.put((ControlService)this.output17Expression);
        this.put((ControlService)this.output18Expression);
        this.put((ControlService)this.output19Expression);
        this.put((ControlService)this.output20Expression);
        this.put((ControlService)this.output21Expression);
        this.put((ControlService)this.output22Expression);
        this.put((ControlService)this.output23Expression);
        this.put((ControlService)this.output24Expression);
        this.put((ControlService)this.output25Expression);
        this.put((ControlService)this.output26Expression);
        this.put((ControlService)this.output27Expression);
        this.put((ControlService)this.output28Expression);
        this.put((ControlService)this.output29Expression);
        this.put((ControlService)this.output30Expression);
        this.put((ControlService)this.output31Expression);
        this.put((ControlService)this.output32Expression);
        this.put((ControlService)this.analogInputCount);
        this.put((ControlService)this.analogOutputCount);
        this.put((ControlService)this.analogInput);
        this.analogInput.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.analogOutput);
    }

    protected synchronized void applyAnalogOutputRequest(Map request) {
        if (!this.isStarted()) {
            return;
        }
        Map currentAnalogOut = (Map)this.analogOutput.getValue();
        if (currentAnalogOut == null || currentAnalogOut.isEmpty()) {
            currentAnalogOut = this.analogOutputOffMap;
        }
        Map newState = this.getMergedMap(request, currentAnalogOut, ANALOG_OUTPUT_NAMES);
        this.updateAnalogOutputs(newState, request);
        this.analogOutput.setValue((Object)newState, GpioProfile.getCurrentTimestamp());
    }

    protected synchronized void applyOutputRequest(Map request) {
        if (!this.isStarted()) {
            return;
        }
        Map currentOut = (Map)this.output.getValue();
        if (currentOut == null || currentOut.isEmpty()) {
            currentOut = this.outputOffMap;
        }
        Map newState = this.getMergedMap(request, currentOut, OUTPUT_NAMES);
        this.updateOutputs(newState, request);
        this.output.setValue((Object)newState, GpioProfile.getCurrentTimestamp());
    }

    protected void evaluateFilters() {
        Hashtable<String, Boolean> outputChanges = new Hashtable<String, Boolean>();
        int i = 1;
        while (i <= 32) {
            boolean value;
            Filter filter = this.outputFilters[i];
            if (filter != null && (value = filter.match((Dictionary)this.ldapMap)) != this.getStoredOutputByName(OUTPUT_NAMES[i])) {
                Boolean newValue = value ? Boolean.TRUE : Boolean.FALSE;
                outputChanges.put(OUTPUT_NAMES[i], newValue);
            }
            ++i;
        }
        if (!outputChanges.isEmpty()) {
            this.applyOutputRequest(outputChanges);
        }
    }

    protected long getAnalogInputCountValue() {
        return 0L;
    }

    protected long getAnalogOutputCountValue() {
        return 0L;
    }

    protected abstract long getInputCountValue();

    protected Map getMergedMap(Map request, Map current, String[] names) {
        Hashtable merge = new Hashtable(13);
        Iterator i = current.keySet().iterator();
        while (i.hasNext()) {
            Object currentKey = i.next();
            Object currentValue = current.get(currentKey);
            merge.put(currentKey, currentValue);
        }
        i = request.keySet().iterator();
        while (i.hasNext()) {
            Object requestKey = i.next();
            Object requestValue = request.get(requestKey);
            merge.put(requestKey, requestValue);
        }
        return merge;
    }

    protected abstract long getOutputCountValue();

    private int getPositionForName(Object targetName, String[] names) {
        if (targetName == null) {
            return 0;
        }
        int i = 1;
        while (i <= 32) {
            if (targetName.equals(names[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected boolean getStoredInputByName(String name) {
        Map inputs = (Map)this.input.getValue();
        if (inputs == null) {
            return false;
        }
        Boolean result = (Boolean)inputs.get(name);
        if (result == null) {
            return false;
        }
        return result;
    }

    protected boolean getStoredOutputByName(String name) {
        Map outputs = (Map)this.output.getValue();
        if (outputs == null) {
            return false;
        }
        Boolean result = (Boolean)outputs.get(name);
        if (result == null) {
            return false;
        }
        return result;
    }

    protected void handleAnalogInput(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (newValue != null && newValue instanceof Map) {
            Map newInput = (Map)newValue;
            Iterator i = newInput.keySet().iterator();
            while (i.hasNext()) {
                Object inputName = i.next();
                Object inputValue = newInput.get(inputName);
                this.ldapMap.put(inputName, inputValue);
            }
        }
        this.evaluateFilters();
    }

    protected void handleControlProfileServiceBits(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleExecuteAnalogOutputRequest(Command command, Object data) {
        Map request;
        Object valueAll;
        boolean error = false;
        if (!(data instanceof Map)) {
            error = true;
        }
        if ((valueAll = (request = (Map)data).get(ANALOG_OUTPUT_NAMES[0])) != null) {
            if (this.outputFiltersAreClear()) {
                Long value = this.getLongValue(valueAll);
                int analogOutputInt = (int)this.getAnalogOutputCountValue();
                Hashtable<String, Long> analogOutputMap = new Hashtable<String, Long>(analogOutputInt * 2 + 1);
                int i = 1;
                while (i <= analogOutputInt) {
                    analogOutputMap.put(ANALOG_OUTPUT_NAMES[i], value);
                    ++i;
                }
                this.applyAnalogOutputRequest(analogOutputMap);
            } else {
                error = true;
            }
        } else if (this.outputFiltersClearForRequest(request) && this.requestAnalogIsValidType(request)) {
            this.applyAnalogOutputRequest(request);
        } else {
            error = true;
        }
        if (error) {
            throw new IllegalArgumentException("handleExecuteAnalogOutputRequest");
        }
    }

    protected void handleExecuteOutputRequest(Command command, Object data) {
        Map request;
        Object stateAll;
        boolean error = false;
        if (!(data instanceof Map)) {
            error = true;
        }
        if ((stateAll = (request = (Map)data).get(OUTPUT_NAMES[0])) != null) {
            Boolean state = this.getBooleanValue(stateAll);
            if (this.outputFiltersAreClear()) {
                if (state.booleanValue()) {
                    this.turnOnAllOutputs();
                    Map newOutput = this.getMergedMap(new Hashtable(13), this.outputOnMap, OUTPUT_NAMES);
                    this.output.setValue((Object)newOutput, GpioProfile.getCurrentTimestamp());
                } else {
                    this.turnOffAllOutputs();
                    Map newOutput = this.getMergedMap(new Hashtable(13), this.outputOffMap, OUTPUT_NAMES);
                    this.output.setValue((Object)newOutput, GpioProfile.getCurrentTimestamp());
                }
            } else {
                error = true;
            }
        } else if (this.outputFiltersClearForRequest(request) && this.requestIsValidType(request)) {
            this.applyOutputRequest(request);
        } else {
            error = true;
        }
        if (error) {
            throw new IllegalArgumentException("handleExecuteOutputRequest");
        }
    }

    protected void handleInput(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (newValue != null && newValue instanceof Map) {
            Map newInput = (Map)newValue;
            Iterator i = newInput.keySet().iterator();
            while (i.hasNext()) {
                Object inputName = i.next();
                Object inputValue = newInput.get(inputName);
                this.ldapMap.put(inputName, inputValue);
            }
        }
        this.evaluateFilters();
    }

    public Object handleMethodAnalogOutputRequest(int code, Command command, Object data) {
        switch (code) {
            case 0: {
                this.handleExecuteAnalogOutputRequest(command, data);
            }
        }
        return null;
    }

    public Object handleMethodOutput10Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 10);
    }

    public Object handleMethodOutput11Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 11);
    }

    public Object handleMethodOutput12Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 12);
    }

    public Object handleMethodOutput13Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 13);
    }

    public Object handleMethodOutput14Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 14);
    }

    public Object handleMethodOutput15Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 15);
    }

    public Object handleMethodOutput16Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 16);
    }

    public Object handleMethodOutput17Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 17);
    }

    public Object handleMethodOutput18Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 18);
    }

    public Object handleMethodOutput19Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 19);
    }

    public Object handleMethodOutput1Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 1);
    }

    public Object handleMethodOutput20Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 20);
    }

    public Object handleMethodOutput21Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 21);
    }

    public Object handleMethodOutput22Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 22);
    }

    public Object handleMethodOutput23Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 23);
    }

    public Object handleMethodOutput24Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 24);
    }

    public Object handleMethodOutput25Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 25);
    }

    public Object handleMethodOutput26Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 26);
    }

    public Object handleMethodOutput27Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 27);
    }

    public Object handleMethodOutput28Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 28);
    }

    public Object handleMethodOutput29Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 29);
    }

    public Object handleMethodOutput2Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 2);
    }

    public Object handleMethodOutput30Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 30);
    }

    public Object handleMethodOutput31Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 31);
    }

    public Object handleMethodOutput32Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 32);
    }

    public Object handleMethodOutput3Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 3);
    }

    public Object handleMethodOutput4Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 4);
    }

    public Object handleMethodOutput5Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 5);
    }

    public Object handleMethodOutput6Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 6);
    }

    public Object handleMethodOutput7Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 7);
    }

    public Object handleMethodOutput8Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 8);
    }

    public Object handleMethodOutput9Expression(int code, Measurement measurement, Object data) {
        return this.handleMethodOutputExpression(code, measurement, data, 9);
    }

    public Object handleMethodOutputExpression(int code, Measurement measurement, Object data, int pin) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.updateFilter(pin, data);
                measurement.setValue(data, GpioProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodOutputRequest(int code, Command command, Object data) {
        switch (code) {
            case 0: {
                this.handleExecuteOutputRequest(command, data);
            }
        }
        return null;
    }

    private boolean outputFilterClearForPosition(int position) {
        return this.outputFilters[position] == null;
    }

    private boolean outputFiltersAreClear() {
        int i = 1;
        while (i <= 32) {
            if (!this.outputFilterClearForPosition(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean outputFiltersClearForRequest(Map request) {
        Iterator i = request.keySet().iterator();
        while (i.hasNext()) {
            Object outputName = i.next();
            int position = this.getPositionForName(outputName, OUTPUT_NAMES);
            if (this.outputFilterClearForPosition(position)) continue;
            return false;
        }
        return true;
    }

    protected boolean requestAnalogIsValidType(Map request) {
        Iterator i = request.keySet().iterator();
        while (i.hasNext()) {
            Object currentKey = i.next();
            Object currentValue = request.get(currentKey);
            this.getLongValue(currentValue);
        }
        return true;
    }

    protected boolean requestIsValidType(Map request) {
        Iterator i = request.keySet().iterator();
        while (i.hasNext()) {
            Object currentKey = i.next();
            Object currentValue = request.get(currentKey);
            this.getBooleanValue(currentValue);
        }
        return true;
    }

    private void setupAnalogInput() {
        this.analogInput.setValue(new Hashtable(), GpioProfile.getCurrentTimestamp());
        this.analogInputCount.setValue((Object)new Long(this.getAnalogInputCountValue()), GpioProfile.getCurrentTimestamp());
        int analogInputInt = (int)this.getAnalogInputCountValue();
        this.analogInputOffMap = new Hashtable(analogInputInt * 2 + 1);
        Long offValue = new Long(0L);
        int i = 1;
        while (i <= analogInputInt) {
            this.analogInputOffMap.put(ANALOG_INPUT_NAMES[i], offValue);
            ++i;
        }
    }

    private void setupAnalogOutput() {
        this.analogOutput.setValue(new Hashtable(), GpioProfile.getCurrentTimestamp());
        this.analogOutputCount.setValue((Object)new Long(this.getAnalogOutputCountValue()), GpioProfile.getCurrentTimestamp());
        int analogOutputInt = (int)this.getAnalogOutputCountValue();
        this.analogOutputOffMap = new Hashtable(analogOutputInt * 2 + 1);
        Long offValue = new Long(0L);
        int i = 1;
        while (i <= analogOutputInt) {
            this.analogOutputOffMap.put(ANALOG_OUTPUT_NAMES[i], offValue);
            ++i;
        }
    }

    public void setupCustom() {
        this.setupInput();
        this.setupOutput();
        this.setupAnalogInput();
        this.setupAnalogOutput();
        super.setupCustom();
    }

    private void setupInput() {
        this.input.setValue(new Hashtable(), GpioProfile.getCurrentTimestamp());
        this.inputCount.setValue((Object)new Long(this.getInputCountValue()), GpioProfile.getCurrentTimestamp());
        int inputInt = (int)this.getInputCountValue();
        this.inputFalseMap = new Hashtable(inputInt * 2 + 1);
        int i = 1;
        while (i <= inputInt) {
            this.inputFalseMap.put(INPUT_NAMES[i], Boolean.FALSE);
            ++i;
        }
    }

    private void setupOutput() {
        this.output.setValue(new Hashtable(), GpioProfile.getCurrentTimestamp());
        this.outputCount.setValue((Object)new Long(this.getOutputCountValue()), GpioProfile.getCurrentTimestamp());
        int outputInt = (int)this.getOutputCountValue();
        this.outputOnMap = new Hashtable(outputInt * 2 + 1);
        this.outputOffMap = new Hashtable(outputInt * 2 + 1);
        int i = 1;
        while (i <= outputInt) {
            this.outputOnMap.put(OUTPUT_NAMES[i], Boolean.TRUE);
            this.outputOffMap.put(OUTPUT_NAMES[i], Boolean.FALSE);
            ++i;
        }
    }

    private void storeMapInLdap(Dictionary data) {
        Map values = (Map)data.get("value");
        if (values == null) {
            return;
        }
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = values.get(key);
            this.ldapMap.put(key, value);
        }
        this.evaluateFilters();
    }

    protected abstract void turnOffAllOutputs();

    protected abstract void turnOnAllOutputs();

    protected void updateAnalogOutputs(Map newState, Map request) {
    }

    protected void updateFilter(int index, Object newValue) {
        Filter filter = null;
        if (newValue instanceof String && ((String)newValue).length() > 0) {
            String filterString = (String)newValue;
            try {
                filter = this.createFilter(filterString);
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Gpio OutputExpression: " + index);
            }
        }
        this.outputFilters[index] = filter;
        this.evaluateFilters();
    }

    protected abstract void updateOutputs(Map var1, Map var2);
}

