/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.profile;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.core.Worker;
import org.eclipse.soda.dk.core.service.WorkerService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.service.RfidInventoryProfileService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class RfidInventoryProfile
extends Profile
implements ProfileService,
RfidInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile";
    public static final String GPIO_PROFILE_PREFIX = "GpioProfilePrefix";
    protected String gpioProfileServiceInputExternalKey = null;
    protected String gpioProfileServiceInputGetExternalKey = null;
    protected String gpioProfileServiceAnalogInputExternalKey = null;
    protected String gpioProfileServiceAnalogInputGetExternalKey = null;
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    protected String controlProfileServiceBitsExternalKey = null;
    protected String controlProfileServiceBitsGetExternalKey = null;
    protected String controlProfileServiceLongsExternalKey = null;
    protected String controlProfileServiceLongsGetExternalKey = null;
    protected final MethodMeasurement tagReadingExpression = new MethodMeasurement("RfidInventory/TagReadingExpression");
    protected final MethodMeasurement tagReading = new MethodMeasurement("RfidInventory/TagReading", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagAggregatingExpression = new MethodMeasurement("RfidInventory/TagAggregatingExpression");
    protected final MethodMeasurement tagAggregating = new MethodMeasurement("RfidInventory/TagAggregating", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagMaskSetting = new MethodMeasurement("RfidInventory/TagMaskSetting");
    protected final MethodMeasurement duplicateFilteringExpression = new MethodMeasurement("RfidInventory/DuplicateFilteringExpression");
    protected final MethodMeasurement duplicateFiltering = new MethodMeasurement("RfidInventory/DuplicateFiltering", (Object)Boolean.FALSE);
    protected final MethodMeasurement aggregationMaskSetting = new MethodMeasurement("RfidInventory/AggregationMaskSetting");
    protected final MethodMeasurement dataExtensions = new MethodMeasurement("RfidInventory/DataExtensions");
    protected final Signal tagReport = new Signal("RfidInventory/TagReport");
    protected final Signal tagAggregationReport = new Signal("RfidInventory/TagAggregationReport");
    private int readStopTimeout = 2000;
    private static final Byte COMMAND_DEACTIVATE_BY_MEASUREMENT_BYTE = new Byte(0);
    private static final byte COMMAND_DEACTIVATE_BY_MEASUREMENT = 0;
    private static final Byte COMMAND_ACTIVATE_BY_MEASUREMENT_BYTE = new Byte(1);
    private static final byte COMMAND_ACTIVATE_BY_MEASUREMENT = 1;
    private static final Byte COMMAND_TRIGGERED_BY_EXPRESSION_BYTE = new Byte(2);
    private static final byte COMMAND_TRIGGERED_BY_EXPRESSION = 2;
    protected String gpioInput;
    private Filter tagAggregatingLdapFilter;
    private Filter tagReadingLdapFilter;
    private Filter duplicateFilteringLdapFilter;
    private Dictionary ldapMap = new Hashtable(67);
    protected InterestMasks tagInterest = new InterestMasks();
    protected InterestMasks aggregationInterest = new InterestMasks();
    private Map cachedTags = new Hashtable(1031);
    private Map aggregatedTags = new Hashtable(1031);
    private final Object waitForReadStop = new Object();
    private final Object sequentialLdapLock = new Object();
    private Worker readStopCommandConsumerWorker;
    private IQueue readerStopCommandQueue;

    public RfidInventoryProfile() {
        super("RfidInventoryProfile/Capabilities", "RfidInventoryProfile/Status", "RfidInventoryProfile/Configuration", "RfidInventoryProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getGpioProfilePrefix() {
        return this.getString(GPIO_PROFILE_PREFIX, this.getPrefix());
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.gpioProfileServiceInputExternalKey)) {
            this.handleGpioProfileServiceInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.gpioProfileServiceAnalogInputExternalKey)) {
            this.handleGpioProfileServiceAnalogInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void setupNotification() {
        String gpioProfilePrefix = this.getGpioProfilePrefix();
        this.gpioProfileServiceInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input");
        this.gpioProfileServiceInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input/get");
        this.gpioProfileServiceAnalogInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput");
        this.gpioProfileServiceAnalogInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput/get");
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs/get");
        this.register(new String[]{this.gpioProfileServiceInputExternalKey, this.gpioProfileServiceAnalogInputExternalKey, this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey});
        super.setupNotification();
        this.broadcast(this.gpioProfileServiceInputGetExternalKey, new Hashtable());
        this.broadcast(this.gpioProfileServiceAnalogInputGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.tagAggregating == source) {
            this.handleTagAggregating(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.duplicateFiltering == source) {
            this.handleDuplicateFiltering(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public String getDefaultKey() {
        return "RfidInventoryProfile";
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public int getControlCapacity() {
        return 17;
    }

    public int getMessageCapacity() {
        return 2;
    }

    public MeasurementService getTagReadingExpression() {
        return this.tagReadingExpression;
    }

    public MeasurementService getTagReading() {
        return this.tagReading;
    }

    public MeasurementService getTagAggregatingExpression() {
        return this.tagAggregatingExpression;
    }

    public MeasurementService getTagAggregating() {
        return this.tagAggregating;
    }

    public MeasurementService getTagMaskSetting() {
        return this.tagMaskSetting;
    }

    public MeasurementService getDuplicateFilteringExpression() {
        return this.duplicateFilteringExpression;
    }

    public MeasurementService getDuplicateFiltering() {
        return this.duplicateFiltering;
    }

    public MeasurementService getAggregationMaskSetting() {
        return this.aggregationMaskSetting;
    }

    public MeasurementService getDataExtensions() {
        return this.dataExtensions;
    }

    public SignalService getTagReport() {
        return this.tagReport;
    }

    public SignalService getTagAggregationReport() {
        return this.tagAggregationReport;
    }

    private void initialize() {
        this.put((ControlService)this.tagReadingExpression);
        this.put((ControlService)this.tagReading);
        this.put((ControlService)this.tagAggregatingExpression);
        this.put((ControlService)this.tagAggregating);
        this.tagAggregating.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.tagMaskSetting);
        this.put((ControlService)this.duplicateFilteringExpression);
        this.put((ControlService)this.duplicateFiltering);
        this.duplicateFiltering.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.aggregationMaskSetting);
        this.put((ControlService)this.dataExtensions);
        this.put((ControlService)this.tagReport);
        this.put((ControlService)this.tagAggregationReport);
    }

    public void setReadStopTimeout(int readStopTimeout) {
        this.readStopTimeout = readStopTimeout;
    }

    public int getReadStopTimeout() {
        return this.readStopTimeout;
    }

    public void setup() {
        super.setup();
        this.setReadStopTimeout(this.getInt("rfidinventoryprofile.readStopTimeout", this.getReadStopTimeout()));
    }

    public static String[] parseDelimitedByToken(String target, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(target, delimiter);
        String[] values = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            values[index++] = tokenizer.nextToken().trim();
        }
        return values;
    }

    public static byte[] parseHexSpaceDelimited(String spaceDelimitedHex) {
        StringTokenizer tokenizer = new StringTokenizer(spaceDelimitedHex);
        byte[] value = new byte[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String byteHex = tokenizer.nextToken();
            byte byteValue = 0;
            byteValue = (byte)Integer.parseInt(byteHex, 16);
            value[index++] = byteValue;
        }
        return value;
    }

    public static InterestMasks parseInterestMasks(String targetTagConfig) {
        InterestMasks interests = new InterestMasks();
        if (targetTagConfig != null) {
            try {
                String[] masksConfig = RfidInventoryProfile.parseDelimitedByToken(targetTagConfig, ";");
                int i = 0;
                while (i < masksConfig.length) {
                    String[] configParam = RfidInventoryProfile.parseDelimitedByToken(masksConfig[i], ",");
                    int offset = Integer.parseInt(configParam[1]);
                    int length = Integer.parseInt(configParam[2]);
                    byte[] pattern = RfidInventoryProfile.parseHexSpaceDelimited(configParam[3]);
                    InterestMask interest = new InterestMask(offset, length, pattern);
                    interests.add((InterestService)interest);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("parseInterestMasks: " + targetTagConfig);
            }
        }
        return interests;
    }

    public static byte[] toBytes(String string) throws RuntimeException {
        char[] characters = string.toCharArray();
        int length = characters.length + 1 >> 1;
        byte[] tag = new byte[length];
        int index = characters.length % 2;
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            int digit = character - 48;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            if (digit > 9 && ((digit = character - 87) & 0xFFFFFFF0) != 0 && ((digit = character - 55) & 0xFFFFFFF0) != 0) {
                throw new NumberFormatException();
            }
            tag[index >> 1] = index % 2 == 0 ? (byte)(digit << 4) : (byte)((tag[index >> 1] & 0xF0) + digit);
            ++index;
            ++i;
        }
        return tag;
    }

    public void activate() {
        this.setupReadStopConsumerThread();
        this.applyTagReading(this.getTagReadingValue());
        super.activate();
    }

    protected void addTagToCache(String key, Map reads, Map cache) {
        cache.put(key, reads);
    }

    private void applyAggregating(String key, Map reads) {
        byte[] tagBytes = RfidInventoryProfile.toBytes(key);
        boolean isAggregating = (Boolean)this.getTagAggregating().getValue();
        if (isAggregating && this.aggregationInterest.isInterested(tagBytes)) {
            if (this.getTagReadingValue()) {
                this.updateTagInCache(key, reads, this.aggregatedTags);
            } else {
                Map tagErrorMap = this.buildTagMessage(key, reads);
                this.triggerTagAggregationReport(tagErrorMap, true);
            }
        }
    }

    protected void applyDataExtensions(Map rfidData) {
        Map extensions = (Map)this.dataExtensions.getValue();
        if (extensions == null || extensions.isEmpty()) {
            rfidData.put("dataExtensions", new Hashtable(11));
        } else {
            Map existingDataExtensions = (Map)rfidData.get("dataExtensions");
            Map mergedDataExt = this.mergeMapOverMap(extensions, existingDataExtensions);
            rfidData.put("dataExtensions", mergedDataExt);
        }
    }

    private boolean applyFiltering(String key, Map reads) {
        boolean passesFilter = false;
        byte[] tagBytes = RfidInventoryProfile.toBytes(key);
        if (this.tagInterest.isInterested(tagBytes)) {
            boolean isDuplicateFiltering = (Boolean)this.getDuplicateFiltering().getValue();
            if (isDuplicateFiltering) {
                if (!this.isDuplicateTag(key)) {
                    passesFilter = true;
                    this.addTagToCache(key, reads, this.cachedTags);
                }
            } else {
                passesFilter = true;
            }
        }
        return passesFilter;
    }

    private void applyLdap() {
        this.scheduleReadCommand(COMMAND_TRIGGERED_BY_EXPRESSION_BYTE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTagReading(boolean reading) {
        if (!this.isStarted()) {
            Object object = this.waitForReadStop;
            synchronized (object) {
                this.tagReading.setValue((Object)Boolean.FALSE, RfidInventoryProfile.getCurrentTimestamp());
            }
            return;
        }
        if (reading) {
            this.scheduleReadCommand(COMMAND_ACTIVATE_BY_MEASUREMENT_BYTE);
        } else {
            this.scheduleReadCommand(COMMAND_DEACTIVATE_BY_MEASUREMENT_BYTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTagReadingFalse() throws InterruptedException {
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (!this.getBooleanValue(this.tagReading.getValue()).booleanValue()) {
                return;
            }
            long readTimeout = this.getReadStopTimeout();
            boolean requiresWait = this.autonomousModeOff();
            if (requiresWait && readTimeout > 0L) {
                this.waitForReadStop.wait(readTimeout);
            }
            this.tagReading.setValue((Object)Boolean.FALSE, RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTagReadingTrue() {
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (this.getBooleanValue(this.tagReading.getValue()).booleanValue()) {
                return;
            }
            this.tagReading.setValue((Object)Boolean.TRUE, RfidInventoryProfile.getCurrentTimestamp());
            this.autonomousModeOn();
        }
    }

    protected abstract boolean autonomousModeOff();

    protected abstract boolean autonomousModeOn();

    protected Map buildOuterTagMessage(Map tags) {
        Hashtable<String, Map> tagMap = new Hashtable<String, Map>(13);
        tagMap.put("tags", tags);
        this.applyDataExtensions(tagMap);
        return tagMap;
    }

    protected Map buildTagMessage(String key, Map reads) {
        Hashtable<String, Map> tags = new Hashtable<String, Map>(7);
        tags.put(key, reads);
        Map tagMap = this.buildOuterTagMessage(tags);
        return tagMap;
    }

    protected void consumeReadStopCommands() throws InterruptedException {
        Object typeObj = this.getReaderStopCommandQueue().remove();
        if (typeObj instanceof Byte) {
            switch ((Byte)typeObj) {
                case 0: {
                    this.applyTagReadingFalse();
                    break;
                }
                case 1: {
                    this.applyTagReadingTrue();
                    break;
                }
                case 2: {
                    this.evaluateLdapFilters();
                }
            }
        }
    }

    protected Filter createLdapFilter(String filterString) throws InvalidSyntaxException {
        Filter result = null;
        result = this.createFilter(filterString);
        return result;
    }

    private IQueue createQueue(int capacity) {
        FactoryUtility utility = FactoryUtility.getInstance();
        IQueue queue = utility.createQueue(capacity);
        return queue;
    }

    public void deactivate() {
        if (this.readStopCommandConsumerWorker != null && this.readStopCommandConsumerWorker.isRunning()) {
            this.readStopCommandConsumerWorker.stop();
        }
        this.readStopCommandConsumerWorker = null;
        super.deactivate();
    }

    protected void evaluateDuplicateFilteringLdapFilter() {
        if (this.duplicateFilteringLdapFilter != null) {
            boolean duplicateFilteringResult = this.duplicateFilteringLdapFilter.match(this.ldapMap);
            this.duplicateFiltering.setValue((Object)new Boolean(duplicateFilteringResult), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateLdapFilters() throws InterruptedException {
        boolean evaluateReadingLast = true;
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (this.getTagReadingValue() && this.tagReadingLdapFilter != null && !this.tagReadingLdapFilter.match(this.ldapMap)) {
                evaluateReadingLast = false;
                this.applyTagReadingFalse();
            }
        }
        object = this.sequentialLdapLock;
        synchronized (object) {
            this.evaluateDuplicateFilteringLdapFilter();
            this.evaluateTagAggregatingLdapFilter();
            if (evaluateReadingLast) {
                this.evaluateTagReadingLdapFilter();
            }
        }
    }

    protected void evaluateTagAggregatingLdapFilter() {
        if (this.tagAggregatingLdapFilter != null) {
            boolean tagAggregatingResult = this.tagAggregatingLdapFilter.match(this.ldapMap);
            this.tagAggregating.setValue((Object)new Boolean(tagAggregatingResult), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    protected void evaluateTagReadingLdapFilter() {
        if (this.tagReadingLdapFilter != null) {
            boolean tagReadingResult = this.tagReadingLdapFilter.match(this.ldapMap);
            this.handleSetTagReading((Measurement)this.tagReading, new Boolean(tagReadingResult));
        }
    }

    public void flushAggregatorCache() {
        this.aggregatedTags = new Hashtable(1031);
    }

    public void flushTagCache() {
        this.cachedTags = new Hashtable(1031);
    }

    private WorkerService getReadStopCommandConsumerWorker() {
        WorkerService work = new WorkerService(){

            public boolean doWork() throws InterruptedException {
                RfidInventoryProfile.this.consumeReadStopCommands();
                return true;
            }
        };
        return work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueue getReaderStopCommandQueue() {
        RfidInventoryProfile rfidInventoryProfile = this;
        synchronized (rfidInventoryProfile) {
            if (this.readerStopCommandQueue == null) {
                this.readerStopCommandQueue = this.createQueue(13);
            }
            return this.readerStopCommandQueue;
        }
    }

    protected boolean getTagReadingValue() {
        if (this.getTagReading() == null || this.getTagReading().getValue() == null) {
            return false;
        }
        return (Boolean)this.getTagReading().getValue();
    }

    protected void handleControlProfileServiceBits(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleDuplicateFiltering(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (!newState) {
            this.flushTagCache();
        }
    }

    protected void handleGpioProfileServiceAnalogInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleGpioProfileServiceInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    public Object handleMethodAggregationMaskSetting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetAggregationMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodDataExtensions(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetDataExtensions(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodDuplicateFiltering(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.duplicateFilteringLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodDuplicateFiltering");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodDuplicateFilteringExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetDuplicateFilteringExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagAggregating(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagAggregatingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagAggregating");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagAggregatingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagAggregatingExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagMaskSetting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagReading(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagReadingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagReading");
                }
                this.handleSetTagReading(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagReadingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagReadingExpression(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetAggregationMaskSetting(Measurement measurement, Object data) {
        if (!(data instanceof String)) {
            throw new IllegalArgumentException("handleSetAggregationMaskSetting: " + data);
        }
        this.aggregationInterest = RfidInventoryProfile.parseInterestMasks((String)data);
        measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
    }

    protected void handleSetDataExtensions(Measurement measurement, Object newValue) {
        Map newExtensions = null;
        if (newValue instanceof Map) {
            Map additionalExtensions = (Map)newValue;
            if (additionalExtensions.isEmpty()) {
                newExtensions = new Hashtable(11);
            } else {
                Map existingExtensions = (Map)measurement.getValue();
                newExtensions = this.mergeMapOverMap(additionalExtensions, existingExtensions);
            }
        } else if (newValue == null) {
            newExtensions = new Hashtable(11);
        }
        if (newExtensions == null) {
            throw new IllegalArgumentException("handleSetDataExtensions: " + newValue);
        }
        measurement.setValue(newExtensions, RfidInventoryProfile.getCurrentTimestamp());
    }

    protected void handleSetDuplicateFilteringExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter dupFilter = this.createLdapFilter((String)data);
                    this.setFilterDuplicatesLdapFilter(dupFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setFilterDuplicatesLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetDuplicateFilteringExpression: " + data);
    }

    protected void handleSetTagAggregatingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setTagAggregatingLdapFilter(aggFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagAggregatingLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleTagAggregatingExpression: " + data);
    }

    protected void handleSetTagMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.tagInterest = RfidInventoryProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagMaskSetting: " + data);
    }

    protected void handleSetTagReading(Measurement measurement, Object data) {
        boolean newState = this.getBooleanValue(data);
        this.applyTagReading(newState);
    }

    protected void handleSetTagReadingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter readFilter = this.createLdapFilter((String)data);
                    this.setTagReadingLdapFilter(readFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagReadingLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetTagReadingExpression: " + data);
    }

    protected void handleTagAggregating(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (oldValue != null) {
            this.applyDataExtensions(this.cachedTags);
            if (!newState) {
                this.notifyTagAggregation();
                this.flushAggregatorCache();
            }
        }
    }

    protected boolean isDuplicateTag(String key) {
        return this.cachedTags.containsKey(key);
    }

    protected Map mergeMapOverMap(Map additionalValues, Map existingValues) {
        Object value;
        Object key;
        Iterator i;
        Hashtable newExtensions = new Hashtable(17);
        if (existingValues != null) {
            i = existingValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = existingValues.get(key);
                newExtensions.put(key, value);
            }
        }
        if (additionalValues != null) {
            i = additionalValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = additionalValues.get(key);
                newExtensions.put(key, value);
            }
        }
        return newExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReadStop() {
        Object object = this.waitForReadStop;
        synchronized (object) {
            this.waitForReadStop.notifyAll();
        }
    }

    public void notifyTagAggregation() {
        Map tagMap = this.buildOuterTagMessage(this.aggregatedTags);
        this.triggerTagAggregationReport(tagMap, false);
    }

    public void notifyTagRead(String key, Map reads) {
        boolean sendTag = false;
        sendTag = this.applyFiltering(key, reads);
        this.applyAggregating(key, reads);
        if (sendTag) {
            Map tagMap = this.buildTagMessage(key, reads);
            this.triggerTagReport(tagMap, false);
        }
    }

    public void notifyTagRead(Map tags) {
        Hashtable<String, Map> publishTags = new Hashtable<String, Map>(13);
        Iterator i = tags.keySet().iterator();
        while (i.hasNext()) {
            String tagKey = (String)i.next();
            Map tagReads = (Map)tags.get(tagKey);
            boolean sendTag = false;
            sendTag = this.applyFiltering(tagKey, tagReads);
            this.applyAggregating(tagKey, tagReads);
            if (!sendTag) continue;
            publishTags.put(tagKey, tagReads);
        }
        if (!publishTags.isEmpty()) {
            Map tagMap = this.buildOuterTagMessage(publishTags);
            this.triggerTagReport(tagMap, false);
        }
    }

    private void scheduleReadCommand(Byte type) {
        this.getReaderStopCommandQueue().add((Object)type);
    }

    protected void setFilterDuplicatesLdapFilter(Filter filterDuplicatesLdapFilter) {
        this.duplicateFilteringLdapFilter = filterDuplicatesLdapFilter;
        this.evaluateDuplicateFilteringLdapFilter();
    }

    protected void setTagAggregatingLdapFilter(Filter tagAggregatingLdapFilter) {
        this.tagAggregatingLdapFilter = tagAggregatingLdapFilter;
        this.evaluateTagAggregatingLdapFilter();
    }

    protected void setTagReadingLdapFilter(Filter tagReadingLdapFilter) {
        this.tagReadingLdapFilter = tagReadingLdapFilter;
        this.evaluateTagReadingLdapFilter();
    }

    private void setupReadStopConsumerThread() {
        WorkerService work = this.getReadStopCommandConsumerWorker();
        this.readStopCommandConsumerWorker = new Worker("RfidInventoryProfileRSC", work);
        this.readStopCommandConsumerWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMapInLdap(Dictionary data) {
        Dictionary dictionary = this.ldapMap;
        synchronized (dictionary) {
            Object tempValue = data.get("value");
            if (tempValue == null || !(tempValue instanceof Map)) {
                return;
            }
            Map values = (Map)tempValue;
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = values.get(key);
                this.ldapMap.put(key, value);
            }
            this.applyLdap();
        }
    }

    private void triggerTagAggregationReport(Map tagMap, boolean withError) {
        if (withError) {
            this.tagAggregationReport.fireErrorOccurred(RfidInventoryProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagAggregationReport.trigger((Object)tagMap);
        }
    }

    private void triggerTagReport(Map tagMap, boolean withError) {
        if (withError || !this.getTagReadingValue()) {
            this.tagReport.fireErrorOccurred(RfidInventoryProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagReport.trigger((Object)tagMap);
        }
    }

    protected void updateTagInCache(String key, Map reads, Map cache) {
        Map oldReadData = (Map)cache.get(key);
        if (oldReadData == null) {
            this.addTagToCache(key, reads, cache);
            return;
        }
        oldReadData.put("timestampLast", reads.get("timestampLast"));
        int newCount = (Integer)reads.get("count");
        int previousCount = (Integer)oldReadData.get("count");
        oldReadData.put("count", RfidInventoryProfile.createInteger((int)(newCount + previousCount)));
    }
}

