/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.mock.scenario.profile;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.gpio.profile.service.GpioProfileService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.mock.scenario.profile.service.RfidMockScenarioProfileService;

public class RfidMockScenarioProfile
extends Profile
implements ProfileService,
RfidMockScenarioProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.mock.scenario.profile.RfidMockScenarioProfile";
    public static final String GPIO_PROFILE_PREFIX = "GpioProfilePrefix";
    protected String gpioProfileServiceOutputRequestExternalKey = null;
    protected String gpioProfileServiceInputExternalKey = null;
    protected String gpioProfileServiceInputGetExternalKey = null;
    protected String gpioProfileServiceStatusExternalKey = null;
    protected String gpioProfileServiceStatusGetExternalKey = null;
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    protected String controlProfileServiceBitsExternalKey = null;
    protected String controlProfileServiceBitsGetExternalKey = null;
    protected String controlProfileServiceLongsExternalKey = null;
    protected String controlProfileServiceLongsGetExternalKey = null;
    public static final String RFID_INVENTORY_PROFILE_PREFIX = "RfidInventoryProfilePrefix";
    protected String rfidInventoryProfileServiceStatusExternalKey = null;
    protected String rfidInventoryProfileServiceStatusGetExternalKey = null;
    protected String rfidInventoryProfileServiceTagReadingExternalKey = null;
    protected String rfidInventoryProfileServiceTagReadingGetExternalKey = null;
    protected String rfidInventoryProfileServiceTagAggregatingExternalKey = null;
    protected String rfidInventoryProfileServiceTagAggregatingGetExternalKey = null;
    protected String rfidInventoryProfileServiceDuplicateFilteringExternalKey = null;
    protected String rfidInventoryProfileServiceDuplicateFilteringGetExternalKey = null;
    protected String rfidInventoryProfileServiceTagReportExternalKey = null;
    protected String rfidInventoryProfileServiceTagAggregationReportExternalKey = null;
    private int scenario = 0;
    private static final String BLANK_STRING = "";
    private static final String I1_TRUE = "(i1=true)";
    private static final String I2_FALSE = "(i2=false)";
    private static final int SCENARIO_0 = 0;
    private static final int SCENARIO_1 = 1;
    private static final int SCENARIO_2 = 2;
    private static final int SCENARIO_3 = 3;
    private static final int SCENARIO_4 = 4;
    private boolean outputToggle = false;
    private String rfidInventoryProfileServiceTagReadingWriteExternalKey;
    private String rfidInventoryProfileServiceReadExpressionWriteExternalKey;
    private String rfidInventoryProfileServiceTagAggregatingWriteExternalKey;
    private String rfidInventoryProfileServiceDuplicateFilteringWriteExternalKey;
    private String gpioProfileServiceOutputRequestWriteExternalKey;
    private String controlProfileServiceBitsWriteExternalKey;
    private Dictionary inputValue = new Hashtable(13);

    public RfidMockScenarioProfile() {
        super("RfidMockScenarioProfile/Capabilities", "RfidMockScenarioProfile/Status", "RfidMockScenarioProfile/Configuration", "RfidMockScenarioProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getGpioProfilePrefix() {
        return this.getString(GPIO_PROFILE_PREFIX, this.getPrefix());
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public String getRfidInventoryProfilePrefix() {
        return this.getString(RFID_INVENTORY_PROFILE_PREFIX, this.getPrefix());
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.gpioProfileServiceOutputRequestExternalKey)) {
            this.handleGpioProfileServiceOutputRequest(externalKey, data);
            return;
        }
        if (externalKey.equals(this.gpioProfileServiceInputExternalKey)) {
            this.handleGpioProfileServiceInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.gpioProfileServiceStatusExternalKey)) {
            this.handleGpioProfileServiceStatus(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceStatusExternalKey)) {
            this.handleRfidInventoryProfileServiceStatus(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceTagReadingExternalKey)) {
            this.handleRfidInventoryProfileServiceTagReading(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceTagAggregatingExternalKey)) {
            this.handleRfidInventoryProfileServiceTagAggregating(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceDuplicateFilteringExternalKey)) {
            this.handleRfidInventoryProfileServiceDuplicateFiltering(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceTagReportExternalKey)) {
            this.handleRfidInventoryProfileServiceTagReport(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceTagAggregationReportExternalKey)) {
            this.handleRfidInventoryProfileServiceTagAggregationReport(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void setupNotification() {
        String gpioProfilePrefix = this.getGpioProfilePrefix();
        this.gpioProfileServiceOutputRequestExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/OutputRequest");
        this.gpioProfileServiceInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input");
        this.gpioProfileServiceInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input/get");
        this.gpioProfileServiceStatusExternalKey = this.prependPrefix(gpioProfilePrefix, "GpioProfile/Status");
        this.gpioProfileServiceStatusGetExternalKey = this.prependPrefix(gpioProfilePrefix, "GpioProfile/Status/get");
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs/get");
        String rfidInventoryProfilePrefix = this.getRfidInventoryProfilePrefix();
        this.rfidInventoryProfileServiceStatusExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventoryProfile/Status");
        this.rfidInventoryProfileServiceStatusGetExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventoryProfile/Status/get");
        this.rfidInventoryProfileServiceTagReadingExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagReading");
        this.rfidInventoryProfileServiceTagReadingGetExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagReading/get");
        this.rfidInventoryProfileServiceTagAggregatingExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagAggregating");
        this.rfidInventoryProfileServiceTagAggregatingGetExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagAggregating/get");
        this.rfidInventoryProfileServiceDuplicateFilteringExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/DuplicateFiltering");
        this.rfidInventoryProfileServiceDuplicateFilteringGetExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/DuplicateFiltering/get");
        this.rfidInventoryProfileServiceTagReportExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagReport");
        this.rfidInventoryProfileServiceTagAggregationReportExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagAggregationReport");
        this.register(new String[]{this.gpioProfileServiceOutputRequestExternalKey, this.gpioProfileServiceInputExternalKey, this.gpioProfileServiceStatusExternalKey, this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey, this.rfidInventoryProfileServiceStatusExternalKey, this.rfidInventoryProfileServiceTagReadingExternalKey, this.rfidInventoryProfileServiceTagAggregatingExternalKey, this.rfidInventoryProfileServiceDuplicateFilteringExternalKey, this.rfidInventoryProfileServiceTagReportExternalKey, this.rfidInventoryProfileServiceTagAggregationReportExternalKey});
        super.setupNotification();
        this.broadcast(this.gpioProfileServiceInputGetExternalKey, new Hashtable());
        this.broadcast(this.gpioProfileServiceStatusGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
        this.broadcast(this.rfidInventoryProfileServiceStatusGetExternalKey, new Hashtable());
        this.broadcast(this.rfidInventoryProfileServiceTagReadingGetExternalKey, new Hashtable());
        this.broadcast(this.rfidInventoryProfileServiceTagAggregatingGetExternalKey, new Hashtable());
        this.broadcast(this.rfidInventoryProfileServiceDuplicateFilteringGetExternalKey, new Hashtable());
    }

    public String getDefaultKey() {
        return "RfidMockScenarioProfile";
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    private void initialize() {
    }

    public void setScenario(int scenario) {
        this.scenario = scenario;
    }

    public int getScenario() {
        return this.scenario;
    }

    public void setup() {
        super.setup();
        this.setScenario(this.getInt("rfidmockscenarioprofile.scenario", this.getScenario()));
    }

    public void activate() {
        this.gpioProfileServiceOutputRequestWriteExternalKey = this.prependPrefix("Gpio/OutputRequest/execute");
        this.controlProfileServiceBitsWriteExternalKey = this.prependPrefix("Control/Bits/write");
        this.rfidInventoryProfileServiceTagReadingWriteExternalKey = this.prependPrefix("RfidInventory/TagReading/write");
        this.rfidInventoryProfileServiceReadExpressionWriteExternalKey = this.prependPrefix("RfidInventory/TagReadingExpression/write");
        this.rfidInventoryProfileServiceTagAggregatingWriteExternalKey = this.prependPrefix("RfidInventory/TagAggregating/write");
        this.rfidInventoryProfileServiceDuplicateFilteringWriteExternalKey = this.prependPrefix("RfidInventory/DuplicateFiltering/write");
        super.activate();
    }

    public void deactivate() {
        this.notifyReaderActivation(false);
        super.deactivate();
    }

    private void formatLog(int severity, Object value, String label) {
        StringBuffer message = new StringBuffer(75);
        message = message.append(this.getQualifiedKey());
        message.append(": ");
        message.append(label);
        message.append(" - ");
        message.append(value);
        this.log(severity, message.toString());
    }

    private boolean getActiveStatus(Dictionary data) {
        int state;
        boolean isActive = false;
        Object value = data.get("value");
        if (value instanceof Dictionary && ((Dictionary)value).get("state") instanceof Integer && (state = ((Integer)((Dictionary)value).get("state")).intValue()) == 5) {
            isActive = true;
        }
        return isActive;
    }

    private void handleControlProfileServiceBits(String externalKey, Dictionary data) {
    }

    private void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
    }

    private void handleGpioProfileInput1(Boolean state1) {
        switch (this.getScenario()) {
            case 0: 
            case 1: {
                this.notifyReaderActivation(state1);
                break;
            }
            case 2: 
            case 3: {
                this.notifyControlFlip(state1);
                break;
            }
            case 4: {
                this.notifyTagReadingExpression(state1, I1_TRUE);
            }
        }
    }

    private void handleGpioProfileInput2(Boolean state2) {
        switch (this.getScenario()) {
            case 0: {
                this.notifyDuplicateFiltering(state2);
                break;
            }
            case 4: {
                this.notifyTagReadingExpression(state2, I2_FALSE);
            }
        }
    }

    private void handleGpioProfileInput3(Boolean state3) {
        switch (this.getScenario()) {
            case 0: {
                this.notifyTagAggregation(state3);
            }
        }
    }

    private void handleGpioProfileInput4(Boolean state4) {
        switch (this.getScenario()) {
            case 4: {
                this.notifyGpioOutputAll(state4);
            }
        }
    }

    private void handleGpioProfileInputChanged(int pin, Boolean state) {
        switch (pin) {
            case 1: {
                this.handleGpioProfileInput1(state);
                break;
            }
            case 2: {
                this.handleGpioProfileInput2(state);
                break;
            }
            case 3: {
                this.handleGpioProfileInput3(state);
                break;
            }
            case 4: {
                this.handleGpioProfileInput4(state);
            }
        }
    }

    private void handleGpioProfileServiceInput(String externalKey, Dictionary data) {
        Object value = data.get("value");
        if (value instanceof Dictionary) {
            int i = 1;
            while (i <= 4) {
                if (((Dictionary)value).get(GpioProfileService.INPUT_NAMES[i]) instanceof Boolean) {
                    Boolean state = (Boolean)((Dictionary)value).get(GpioProfileService.INPUT_NAMES[i]);
                    Boolean storedState = (Boolean)this.inputValue.get(GpioProfileService.INPUT_NAMES[i]);
                    if (storedState == null || !storedState.equals(state)) {
                        this.inputValue.put(GpioProfileService.INPUT_NAMES[i], state);
                        this.handleGpioProfileInputChanged(i, state);
                    }
                }
                ++i;
            }
        }
    }

    private void handleGpioProfileServiceOutputRequest(String externalKey, Dictionary data) {
    }

    private void handleGpioProfileServiceStatus(String externalKey, Dictionary data) {
        switch (this.getScenario()) {
            case 0: 
            case 1: 
            case 2: {
                this.notifyGpioOutput("o1", new Boolean(this.getActiveStatus(data)));
            }
        }
    }

    private void handleRfidInventoryProfileServiceDuplicateFiltering(String externalKey, Dictionary data) {
        this.formatLog(3, data, this.rfidInventoryProfileServiceDuplicateFilteringExternalKey);
    }

    private void handleRfidInventoryProfileServiceStatus(String externalKey, Dictionary data) {
        this.formatLog(3, data, this.rfidInventoryProfileServiceStatusExternalKey);
    }

    private void handleRfidInventoryProfileServiceTagAggregating(String externalKey, Dictionary data) {
        this.formatLog(3, data, this.rfidInventoryProfileServiceTagAggregatingExternalKey);
    }

    private void handleRfidInventoryProfileServiceTagAggregationReport(String externalKey, Dictionary data) {
        Map value = (Map)data.get("value");
        Map tags = (Map)value.get("tags");
        this.formatLog(3, String.valueOf(tags.size()), "**** TAG AGGREGATION COUNT ****");
    }

    private void handleRfidInventoryProfileServiceTagReading(String externalKey, Dictionary data) {
        Object state = data.get("value");
        this.formatLog(3, data, this.rfidInventoryProfileServiceTagReadingExternalKey);
        if (state instanceof Boolean && this.scenario != 3) {
            this.notifyGpioOutput("o2", (Boolean)state);
        }
    }

    private void handleRfidInventoryProfileServiceTagReport(String externalKey, Dictionary data) {
        Map value = (Map)data.get("value");
        Map tags = (Map)value.get("tags");
        Iterator i = tags.keySet().iterator();
        while (i.hasNext()) {
            String tagKey = (String)i.next();
            this.formatLog(3, tagKey, "#### TAG REPORT ####");
            switch (this.getScenario()) {
                case 0: 
                case 2: {
                    this.notifyGpioOutputToggle();
                    this.notifyGpioOutputToggle();
                }
            }
        }
    }

    private void notifyControlFlip(boolean state) {
        Hashtable<String, Boolean> data1 = new Hashtable<String, Boolean>(11);
        data1.put("b1", new Boolean(state));
        Hashtable<String, Hashtable<String, Boolean>> map1 = new Hashtable<String, Hashtable<String, Boolean>>(11);
        ((Dictionary)map1).put("value", data1);
        this.getNotificationService().broadcast(this.controlProfileServiceBitsWriteExternalKey, map1);
    }

    private void notifyDuplicateFiltering(boolean state) {
        Hashtable<String, Boolean> message = new Hashtable<String, Boolean>(13);
        ((Dictionary)message).put("value", new Boolean(state));
        this.getNotificationService().broadcast(this.rfidInventoryProfileServiceDuplicateFilteringWriteExternalKey, message);
    }

    private void notifyGpioOutput(String outputKey, Boolean state) {
        Hashtable<String, Boolean> outputs = new Hashtable<String, Boolean>(13);
        ((Dictionary)outputs).put(outputKey, state);
        this.sendOutputRequestMessage(outputs);
    }

    private void notifyGpioOutputAll(Boolean state) {
        this.notifyGpioOutput("o0", state);
    }

    private void notifyGpioOutputToggle() {
        Hashtable<String, Boolean> outputs = new Hashtable<String, Boolean>(13);
        ((Dictionary)outputs).put("o3", new Boolean(this.outputToggle));
        ((Dictionary)outputs).put("o4", new Boolean(!this.outputToggle));
        this.outputToggle = !this.outputToggle;
        this.sendOutputRequestMessage(outputs);
    }

    private void notifyReaderActivation(boolean state) {
        Hashtable<String, Boolean> message = new Hashtable<String, Boolean>(13);
        ((Dictionary)message).put("value", new Boolean(state));
        this.formatLog(3, String.valueOf(state), this.rfidInventoryProfileServiceTagReadingWriteExternalKey);
        this.getNotificationService().broadcast(this.rfidInventoryProfileServiceTagReadingWriteExternalKey, message);
    }

    private void notifyTagAggregation(boolean state) {
        Hashtable<String, Boolean> message = new Hashtable<String, Boolean>(13);
        ((Dictionary)message).put("value", new Boolean(state));
        this.getNotificationService().broadcast(this.rfidInventoryProfileServiceTagAggregatingWriteExternalKey, message);
    }

    private void notifyTagReadingExpression(boolean setLdap, String expression) {
        Hashtable<String, String> message = new Hashtable<String, String>(13);
        String newValue = BLANK_STRING;
        if (setLdap) {
            newValue = expression;
        }
        ((Dictionary)message).put("value", newValue);
        this.getNotificationService().broadcast(this.rfidInventoryProfileServiceReadExpressionWriteExternalKey, message);
    }

    private void sendOutputRequestMessage(Dictionary outputs) {
        Hashtable<String, Dictionary> message = new Hashtable<String, Dictionary>(13);
        ((Dictionary)message).put("value", outputs);
        this.getNotificationService().broadcast(this.gpioProfileServiceOutputRequestWriteExternalKey, message);
    }
}

