/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.write.profile;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.MethodCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.write.profile.service.RfidWriteProfileService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class RfidWriteProfile
extends Profile
implements ProfileService,
RfidWriteProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.write.profile.RfidWriteProfile";
    public static final String GPIO_PROFILE_PREFIX = "GpioProfilePrefix";
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    protected String gpioProfileServiceInputExternalKey = null;
    protected String gpioProfileServiceInputGetExternalKey = null;
    protected String gpioProfileServiceAnalogInputExternalKey = null;
    protected String gpioProfileServiceAnalogInputGetExternalKey = null;
    protected String controlProfileServiceBitsExternalKey = null;
    protected String controlProfileServiceBitsGetExternalKey = null;
    protected String controlProfileServiceLongsExternalKey = null;
    protected String controlProfileServiceLongsGetExternalKey = null;
    protected final MethodCommand writeOperationsExecuteRequest = new MethodCommand("RfidWrite/WriteOperationsExecuteRequest");
    protected final MethodCommand writeOperationsStopRequest = new MethodCommand("RfidWrite/WriteOperationsStopRequest");
    protected final MethodMeasurement antennaConfiguration = new MethodMeasurement("RfidWrite/AntennaConfiguration");
    protected final MethodMeasurement dataWriteExtensions = new MethodMeasurement("RfidWrite/DataWriteExtensions");
    protected final MethodMeasurement tagWriteMaskSetting = new MethodMeasurement("RfidWrite/TagWriteMaskSetting");
    protected final MethodMeasurement tagAggregationWriteMaskSetting = new MethodMeasurement("RfidWrite/TagAggregationWriteMaskSetting");
    protected final MethodMeasurement tagWriteAggregatingExpression = new MethodMeasurement("RfidWrite/TagWriteAggregatingExpression");
    protected final MethodMeasurement tagWriteAggregating = new MethodMeasurement("RfidWrite/TagWriteAggregating", (Object)Boolean.FALSE);
    protected final MethodMeasurement writeOperations = new MethodMeasurement("RfidWrite/WriteOperations");
    protected final MethodMeasurement writeOperationsExpression = new MethodMeasurement("RfidWrite/WriteOperationsExpression");
    protected final MethodMeasurement writeOperationsExecuteStatus = new MethodMeasurement("RfidWrite/WriteOperationsExecuteStatus", (Object)Boolean.FALSE);
    protected final Signal tagWriteReport = new Signal("RfidWrite/TagWriteReport");
    protected final Signal tagWriteAggregationReport = new Signal("RfidWrite/TagWriteAggregationReport");
    private Dictionary ldapMap = new Hashtable(67);
    private Filter writeOperationLdapFilter;
    private Map cachedTags = new Hashtable(1031);
    private Map aggregatedTags = new Hashtable(1031);
    protected InterestMasks tagInterest = new InterestMasks();
    protected InterestMasks aggregationInterest = new InterestMasks();
    private Filter tagWriteAggregatingLdapFilter;
    protected final MethodMeasurement dataExtensions = new MethodMeasurement("RfidWrite/DataWriteExtensions");

    protected RfidWriteProfile() {
        super("RfidWriteProfile/Capabilities", "RfidWriteProfile/Status", "RfidWriteProfile/Configuration", "RfidWriteProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public static boolean isValidTagId(String tagId) {
        try {
            char[] tagIdChars = tagId.toCharArray();
            int i = 0;
            while (i < tagIdChars.length) {
                Integer.valueOf(String.valueOf(tagIdChars[i]), 16);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static String[] parseDelimitedByToken(String target, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(target, delimiter);
        String[] values = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            values[index++] = tokenizer.nextToken().trim();
        }
        return values;
    }

    public static byte[] parseHexSpaceDelimited(String spaceDelimitedHex) {
        StringTokenizer tokenizer = new StringTokenizer(spaceDelimitedHex);
        byte[] value = new byte[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String byteHex = tokenizer.nextToken();
            byte byteValue = 0;
            byteValue = (byte)Integer.parseInt(byteHex, 16);
            value[index++] = byteValue;
        }
        return value;
    }

    public static InterestMasks parseInterestMasks(String targetTagConfig) {
        InterestMasks interests = new InterestMasks();
        if (targetTagConfig != null) {
            try {
                String[] masksConfig = RfidWriteProfile.parseDelimitedByToken(targetTagConfig, ";");
                int i = 0;
                while (i < masksConfig.length) {
                    String[] configParam = RfidWriteProfile.parseDelimitedByToken(masksConfig[i], ",");
                    int offset = Integer.parseInt(configParam[1]);
                    int length = Integer.parseInt(configParam[2]);
                    byte[] pattern = RfidWriteProfile.parseHexSpaceDelimited(configParam[3]);
                    InterestMask interest = new InterestMask(offset, length, pattern);
                    interests.add((InterestService)interest);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("parseInterestMasks: " + targetTagConfig);
            }
        }
        return interests;
    }

    public static byte[] toBytes(String string) throws RuntimeException {
        char[] characters = string.toCharArray();
        int length = characters.length + 1 >> 1;
        byte[] tag = new byte[length];
        int index = characters.length % 2;
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            int digit = character - 48;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            if (digit > 9 && ((digit = character - 87) & 0xFFFFFFF0) != 0 && ((digit = character - 55) & 0xFFFFFFF0) != 0) {
                throw new NumberFormatException();
            }
            tag[index >> 1] = index % 2 == 0 ? (byte)(digit << 4) : (byte)((tag[index >> 1] & 0xF0) + digit);
            ++index;
            ++i;
        }
        return tag;
    }

    private void applyAggregating(String key, String operationId, Map reads) {
        byte[] tagBytes = RfidWriteProfile.toBytes(key);
        boolean isAggregating = (Boolean)this.getTagWriteAggregating().getValue();
        if (isAggregating && this.aggregationInterest.isInterested(tagBytes)) {
            this.updateTagInCache(key, operationId, reads, this.aggregatedTags);
        }
    }

    protected void applyDataExtensions(Map rfidData) {
        Map extensions = (Map)this.dataExtensions.getValue();
        if (extensions == null || extensions.isEmpty()) {
            rfidData.put("dataExtensions", new Hashtable(11));
        } else {
            Map existingDataExtensions = (Map)rfidData.get("dataExtensions");
            Map mergedDataExt = this.mergeMapOverMap(extensions, existingDataExtensions);
            rfidData.put("dataExtensions", mergedDataExt);
        }
    }

    private boolean applyFiltering(String key, Map reads) {
        boolean passesFilter = false;
        byte[] tagBytes = RfidWriteProfile.toBytes(key);
        if (this.tagInterest.isInterested(tagBytes)) {
            passesFilter = true;
        }
        return passesFilter;
    }

    private void applyLdap() {
        this.evaluateTagAggregatingLdapFilter();
        this.evaluateWriteOperationLdapFilter();
    }

    protected Map buildOuterTagMessage(Map tags) {
        Hashtable<String, Map> tagMap = new Hashtable<String, Map>(13);
        tagMap.put("tags", tags);
        this.applyDataExtensions(tagMap);
        return tagMap;
    }

    protected Map buildTagMessage(String key, Map reads) {
        Hashtable<String, Map> tags = new Hashtable<String, Map>(7);
        tags.put(key, reads);
        Map tagMap = this.buildOuterTagMessage(tags);
        return tagMap;
    }

    protected Filter createLdapFilter(String filterString) throws InvalidSyntaxException {
        Filter result = null;
        result = this.createFilter(filterString);
        return result;
    }

    protected abstract void endOperations();

    protected void evaluateTagAggregatingLdapFilter() {
        if (this.tagWriteAggregatingLdapFilter != null) {
            boolean tagAggregatingResult = this.tagWriteAggregatingLdapFilter.match(this.ldapMap);
            this.tagWriteAggregating.setValue((Object)new Boolean(tagAggregatingResult), RfidWriteProfile.getCurrentTimestamp());
        }
    }

    protected void evaluateWriteOperationLdapFilter() {
        if (this.writeOperationLdapFilter != null) {
            boolean writeOperationResult = this.writeOperationLdapFilter.match(this.ldapMap);
            if (writeOperationResult) {
                this.executeWriteOperations();
            } else {
                this.handleWriteOperationsStopRequest();
            }
        }
    }

    protected abstract boolean executeBlockErase(String[] var1);

    protected abstract boolean executeBlockWrite(String[] var1);

    protected abstract boolean executeFilter(String[] var1);

    protected abstract boolean executeIncrementWrite(String[] var1);

    protected abstract boolean executeKill(String[] var1);

    protected abstract boolean executeLock(String[] var1);

    protected abstract boolean executeRead(String[] var1);

    protected abstract void executeStop();

    protected abstract boolean executeWrite(String[] var1);

    protected void executeWriteOperations() {
        String writeOperations = (String)this.getWriteOperations().getValue();
        if (writeOperations == null) {
            throw new IllegalArgumentException("Fail to start the WriteOperations, WriteOperations string is null.");
        }
        String[] operations = RfidWriteProfile.parseDelimitedByToken(writeOperations, String.valueOf(':'));
        if (operations.length == 0) {
            throw new IllegalArgumentException("Fail to start the WriteOperations, WriteOperations string is empty.");
        }
        if (this.isOperationsRunning()) {
            throw new IllegalArgumentException("Fail to start the WriteOperations, an existing execution is in the process.");
        }
        this.startOperations();
        this.setOperationsStatusStarted();
        this.log(4, "Execute write operations: " + writeOperations);
        int i = 0;
        while (i < operations.length) {
            if (!this.isOperationsRunning()) {
                this.log(4, "Write operations interrupted: " + writeOperations);
                break;
            }
            this.log(4, "Execute write operation: " + operations[i]);
            String[] op_params = RfidWriteProfile.parseDelimitedByToken(operations[i], String.valueOf(';'));
            String command = op_params[0];
            boolean lastOperation = i == operations.length - 1;
            boolean opValid = false;
            if ("Filter".equals(command)) {
                opValid = this.executeFilter(op_params);
            } else if ("Increment Write".equals(command)) {
                opValid = this.executeIncrementWrite(op_params);
            } else if ("Read".equals(command)) {
                opValid = this.executeRead(op_params);
            } else if ("Write".equals(command)) {
                opValid = this.executeWrite(op_params);
            } else if ("Kill".equals(command)) {
                opValid = this.executeKill(op_params);
            } else if ("Lock".equals(command)) {
                opValid = this.executeLock(op_params);
            } else if ("BlockErase".equals(command)) {
                opValid = this.executeBlockErase(op_params);
            } else if ("BlockWrite".equals(command)) {
                opValid = this.executeBlockWrite(op_params);
            } else {
                this.endOperations();
                throw new IllegalArgumentException("Not supported operation: " + command);
            }
            if (!opValid) {
                this.endOperations();
                throw new IllegalArgumentException("Not valid operation: " + operations[i]);
            }
            if (lastOperation) {
                this.endOperations();
            }
            ++i;
        }
    }

    public void flushAggregatorCache() {
        this.aggregatedTags = new Hashtable(1031);
    }

    public void flushTagCache() {
        this.cachedTags = new Hashtable(1031);
    }

    public MeasurementService getAntennaConfiguration() {
        return this.antennaConfiguration;
    }

    public int getControlCapacity() {
        return 19;
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public MeasurementService getDataWriteExtensions() {
        return this.dataWriteExtensions;
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "RfidWriteProfile";
    }

    public String getGpioProfilePrefix() {
        return this.getString(GPIO_PROFILE_PREFIX, this.getPrefix());
    }

    public int getMessageCapacity() {
        return 2;
    }

    public MeasurementService getTagAggregationWriteMaskSetting() {
        return this.tagAggregationWriteMaskSetting;
    }

    public MeasurementService getTagWriteAggregating() {
        return this.tagWriteAggregating;
    }

    public MeasurementService getTagWriteAggregatingExpression() {
        return this.tagWriteAggregatingExpression;
    }

    public SignalService getTagWriteAggregationReport() {
        return this.tagWriteAggregationReport;
    }

    public MeasurementService getTagWriteMaskSetting() {
        return this.tagWriteMaskSetting;
    }

    public SignalService getTagWriteReport() {
        return this.tagWriteReport;
    }

    public MeasurementService getWriteOperations() {
        return this.writeOperations;
    }

    public CommandService getWriteOperationsExecuteRequest() {
        return this.writeOperationsExecuteRequest;
    }

    public MeasurementService getWriteOperationsExecuteStatus() {
        return this.writeOperationsExecuteStatus;
    }

    public MeasurementService getWriteOperationsExpression() {
        return this.writeOperationsExpression;
    }

    public CommandService getWriteOperationsStopRequest() {
        return this.writeOperationsStopRequest;
    }

    protected void handleControlProfileServiceBits(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleGetWriteOperationsExecuteStatus() {
        MethodMeasurement methodMeasurement = this.writeOperationsExecuteStatus;
        synchronized (methodMeasurement) {
            return (Boolean)this.writeOperationsExecuteStatus.getValue();
        }
    }

    protected void handleGpioProfileServiceAnalogInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleGpioProfileServiceInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    public Object handleMethodAntennaConfiguration(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                return this.handleSetAntennaConfiguration(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodDataWriteExtensions(int code, Measurement measurement, Object data) {
        return null;
    }

    public Object handleMethodTagAggregationWriteMaskSetting(int code, Measurement measurement, Object data) {
        this.log(4, "handleMethodTagAggregationWriteMaskSetting: " + data);
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagAggregationWriteMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagWriteAggregating(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagWriteAggregatingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagWriteAggregating, TagWriteAggregatingExpression has been applied.");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidWriteProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagWriteAggregatingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagWriteAggregatingExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagWriteMaskSetting(int code, Measurement measurement, Object data) {
        this.log(4, "handleMethodTagWriteMaskSetting: " + data);
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagWriteMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperations(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetWriteOperations(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperationsExecuteRequest(int code, Command command, Object data) {
        if (this.writeOperationLdapFilter != null) {
            throw new IllegalArgumentException("handleMethodWriteOperationsExecuteRequest, WriteOperationsExpression has been applied.");
        }
        this.executeWriteOperations();
        return null;
    }

    public Object handleMethodWriteOperationsExecuteStatus(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                throw new IllegalArgumentException("WriteOperationsExecuteStatus: read-only measurement." + data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperationsExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetWriteOperationExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperationsStopRequest(int code, Command command, Object data) {
        if (this.writeOperationLdapFilter != null) {
            throw new IllegalArgumentException("handleMethodWriteOperationsStopRequest, WriteOperationsExpression has been applied.");
        }
        this.handleWriteOperationsStopRequest();
        return null;
    }

    protected Object handleSetAntennaConfiguration(Measurement measurement, Object data) {
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("handleSetAntennaConfiguration: " + data);
        }
        measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
        return null;
    }

    protected void handleSetTagAggregationWriteMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.aggregationInterest = RfidWriteProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagAggregationMaskSetting: " + data);
    }

    protected void handleSetTagWriteAggregatingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setTagWriteAggregatingLdapFilter(aggFilter);
                    measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagWriteAggregatingLdapFilter(null);
                measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleTagAggregatingExpression: " + data);
    }

    protected void handleSetTagWriteMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.log(4, "Tag Write Mask Setting: " + data);
            this.tagInterest = RfidWriteProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagMaskSetting: " + data);
    }

    protected void handleSetWriteOperationExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter writeOpFilter = this.createLdapFilter((String)data);
                    this.setWriteOperationLdapFilter(writeOpFilter);
                    measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setWriteOperationLdapFilter(null);
                measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetTagReadingExpression: " + data);
    }

    protected Object handleSetWriteOperations(Measurement measurement, Object data) {
        if (data instanceof String) {
            boolean status_executing = this.handleGetWriteOperationsExecuteStatus();
            if (status_executing) {
                throw new IllegalArgumentException("Fail to set the WriteOperations, one execution is in the process.");
            }
        } else {
            throw new IllegalArgumentException("handleSetWriteOperations: " + data);
        }
        measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSetWriteOperationsExecuteStatus(Boolean status) {
        MethodMeasurement methodMeasurement = this.writeOperationsExecuteStatus;
        synchronized (methodMeasurement) {
            boolean currentStatus = (Boolean)this.writeOperationsExecuteStatus.getValue();
            if (currentStatus && status.booleanValue()) {
                throw new IllegalArgumentException("Fail to start the WriteOperations, one execution is in the process.");
            }
            this.writeOperationsExecuteStatus.setValue((Object)status, RfidWriteProfile.getCurrentTimestamp());
        }
    }

    protected void handleTagWriteAggregating(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (oldValue != null) {
            this.applyDataExtensions(this.cachedTags);
            this.applyDataExtensions(this.aggregatedTags);
            if (!newState) {
                this.notifyTagAggregation();
                this.flushAggregatorCache();
            }
        }
    }

    protected void handleWriteOperationsStopRequest() {
        if (!this.isOperationsRunning()) {
            throw new IllegalArgumentException("Fail to stop the WriteOperations, no execution is in the process.");
        }
        this.executeStop();
    }

    private void initialize() {
        this.put((ControlService)this.writeOperationsExecuteRequest);
        this.put((ControlService)this.writeOperationsStopRequest);
        this.put((ControlService)this.antennaConfiguration);
        this.put((ControlService)this.dataWriteExtensions);
        this.put((ControlService)this.tagWriteMaskSetting);
        this.put((ControlService)this.tagAggregationWriteMaskSetting);
        this.put((ControlService)this.tagWriteAggregatingExpression);
        this.put((ControlService)this.tagWriteAggregating);
        this.tagWriteAggregating.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.writeOperations);
        this.put((ControlService)this.writeOperationsExpression);
        this.put((ControlService)this.writeOperationsExecuteStatus);
        this.put((ControlService)this.tagWriteReport);
        this.put((ControlService)this.tagWriteAggregationReport);
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    protected boolean isOperationsRunning() {
        return this.handleGetWriteOperationsExecuteStatus();
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.tagWriteAggregating == source) {
            this.handleTagWriteAggregating(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    protected Map mergeMapOverMap(Map additionalValues, Map existingValues) {
        Object value;
        Object key;
        Iterator i;
        Hashtable newExtensions = new Hashtable(17);
        if (existingValues != null) {
            i = existingValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = existingValues.get(key);
                newExtensions.put(key, value);
            }
        }
        if (additionalValues != null) {
            i = additionalValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = additionalValues.get(key);
                newExtensions.put(key, value);
            }
        }
        return newExtensions;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.gpioProfileServiceInputExternalKey)) {
            this.handleGpioProfileServiceInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.gpioProfileServiceAnalogInputExternalKey)) {
            this.handleGpioProfileServiceAnalogInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void notifyTagAggregation() {
        Map tagMap = this.buildOuterTagMessage(this.aggregatedTags);
        this.triggerTagAggregationReport(tagMap, false);
    }

    public void notifyTagReport(String key, String operationId, Map reads) {
        boolean sendTag = false;
        sendTag = this.applyFiltering(key, reads);
        this.applyAggregating(key, operationId, reads);
        if (sendTag) {
            Hashtable<String, Map> reportData = new Hashtable<String, Map>(7);
            reportData.put(operationId, reads);
            Map tagMap = this.buildTagMessage(key, reportData);
            this.triggerTagReport(tagMap, false);
        } else {
            this.log(4, "Tag " + key + " is not reported.");
        }
    }

    protected void operationsInterrupted(String errorMsg) {
        if (this.isOperationsRunning()) {
            this.handleError(new RuntimeException(errorMsg), 1);
            this.setOperationsStatusFinished();
        }
    }

    protected void setOperationsStatusFinished() {
        this.handleSetWriteOperationsExecuteStatus(Boolean.FALSE);
    }

    protected void setOperationsStatusStarted() {
        this.handleSetWriteOperationsExecuteStatus(Boolean.TRUE);
    }

    protected void setTagWriteAggregatingLdapFilter(Filter tagAggregatingLdapFilter) {
        this.tagWriteAggregatingLdapFilter = tagAggregatingLdapFilter;
        this.evaluateTagAggregatingLdapFilter();
    }

    protected void setWriteOperationLdapFilter(Filter writeOperationLdapFilter) {
        this.writeOperationLdapFilter = writeOperationLdapFilter;
        this.evaluateWriteOperationLdapFilter();
    }

    public void setupNotification() {
        String gpioProfilePrefix = this.getGpioProfilePrefix();
        this.gpioProfileServiceInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input");
        this.gpioProfileServiceInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input/get");
        this.gpioProfileServiceAnalogInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput");
        this.gpioProfileServiceAnalogInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput/get");
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs/get");
        this.register(new String[]{this.gpioProfileServiceInputExternalKey, this.gpioProfileServiceAnalogInputExternalKey, this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey});
        super.setupNotification();
        this.broadcast(this.gpioProfileServiceInputGetExternalKey, new Hashtable());
        this.broadcast(this.gpioProfileServiceAnalogInputGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
    }

    protected abstract void startOperations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMapInLdap(Dictionary data) {
        Dictionary dictionary = this.ldapMap;
        synchronized (dictionary) {
            Map values = (Map)data.get("value");
            if (values == null) {
                return;
            }
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = values.get(key);
                this.ldapMap.put(key, value);
            }
            this.applyLdap();
        }
    }

    private void triggerTagAggregationReport(Map tagMap, boolean withError) {
        if (withError) {
            this.tagWriteAggregationReport.fireErrorOccurred(RfidWriteProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagWriteAggregationReport.trigger((Object)tagMap);
        }
    }

    private void triggerTagReport(Map tagMap, boolean withError) {
        if (withError || !this.isOperationsRunning()) {
            this.tagWriteReport.fireErrorOccurred(RfidWriteProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagWriteReport.trigger((Object)tagMap);
        }
    }

    protected void updateTagInCache(String key, String operationId, Map reads, Map cache) {
        Hashtable<String, Map> reportData = (Hashtable<String, Map>)cache.get(key);
        if (reportData == null) {
            reportData = new Hashtable<String, Map>(7);
            cache.put(key, reportData);
        }
        reportData.put(operationId, reads);
    }
}

