/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm;

import java.io.IOException;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import org.eclipse.soda.dk.comm.DeviceList;
import org.eclipse.soda.dk.comm.DeviceListEntry;
import org.eclipse.soda.dk.comm.NSParallelPort;
import org.eclipse.soda.dk.comm.NSSerialPort;
import org.eclipse.soda.dk.comm.internal.Library;

public class NSCommDriver
implements CommDriver {
    DeviceList devicelist = new DeviceList();

    static {
        try {
            Library.load_dkcomm();
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("2. unsatisfied link error.\n");
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void addDeviceToList(String portName, int portType, String deviceName, int semID) {
        DeviceListEntry cur = this.devicelist.headEntry;
        DeviceListEntry prev = null;
        while (cur != null) {
            prev = cur;
            cur = cur.next;
        }
        cur = new DeviceListEntry();
        cur.logicalName = portName;
        cur.physicalName = deviceName;
        cur.portType = portType;
        cur.semID = semID;
        cur.next = null;
        if (prev == null) {
            this.devicelist.headEntry = cur;
        } else {
            prev.next = cur;
        }
    }

    private native void discoverDevicesNC();

    public CommPort getCommPort(String portName, int portType) {
        CommPort port = null;
        try {
            switch (portType) {
                case 1: {
                    port = new NSSerialPort(portName, this);
                    break;
                }
                case 2: {
                    port = new NSParallelPort(portName, this);
                }
            }
        }
        catch (IOException ex) {
            System.out.println("IOException occured! " + ex);
            ex.printStackTrace();
            port = null;
        }
        return port;
    }

    DeviceListEntry getFirstDLE() {
        return this.devicelist.headEntry;
    }

    DeviceListEntry getNextDLE(DeviceListEntry dle) {
        DeviceListEntry cur = this.devicelist.headEntry;
        DeviceListEntry ndle = null;
        while (cur != null) {
            if (cur == dle) {
                ndle = cur.next;
                break;
            }
            cur = cur.next;
        }
        return ndle;
    }

    public void initialize() {
        this.discoverDevicesNC();
        DeviceListEntry cur = this.getFirstDLE();
        while (cur != null) {
            CommPortIdentifier.addPortName(cur.logicalName, cur.portType, this);
            cur = this.getNextDLE(cur);
        }
    }
}

