/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.factory;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.factory.CoreFactory;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class TransportFactory
extends CoreFactory
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        ConnectionService connection = this.isFactoryConnection(properties) ? (ConnectionService)manager.getImportedService(this.getInterestServiceName()) : null;
        TransportService transport = this.createService(connection);
        if (transport != null) {
            transport.setConfigurationInformation(properties);
            try {
                transport.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, new Hashtable(), properties, manager), (Object)transport, (Dictionary)serviceProperties);
        }
        return transport;
    }

    public abstract TransportService createService(ConnectionService var1);

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            TransportService transport = (TransportService)object;
            transport.exit();
            int count = 0;
            while (count < 20 && transport.getState() != 0) {
                Thread.sleep(100L);
                ++count;
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        super.destroy(pid, object, properties, manager);
    }

    public String[] getExportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        return new String[]{TransportService.SERVICE_NAME};
    }

    public String getInterestServiceName() {
        return "org.eclipse.soda.dk.connection.service.ConnectionService";
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return OPTIONAL_SERVICES;
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof TransportService) {
            TransportService transport = (TransportService)object;
            if (importedService instanceof NotificationService) {
                transport.setNotificationService((NotificationService)importedService);
            }
        }
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof TransportService) {
            TransportService transport = (TransportService)object;
            transport.setNotificationService(null);
        }
    }

    public boolean isFactoryConnection(Dictionary properties) {
        Object value = properties.get("connection");
        return "factory".equals(value);
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        try {
            TransportService transport = (TransportService)object;
            manager.removeExportedService(TransportService.SERVICE_NAME, object);
            transport.exit();
        }
        catch (Exception e) {
            EscObject.handleStaticException((Throwable)e);
        }
        return this.create(pid, properties, manager);
    }
}

