/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.io.IOException;
import org.eclipse.soda.dk.connection.TraceConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.transport.ThreadTransport;
import org.eclipse.soda.dk.transport.service.ConnectionTransportService;

public abstract class ConnectionTransport
extends ThreadTransport
implements ConnectionTransportService {
    private ConnectionService connection;

    protected ConnectionTransport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            try {
                ConnectionService connection = this.getConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.handleError(exception, 2017);
            }
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws Exception {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            ConnectionService connection = this.getConnection();
            if (!connection.isOpen()) {
                connection.open();
            }
            super.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            super.exit();
            this.setConnection(null);
        }
    }

    public ConnectionService getConnection() {
        return this.connection;
    }

    public abstract ConnectionService getDefaultConnection();

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.getConnection().read(buffer, offset, length);
    }

    public void setConnection(ConnectionService connection) throws IllegalArgumentException {
        if (ConnectionTransport.getTraceLevel() >= 7 && !(connection instanceof TraceConnection) && connection != null) {
            this.connection = new TraceConnection(connection);
            return;
        }
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            super.setup();
            if (this.getConnection() == null) {
                this.setConnection(this.getDefaultConnection());
            }
        }
    }

    public void write(byte[] sendBytes) throws Exception {
        this.getConnection().write(sendBytes, 0, sendBytes.length);
    }
}

