/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.ControllerQueue;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.osgi.service.log.LogService;

public class Controller
extends ControllerQueue
implements ControllerService,
Runnable {
    private static final long serialVersionUID = -8946351256395220870L;
    public static final Integer TRANSPORT_STARTED_VALUE = EscObject.createInteger((int)5);
    public static final Integer TRANSPORT_STARTED_NO_OUTPUT = EscObject.createInteger((int)-5);
    private Thread thread;
    private boolean running = false;
    private Transport transport;
    private final Object messageReceived = new Object();
    private int queueSizeProblem = 2048;

    public Controller(Transport transport, int priority) {
        this.transport = transport;
        this.thread = new Thread((Runnable)this, transport.getOutputName());
        this.thread.setDaemon(true);
        this.thread.setPriority(priority);
    }

    protected void enqueueRestartTransport() {
        this.enqueue(EscObject.getCurrentTimestamp(), TRANSPORT_STARTED_VALUE, null);
    }

    protected void enqueueRestartTransportNoOutput() {
        this.enqueue(EscObject.getCurrentTimestamp(), TRANSPORT_STARTED_NO_OUTPUT, null);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        this.enqueue(timestamp, source, data);
    }

    public void errorOccurredSend(Object source, Object timestamp, Object data) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.errorOccurred((Object)this, timestamp, data);
            }
            catch (Exception exception) {
                this.transport.handleError(exception, 2022);
            }
        }
    }

    public int getQueueSizeProblem() {
        return this.queueSizeProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        block12: {
            try {
                Object object = this.messageReceived;
                synchronized (object) {
                    this.messageReceived.notify();
                }
                if (this.transport.getState() < 5) {
                    this.transport.startupMessageReceived(this.transport, timestamp, message);
                    if (EscObject.getTraceLevel() >= 5) {
                        this.transport.report(null, 2025, message);
                    }
                } else if (this.transport.getTransportListener() != null) {
                    if (this.transport.getInterestMask().isInterested(message)) {
                        this.enqueue(timestamp, message, null);
                    } else if (EscObject.getTraceLevel() >= 5) {
                        this.transport.report(null, 2026, message);
                    }
                }
            }
            catch (Exception exception) {
                if (!EscObject.shouldLog((int)1)) break block12;
                this.transport.handleError(exception, 2019);
            }
        }
    }

    public void restartTransport() {
        int count = this.size();
        if (count > 0) {
            int index = 0;
            while (index < count) {
                Object[] object = this.getFirst();
                if (object != null && (object[1] instanceof Boolean || object[1] instanceof Integer)) {
                    return;
                }
                ++index;
            }
        }
        this.enqueueRestartTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int messageStatus = 0;
        while (this.running) {
            block40: {
                block41: {
                    int count = this.size();
                    if (count != 0) break block40;
                    int inputMessageCount = this.transport.getInputMessageCount();
                    try {
                        Controller controller = this;
                        synchronized (controller) {
                            this.wait(this.transport.getNoActivityTimeout());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (!this.running) {
                        return;
                    }
                    count = this.size();
                    if (count != 0 || !this.running) break block40;
                    int inputMessageCountNew = this.transport.getInputMessageCount();
                    if (inputMessageCountNew != inputMessageCount) break block41;
                    int status = this.transport.noActivityProcessing();
                    switch (status) {
                        case 0: {
                            if (messageStatus != 2) {
                                this.transport.report(null, 2037, Long.toString(this.transport.getNoActivityTimeout()));
                                messageStatus = 2;
                                if (this.transport.getState() == 5) {
                                    this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                    break;
                                }
                            }
                            break block40;
                        }
                        case 1: {
                            if (inputMessageCountNew == inputMessageCount) {
                                Object object = this.messageReceived;
                                synchronized (object) {
                                    try {
                                        this.messageReceived.wait(this.transport.getRetryTime());
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            messageStatus = 2;
                            inputMessageCountNew = this.transport.getInputMessageCount();
                            if (inputMessageCountNew == inputMessageCount) {
                                this.restartTransport();
                                break;
                            }
                            if (this.transport.getState() == 5) {
                                this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                break;
                            }
                            break block40;
                        }
                        case 2: {
                            messageStatus = 2;
                            this.restartTransport();
                        }
                    }
                    break block40;
                }
                messageStatus = 1;
            }
            int index = 0;
            while (index < this.size()) {
                TransportListener listener;
                Object[] objects = this.getFirst();
                Object timestamp = objects[0];
                Object object = objects[1];
                Object extendedData = objects[2];
                if (object instanceof MessageService) {
                    MessageService message = (MessageService)objects[1];
                    if (timestamp == null) {
                        this.transport.send(message);
                    } else {
                        TransportListener listener2 = this.transport.getTransportListener();
                        messageStatus = 1;
                        if (listener2 != null) {
                            listener2.messageReceived((TransportService)this.transport, objects[0], message);
                            if (EscObject.getTraceLevel() >= 5) {
                                this.transport.report(null, 2023, message);
                            }
                        }
                    }
                } else if (object instanceof String) {
                    LogService logService = this.transport.getLogService();
                    logService.log(4, object.toString());
                } else if (object instanceof Boolean) {
                    boolean output = (Boolean)object;
                    this.startProcessing(output);
                } else if (object instanceof Integer) {
                    int data0 = (Integer)object;
                    if (extendedData == null) {
                        boolean output = data0 >= 0;
                        this.dequeueFirst();
                        object = null;
                        this.transport.restartProcessing(output);
                    } else {
                        int data1 = (Integer)extendedData;
                        this.transportChangedSend(this.transport, timestamp, data0, data1);
                    }
                } else if (object instanceof TransportService && (listener = this.transport.getTransportListener()) != null) {
                    this.errorOccurredSend(object, timestamp, extendedData);
                }
                if (object != null) {
                    this.dequeueFirst();
                }
                ++index;
            }
        }
    }

    public void setQueueSizeProblem(int queueSizeProblem) {
        this.queueSizeProblem = queueSizeProblem;
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    public void start(boolean output) {
        if (output) {
            this.enqueue(EscObject.getCurrentTimestamp(), Boolean.TRUE, null);
        } else {
            this.enqueue(EscObject.getCurrentTimestamp(), Boolean.FALSE, null);
        }
    }

    /*
     * Exception decompiling
     */
    public void startProcessing(boolean output) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(10000L);
            }
            catch (Exception exception) {}
            this.thread = null;
        }
    }

    public void stop(boolean output) {
    }

    public void trace(String debugMessage) {
        this.enqueue(EscObject.getCurrentTimestamp(), debugMessage, null);
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        if (Thread.currentThread() == this.thread) {
            this.transportChangedSend(transportService, timestamp, newState, oldState);
        } else {
            this.enqueue(timestamp, EscObject.createInteger((int)newState), EscObject.createInteger((int)oldState));
        }
    }

    public void transportChangedSend(TransportService source, Object timestamp, int newState, int oldState) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.transportChanged(source, timestamp, newState, oldState);
            }
            catch (Exception exception) {
                this.transport.handleError(exception, 2018);
            }
        }
        if (newState == 0) {
            this.stop();
        }
    }
}

