/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

public class ControllerQueue {
    protected Object[][] elements;
    int length;
    private int size = 0;
    protected int maxQueueSize = 0;
    private int head = 0;
    private int tail = 0;

    public ControllerQueue() {
        this(64);
    }

    public ControllerQueue(int size) {
        this.elements = new Object[size][3];
        this.length = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(long time, Object[] object) {
        ControllerQueue controllerQueue;
        if (this.size == 0) {
            controllerQueue = this;
            synchronized (controllerQueue) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    object[0] = null;
                    object[1] = null;
                    object[2] = null;
                    return;
                }
            }
        }
        controllerQueue = this;
        synchronized (controllerQueue) {
            if (this.size > 0) {
                object[0] = this.elements[this.head][0];
                object[1] = this.elements[this.head][1];
                object[2] = this.elements[this.head][2];
                this.elements[this.head][0] = null;
                this.elements[this.head][1] = null;
                this.elements[this.head][2] = null;
                ++this.head;
                if (this.head >= this.length) {
                    this.head -= this.length;
                }
                --this.size;
                return;
            }
        }
        object[0] = null;
        object[1] = null;
        object[2] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeueFirst() {
        ControllerQueue controllerQueue = this;
        synchronized (controllerQueue) {
            if (this.size > 0) {
                this.elements[this.head][0] = null;
                this.elements[this.head][1] = null;
                this.elements[this.head][2] = null;
                ++this.head;
                if (this.head >= this.length) {
                    this.head -= this.length;
                }
                --this.size;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object timestamp, Object data, Object extendedData) {
        try {
            ControllerQueue controllerQueue = this;
            synchronized (controllerQueue) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1;
                    this.elements[this.head][0] = timestamp;
                    this.elements[this.head][1] = data;
                    this.elements[this.head][2] = extendedData;
                } else {
                    int high;
                    if (this.size >= this.length) {
                        this.handleFull();
                    }
                    if ((high = this.tail - 1) < 0) {
                        high = this.length + high;
                    }
                    this.elements[this.tail][0] = timestamp;
                    this.elements[this.tail][1] = data;
                    this.elements[this.tail][2] = extendedData;
                    ++this.tail;
                    if (this.tail >= this.length) {
                        this.tail -= this.length;
                    }
                }
                ++this.size;
                if (this.size > this.maxQueueSize) {
                    this.maxQueueSize = this.size;
                }
                this.notify();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.toString());
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getFirst() {
        ControllerQueue controllerQueue = this;
        synchronized (controllerQueue) {
            if (this.size > 0) {
                return this.elements[this.head];
            }
        }
        return null;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getMaxSize() {
        return this.length;
    }

    public synchronized void handleFull() {
        Object[][] newElements = new Object[this.size << 1][3];
        if (this.head == 0) {
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
        } else {
            int delta = this.size - this.head;
            System.arraycopy(this.elements, this.head, newElements, 0, delta);
            System.arraycopy(this.elements, 0, newElements, delta, this.size - delta);
            this.head = 0;
        }
        this.tail = this.size;
        this.elements = newElements;
        this.length = this.elements.length;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('{');
        boolean first = true;
        int count = 0;
        while (count < this.size) {
            Object topic;
            int i = this.head + count;
            if (i >= this.length) {
                i -= this.length;
            }
            if ((topic = this.elements[i][0]) != null) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                buffer.append('[');
                buffer.append(topic);
                buffer.append(',');
                Object data = this.elements[i][1];
                buffer.append(data);
                buffer.append(',');
                Object extendedData = this.elements[i][2];
                buffer.append(extendedData);
                buffer.append(']');
            } else {
                buffer.append(", NULL");
            }
            ++count;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

