/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;

public class HistoryQueue {
    protected Object[][] elements;
    int length;
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    public HistoryQueue() {
        this(8);
    }

    public HistoryQueue(int size) {
        this.elements = new Object[size][2];
        this.length = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object dequeue(long time) {
        HistoryQueue historyQueue;
        if (this.size == 0) {
            historyQueue = this;
            synchronized (historyQueue) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        historyQueue = this;
        synchronized (historyQueue) {
            if (this.size <= 0) {
                return null;
            }
            Object info = this.elements[this.head][1];
            this.elements[this.head][0] = null;
            this.elements[this.head][1] = null;
            ++this.head;
            if (this.head >= this.length) {
                this.head -= this.length;
            }
            --this.size;
            return info;
        }
    }

    public void enqueue(Object data) {
        this.enqueue(EscObject.getCurrentTimestamp(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object timestamp, Object data) {
        try {
            HistoryQueue historyQueue = this;
            synchronized (historyQueue) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1;
                    this.elements[this.head][0] = timestamp;
                    this.elements[this.head][1] = data;
                } else {
                    int high = this.tail - 1;
                    if (high < 0) {
                        high = this.length + high;
                    }
                    this.elements[this.tail][0] = timestamp;
                    this.elements[this.tail][1] = data;
                    ++this.tail;
                    if (this.tail >= this.length) {
                        this.tail -= this.length;
                    }
                }
                if (this.size < this.elements.length) {
                    ++this.size;
                }
                this.notify();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.toString());
            System.exit(0);
        }
    }

    public int getMaxSize() {
        return this.length;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('{');
        boolean first = true;
        long startTime = 0L;
        long lastTime = 0L;
        int count = 1;
        while (count <= this.size) {
            int i = this.tail - count;
            if (i >= this.length) {
                i -= this.length;
            } else if (i < 0) {
                i += this.length;
            }
            Object timestampObject = this.elements[i][0];
            long timestamp = 0L;
            if (timestampObject instanceof Number) {
                timestamp = ((Number)timestampObject).longValue();
            }
            if (first) {
                startTime = timestamp;
                buffer.append(startTime);
                buffer.append('=');
            } else {
                long delta;
                buffer.append(',');
                if (lastTime != timestamp && (delta = timestamp - startTime) != 0L) {
                    buffer.append("\r\n\t");
                    buffer.append(delta);
                    buffer.append('=');
                }
            }
            lastTime = timestamp;
            first = false;
            Object data = this.elements[i][1];
            buffer.append(data);
            ++count;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

