/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.customer;

import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.BaseManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.customer.Customer;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.hotdog.VendorService;
import org.eclipse.soda.sat.core.junit.internal.cm.AbstractManagedServiceFactoryActivatorDelegate;
import org.osgi.service.cm.ConfigurationException;

public class CustomerManagedServiceFactory
extends AbstractManagedServiceFactoryActivatorDelegate {
    public CustomerManagedServiceFactory(String pid, String location) {
        super(pid, location);
    }

    private Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        String id = this.getId(properties);
        Customer customer = new Customer(id);
        int spiciness = this.getSpiciness(properties);
        customer.setSpiciness(spiciness);
        VendorService vendor = (VendorService)manager.getImportedService(VendorService.SERVICE_NAME);
        customer.setVendor(vendor);
        customer.eat();
        this.addObjectWithId(id, customer);
        return customer;
    }

    protected IManagedServiceFactoryAdvisor createAdvisor() {
        return new BaseManagedServiceFactoryAdvisor(){

            public Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
                return CustomerManagedServiceFactory.this.create(pid, properties, manager);
            }

            public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
                CustomerManagedServiceFactory.this.createImportedServiceFilters(pid, oldProperties, properties, manager);
            }

            public void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
                CustomerManagedServiceFactory.this.destroy(pid, object, properties, manager);
            }

            public String[] getImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
                return CustomerManagedServiceFactory.this.getImportedServiceNames(pid, oldProperties, properties, manager);
            }

            public Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
                return CustomerManagedServiceFactory.this.update(pid, object, oldProperties, properties, manager);
            }

            public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
                CustomerManagedServiceFactory.this.validateConfiguration(pid, properties);
            }
        };
    }

    private void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        int spiciness = this.getSpiciness(properties);
        String filter = "(spiciness=" + spiciness + ')';
        manager.addImportedServiceFilter(VendorService.SERVICE_NAME, filter);
    }

    private void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        Customer customer = (Customer)object;
        customer.setVendor(null);
        String id = customer.getId();
        this.removeObjectWithId(id);
    }

    private String[] getImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        return new String[]{VendorService.SERVICE_NAME};
    }

    private int getSpiciness(Dictionary properties) {
        Integer wrapper = (Integer)properties.get("spiciness");
        int spiciness = wrapper;
        return spiciness;
    }

    private Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        Customer customer = (Customer)object;
        int spiciness = this.getSpiciness(properties);
        customer.setSpiciness(spiciness);
        this.updated(customer);
        return customer;
    }

    private void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
    }
}

