/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.container.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.record.container.interfaces.IExportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.osgi.framework.BundleContext;

public class ExportServiceRecordContainerTestCase
extends AbstractServiceTestCase {
    private IExportServiceRecordContainer container;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static Test suite() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ExportServiceRecordContainerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ExportServiceRecordContainerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.container = AbstractSatTestCase.FACTORY.createExportServiceRecordContainer();
    }

    protected void tearDown() throws Exception {
        this.container = null;
        super.tearDown();
    }

    public void test_add() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        boolean added = this.container.add(record);
        Assert.assertTrue((boolean)added);
        int expectedSize = 1;
        int actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.register();
        boolean registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        service = new TestServiceImplementation();
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        added = this.container.add(record);
        Assert.assertTrue((boolean)added);
        expectedSize = 2;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        this.container.unregister();
    }

    public void test_Constructor() {
        Assert.assertNotNull((Object)this.container);
        boolean empty = this.container.isEmpty();
        Assert.assertTrue((boolean)empty);
        int expectedSize = 0;
        int actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_contains() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        IExportServiceRecord record = null;
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        Assert.assertNotNull(record);
        boolean exists = this.container.contains(record);
        Assert.assertTrue((boolean)exists);
        boolean removed = this.container.remove(record);
        Assert.assertTrue((boolean)removed);
        exists = this.container.contains((IServiceRecord)record);
        Assert.assertFalse((boolean)exists);
    }

    public void test_doForEach() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        IServiceRecordAction action = new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                List list = (List)parameter;
                list.add(record);
                return true;
            }
        };
        ArrayList list = new ArrayList(3);
        this.container.doForEach(action, list);
        int expectedSize = count;
        int actualSize = list.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_empty() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        this.container.empty();
        boolean empty = this.container.isEmpty();
        Assert.assertTrue((boolean)empty);
    }

    public void test_get() {
        BundleContext context = this.getBundleContext();
        String[] names1 = new String[]{TestService1.SERVICE_NAME};
        String[] names2 = new String[]{TestService2.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        IExportServiceRecord record1 = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names1, (Object)service, null);
        this.container.add(record1);
        service = new TestServiceImplementation();
        IExportServiceRecord record2 = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names2, (Object)service, null);
        this.container.add(record2);
        IExportServiceRecord expected = record1;
        IServiceRecord actual = this.container.get(TestService1.SERVICE_NAME);
        Assert.assertSame((Object)expected, (Object)actual);
        expected = record2;
        actual = this.container.get(TestService2.SERVICE_NAME);
        Assert.assertSame((Object)expected, (Object)actual);
        service = new TestServiceImplementation();
        IExportServiceRecord record3 = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names1, (Object)service, null);
        this.container.add(record3);
        expected = record3;
        actual = this.container.get(TestService1.SERVICE_NAME, (Object)service);
        Assert.assertSame((Object)expected, (Object)actual);
        expected = null;
        actual = this.container.get(TestService3.SERVICE_NAME);
        Assert.assertSame((Object)expected, (Object)actual);
        service = new TestServiceImplementation();
        expected = null;
        actual = this.container.get(TestService1.SERVICE_NAME, (Object)service);
        Assert.assertSame((Object)expected, (Object)actual);
        try {
            actual = this.container.get(TestService1.SERVICE_NAME, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_getAll() {
        IExportServiceRecord record;
        BundleContext context = this.getBundleContext();
        String[] names1 = new String[]{TestService1.SERVICE_NAME};
        String[] names2 = new String[]{TestService2.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names1, (Object)service, null);
            this.container.add(record);
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names2, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names1, (Object)service, null);
        this.container.add(record);
        IServiceRecord[] objects = this.container.getAll();
        int expectedLength = count * 2 + 1;
        int actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        objects = this.container.getAll(TestService1.SERVICE_NAME);
        expectedLength = count + 1;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        objects = this.container.getAll(TestService2.SERVICE_NAME);
        expectedLength = count;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        objects = this.container.getAll(TestService3.SERVICE_NAME);
        expectedLength = 0;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        this.container.empty();
        objects = this.container.getAll(TestService1.SERVICE_NAME);
        expectedLength = 0;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
    }

    public void test_isEmpty() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        boolean empty = this.container.isEmpty();
        Assert.assertTrue((boolean)empty);
        int i = 0;
        while (i < count) {
            IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        empty = this.container.isEmpty();
        Assert.assertFalse((boolean)empty);
    }

    public void test_isRegistered() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        boolean registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        TestServiceImplementation service = new TestServiceImplementation();
        IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        this.container.add(record);
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        this.container.register();
        registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        service = new TestServiceImplementation();
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        this.container.add(record);
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        boolean removed = this.container.remove(record);
        Assert.assertTrue((boolean)removed);
        int expectedSize = 1;
        int actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        record = (IExportServiceRecord)this.container.get(TestService1.SERVICE_NAME);
        record.unregister();
        registered = record.isRegistered();
        Assert.assertFalse((boolean)registered);
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        removed = this.container.remove(record);
        Assert.assertTrue((boolean)removed);
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
    }

    public void test_register() {
        IExportServiceRecord record;
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        this.container.register();
        boolean registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        IServiceRecord[] objects = this.container.getAll();
        i = 0;
        while (i < count) {
            record = (IExportServiceRecord)objects[i];
            registered = record.isRegistered();
            Assert.assertTrue((boolean)registered);
            ++i;
        }
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        this.container.add(record);
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        record.register();
        registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        record.unregister();
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        this.container.remove(record);
        registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        record.register();
        this.container.add(record);
        registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        this.container.unregister();
    }

    public void test_remove() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        this.container.add(record);
        int expectedSize = 1;
        int actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        boolean removed = this.container.remove(record);
        Assert.assertTrue((boolean)removed);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.register();
        service = new TestServiceImplementation();
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        this.container.add(record);
        expectedSize = 1;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        removed = this.container.remove(record);
        Assert.assertTrue((boolean)removed);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.unregister();
    }

    public void test_removeAll() {
        IExportServiceRecord record;
        BundleContext context = this.getBundleContext();
        String[] names1 = new String[]{TestService1.SERVICE_NAME};
        String[] names2 = new String[]{TestService2.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names1, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        int expectedSize = count;
        int actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService1.SERVICE_NAME);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names1, (Object)service, null);
            this.container.add(record);
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names2, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        expectedSize = count * 2;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService1.SERVICE_NAME);
        expectedSize = count;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService3.SERVICE_NAME);
        expectedSize = count;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService2.SERVICE_NAME);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
    }

    public void test_size() {
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int expectedSize = 0;
        int actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        int i = 0;
        while (i < count) {
            IExportServiceRecord record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        expectedSize = count;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_unregister() {
        IExportServiceRecord record;
        BundleContext context = this.getBundleContext();
        String[] names = new String[]{TestService1.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
            this.container.add(record);
            ++i;
        }
        this.container.register();
        boolean registered = this.container.isRegistered();
        Assert.assertTrue((boolean)registered);
        this.container.unregister();
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        IServiceRecord[] objects = this.container.getAll();
        i = 0;
        while (i < count) {
            record = (IExportServiceRecord)objects[i];
            registered = record.isRegistered();
            Assert.assertFalse((boolean)registered);
            ++i;
        }
        this.container.register();
        record = AbstractSatTestCase.FACTORY.createExportServiceRecord(context, names, (Object)service, null);
        this.container.add(record);
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        this.container.unregister();
        registered = this.container.isRegistered();
        Assert.assertFalse((boolean)registered);
        objects = this.container.getAll();
        i = 0;
        while (i < count) {
            record = (IExportServiceRecord)objects[i];
            registered = record.isRegistered();
            Assert.assertFalse((boolean)registered);
            ++i;
        }
    }

    private static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ExportServiceRecordContainerTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ExportServiceRecordContainerTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService3 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ExportServiceRecordContainerTestCase$TestService3");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static class TestServiceImplementation
    implements TestService1,
    TestService2 {
        private TestServiceImplementation() {
        }
    }
}

