/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.junit.internal;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.bundle.Activator;
import org.osgi.framework.Bundle;

public class BundleConfigurationTestCase
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.junit.internal.BundleConfigurationTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BundleConfigurationTestCase(String name) {
        super(name);
    }

    public void test() {
        String frameworkVendor = Activator.BUNDLE_CONTEXT.getProperty("org.osgi.framework.vendor");
        boolean isEclipse = "Eclipse".equals(frameworkVendor);
        if (!isEclipse) {
            return;
        }
        Bundle[] bundles = Activator.BUNDLE_CONTEXT.getBundles();
        int expectedSize = 8;
        int actualSize = bundles.length;
        BundleConfigurationTestCase.assertEquals((int)expectedSize, (int)actualSize);
        ArrayList<String> actualSymbolicNames = new ArrayList<String>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            String symbolicName = bundle.getSymbolicName();
            actualSymbolicNames.add(symbolicName);
            ++i;
        }
        String[] expectedSymbolicNames = new String[]{"org.eclipse.osgi", "org.eclipse.soda.sat.core.junit", "org.eclipse.osgi.services", "org.eclipse.soda.sat.junit", "org.eclipse.equinox.cm", "org.junit", "javax.servlet", "org.eclipse.soda.sat.core"};
        int i2 = 0;
        while (i2 < expectedSymbolicNames.length) {
            String expectedSymbolicName = expectedSymbolicNames[i2];
            boolean exists = actualSymbolicNames.contains(expectedSymbolicName);
            BundleConfigurationTestCase.assertTrue((String)expectedSymbolicName, (boolean)exists);
            ++i2;
        }
    }
}

