/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.junit.internal.cm;

import java.io.IOException;
import java.util.Dictionary;
import junit.framework.Assert;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.junit.internal.cm.ConfigurationAdminConfigurator;
import org.eclipse.soda.sat.core.junit.internal.cm.IManagedServiceFactoryActivatorDelegate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class AbstractManagedServiceFactoryActivationManagerTestCase
extends AbstractServiceTestCase {
    private ConfigurationAdminConfigurator configurator;

    protected AbstractManagedServiceFactoryActivationManagerTestCase(String name) {
        super(name);
    }

    protected final Configuration createConfiguration(IManagedServiceFactoryActivatorDelegate factory, Object id, Dictionary properties) throws IOException, InterruptedException {
        ConfigurationAdminConfigurator configurator = this.getConfigurator();
        Configuration configuration = configurator.create(factory, id, properties);
        Object service = factory.getObjectWithId(id);
        Assert.assertNotNull((Object)service);
        return configuration;
    }

    private ConfigurationAdminConfigurator createConfigurationAdminConfigurator() {
        ConfigurationAdmin admin = this.getConfigurationAdmin();
        ConfigurationAdminConfigurator configurator = new ConfigurationAdminConfigurator(admin);
        return configurator;
    }

    protected final ConfigurationAdminConfigurator getConfigurator() {
        return this.configurator;
    }

    protected final String getLocation() {
        BundleContext context = this.getBundleContext();
        Bundle bundle = context.getBundle();
        String location = bundle.getLocation();
        return location;
    }

    private void setConfigurator(ConfigurationAdminConfigurator configurator) {
        this.configurator = configurator;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ConfigurationAdminConfigurator configurator = this.createConfigurationAdminConfigurator();
        this.setConfigurator(configurator);
    }

    protected void tearDown() throws Exception {
        this.setConfigurator(null);
        super.tearDown();
    }
}

