/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.osgi.framework.Bundle;

public class BundleManifestUtilityTestCase
extends AbstractServiceTestCase {
    private static final BundleManifestUtility UTILITY = BundleManifestUtility.getInstance();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.BundleManifestUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BundleManifestUtilityTestCase(String name) {
        super(name);
    }

    public void test_getBundleActivator() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.junit.internal.bundle.Activator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String expected = clazz.getName();
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleActivator(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleCategory() {
        String expected = "Unit Test";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleCategory(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleClasspath() {
        String expected = ".";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleClasspath(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleContactAddress() {
        String expected = "license@eclipse.org";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleContactAddress(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleCopyright() {
        String expected = "Copyright (c) 2001, 2007 IBM Corporation and others.";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleCopyright(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleDescription() {
        String expected = "Unit tests for org.eclipse.soda.sat.core";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleDescription(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleDocUrl() {
        String expected = "www.eclipse.org";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleDocUrl(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleLocalization() {
        String expected = "bundle";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleLocalization(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleManifestVersion() {
        String expected = "2";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleManifestVersion(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleName() {
        String expected = "SAT Core JUnit Tests (Incubation)";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleName(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleNativeCode() {
        Object expected = null;
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleNativeCode(bundle);
        Assert.assertEquals(expected, (Object)actual);
    }

    public void test_getBundleRequiredExecutionEnvironments() {
        String[] expected = new String[]{"OSGi/Minimum-1.1"};
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getBundleRequiredExecutionEnvironments(bundle);
        Assert.assertEquals((int)expected.length, (int)actual.length);
    }

    public void test_getBundleSymbolicName() {
        String expected = "org.eclipse.soda.sat.core.junit";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleSymbolicName(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleUpdateLocation() {
        String expected = ".";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleUpdateLocation(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleVendor() {
        String expected = "Eclipse.org";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleVendor(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleVersion() {
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleVersion(bundle);
        Assert.assertNotNull((Object)actual);
    }

    public void test_getDynamicImportPackage() {
        Object[] expectedPackages = EMPTY_OBJECT_ARRAY;
        Bundle bundle = this.getBundle();
        String[] actualPackages = UTILITY.getDynamicImportPackages(bundle);
        int expected = expectedPackages.length;
        int actual = actualPackages.length;
        Assert.assertEquals((int)expected, (int)actual);
    }

    public void test_getExportPackage() {
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getImportPackages(bundle);
        Assert.assertTrue((actual.length != 0 ? 1 : 0) != 0);
    }

    public void test_getFragmentHost() {
        Bundle bundle = this.getBundle();
        Object expected = null;
        String actual = UTILITY.getFragmentHost(bundle);
        Assert.assertSame(expected, (Object)actual);
    }

    public void test_getImportPackage() {
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getImportPackages(bundle);
        Assert.assertTrue((actual.length != 0 ? 1 : 0) != 0);
    }

    public void test_getInstance() {
        Assert.assertNotNull((Object)UTILITY);
        BundleManifestUtility instance = BundleManifestUtility.getInstance();
        BundleManifestUtility expected = UTILITY;
        BundleManifestUtility actual = instance;
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void test_getRequiredBundles() {
        Object[] expected = EMPTY_OBJECT_ARRAY;
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getRequireBundles(bundle);
        Assert.assertEquals((int)expected.length, (int)actual.length);
    }

    public void test_getUnlocalizedHeader() {
        String expected = "%bundle.name";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getUnlocalizedHeader(bundle, "Bundle-Name");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

