/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ProxyServiceHandlerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class ManagedServiceFactoryBundleActivator
extends BaseBundleActivator
implements ManagedServiceFactory {
    private static final String CHECK_METADATA_EXISTS_PROPERTY = "org.eclipse.soda.sat.core.framework.check.metadata.exists";
    private static final String CREATE_MANAGED_SERVICE_FACTORY_PROXY_PROPERTY = "org.eclipse.soda.sat.core.framework.create.msf.proxy";
    private static final String DEFAULT_CHECK_METADATA_EXISTS = Boolean.FALSE.toString();
    private static final String DEFAULT_CREATE_MANAGED_SERVICE_FACTORY_PROXY = Boolean.FALSE.toString();
    private static final boolean CHECK_METADATA_EXISTS = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.check.metadata.exists", DEFAULT_CHECK_METADATA_EXISTS));
    private static final boolean CREATE_MANAGED_SERVICE_FACTORY_PROXY = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.create.msf.proxy", DEFAULT_CREATE_MANAGED_SERVICE_FACTORY_PROXY));
    private static final String FAILED_TO_FIND_METADATA_RESOURCE_KEY = "ManagedServiceFactoryBundleActivator.FailedToFindMetaDataResource";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    protected static final String CONFIGURATION_ADMIN_SERVICE_NAME;
    protected static final String MANAGED_SERVICE_FACTORY_SERVICE_NAME;
    protected static final int NUMBER_OF_CONFIGURATIONS_HINT = 5;
    private IManagedServiceFactoryActivationManager managedServiceFactoryActivationManager;
    private String pid;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONFIGURATION_ADMIN_SERVICE_NAME = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MANAGED_SERVICE_FACTORY_SERVICE_NAME = clazz2.getName();
    }

    protected void activate() {
        this.registerManagedServiceFactory();
    }

    private void addExportedManagedServiceFactoryProxyService() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> interfaceType = clazz;
        ProxyServiceHandlerAdapter handler = new ProxyServiceHandlerAdapter(){

            public Object createService() {
                return ManagedServiceFactoryBundleActivator.this.createManagedServiceFactory();
            }
        };
        Dictionary properties = this.createManagedServiceFactoryProperties();
        this.addExportedProxyService(interfaceType, handler, properties);
    }

    private void checkMetaDataResourceExists() {
        if (!CHECK_METADATA_EXISTS) {
            return;
        }
        Bundle bundle = this.getBundle();
        URL url = bundle.getResource("META-INF/METADATA.XML");
        if (url != null) {
            return;
        }
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String source = bundle.getSymbolicName();
        String warning = Messages.getString(FAILED_TO_FIND_METADATA_RESOURCE_KEY);
        utility.warn(component, source, warning, null, null);
    }

    protected void collectImportedServiceNames(Set serviceNames) {
        super.collectImportedServiceNames(serviceNames);
        serviceNames.add(CONFIGURATION_ADMIN_SERVICE_NAME);
    }

    protected abstract IManagedServiceFactoryAdvisor createAdvisor();

    protected final String createDefaultPid() {
        Class<?> clazz = this.getClass();
        String name = clazz.getName();
        return name;
    }

    private ManagedServiceFactory createManagedServiceFactory() {
        this.checkMetaDataResourceExists();
        this.startManagedServiceFactoryActivationManager();
        ManagedServiceFactory service = this.getManagedServiceFactory();
        return service;
    }

    private IManagedServiceFactoryActivationManager createManagedServiceFactoryActivationManager() {
        String name = this.getName();
        IManagedServiceFactoryAdvisor advisor = this.createAdvisor();
        FactoryUtility utility = FactoryUtility.getInstance();
        int hint = 5;
        IManagedServiceFactoryActivationManager manager = utility.createManagedServiceFactoryActivationManager(name, advisor, hint);
        return manager;
    }

    private Dictionary createManagedServiceFactoryProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        String pid = this.getPid();
        ((Dictionary)properties).put("service.pid", pid);
        return properties;
    }

    protected String createPid() {
        String pid = this.createDefaultPid();
        return pid;
    }

    protected void deactivate() {
        this.stopManagedServiceFactoryActivationManager();
    }

    public final void deleted(String pid) {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.deleted(pid);
    }

    private ManagedServiceFactory getManagedServiceFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedServiceFactoryActivationManager getManagedServiceFactoryActivationManager() {
        ManagedServiceFactoryBundleActivator managedServiceFactoryBundleActivator = this;
        synchronized (managedServiceFactoryBundleActivator) {
            if (this.managedServiceFactoryActivationManager == null) {
                IManagedServiceFactoryActivationManager manager = this.createManagedServiceFactoryActivationManager();
                this.setManagedServiceFactoryActivationManager(manager);
            }
            return this.managedServiceFactoryActivationManager;
        }
    }

    public String getName() {
        String name = this.getPid();
        return name;
    }

    protected int getNumberOfConfigurationsHint() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPid() {
        ManagedServiceFactoryBundleActivator managedServiceFactoryBundleActivator = this;
        synchronized (managedServiceFactoryBundleActivator) {
            if (this.pid == null) {
                String pid = this.createPid();
                this.setPid(pid);
            }
            return this.pid;
        }
    }

    protected boolean isProxyService() {
        return CREATE_MANAGED_SERVICE_FACTORY_PROXY;
    }

    private void registerManagedServiceFactory() {
        boolean proxy = this.isProxyService();
        if (proxy) {
            this.addExportedManagedServiceFactoryProxyService();
        } else {
            ManagedServiceFactory service = this.createManagedServiceFactory();
            Dictionary properties = this.createManagedServiceFactoryProperties();
            this.addExportedService(MANAGED_SERVICE_FACTORY_SERVICE_NAME, service, properties);
        }
    }

    private void setManagedServiceFactoryActivationManager(IManagedServiceFactoryActivationManager managedServiceFactoryActivationManager) {
        this.managedServiceFactoryActivationManager = managedServiceFactoryActivationManager;
    }

    private void setPid(String pid) {
        this.pid = pid;
    }

    private void startManagedServiceFactoryActivationManager() {
        BundleContext context = this.getBundleContext();
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.start(context);
    }

    private void stopManagedServiceFactoryActivationManager() {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.stop();
        this.setManagedServiceFactoryActivationManager(null);
    }

    public final void updated(String pid, Dictionary properties) throws ConfigurationException {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.updated(pid, properties);
    }
}

