/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.Assert;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

class BundleManager {
    private static final String UNKNOWN_BUNDLE_CONTEXT_KEY = "Common.UnknownBundleContext";
    private static final String UNKNOWN_BUNDLE_EVENT_KEY = "BundleManager.UnknownBundleEvent";
    private BundleContext bundleContext;
    private BundleListener bundleListener;
    private boolean started;
    private final Object lock = new Object();

    protected BundleManager() {
        this.setBundleListener(this.createBundleListener());
        this.setStarted(false);
    }

    private void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        switch (type) {
            case 1: {
                this.handleBundleInstalled(bundle);
                break;
            }
            case 2: {
                this.handleBundleStarted(bundle);
                break;
            }
            case 4: {
                this.handleBundleStopped(bundle);
                break;
            }
            case 8: {
                this.handleBundleUpdated(bundle);
                break;
            }
            case 16: {
                this.handleBundleUninstalled(bundle);
                break;
            }
            case 32: {
                this.handleBundleResolved(bundle);
                break;
            }
            case 64: {
                this.handleBundleUnresolved(bundle);
                break;
            }
            case 128: {
                this.handleBundleStarting(bundle);
                break;
            }
            case 256: {
                this.handleBundleStopping(bundle);
                break;
            }
            default: {
                this.handleUnknownBundleEvent(event);
            }
        }
    }

    private void checkShutdownIsAllowed(BundleContext bundleContext) {
        BundleContext bc = this.getBundleContext();
        if (bundleContext.equals(bc)) {
            return;
        }
        String message = Messages.getString(UNKNOWN_BUNDLE_CONTEXT_KEY);
        throw new IllegalArgumentException(message);
    }

    private BundleListener createBundleListener() {
        return new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                BundleManager.this.bundleChanged(event);
            }
        };
    }

    protected final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private BundleListener getBundleListener() {
        return this.bundleListener;
    }

    private Object getLock() {
        return this.lock;
    }

    protected void handleBundleInstalled(Bundle bundle) {
    }

    protected void handleBundleResolved(Bundle bundle) {
    }

    protected void handleBundleStarted(Bundle bundle) {
    }

    protected void handleBundleStarting(Bundle bundle) {
    }

    protected void handleBundleStopped(Bundle bundle) {
    }

    protected void handleBundleStopping(Bundle bundle) {
    }

    protected void handleBundleUninstalled(Bundle bundle) {
    }

    protected void handleBundleUnresolved(Bundle bundle) {
    }

    protected void handleBundleUpdated(Bundle bundle) {
    }

    protected void handleManagerShutdown() {
    }

    protected void handleManagerStarted() {
    }

    protected void handleUnknownBundleEvent(BundleEvent event) {
        this.logUnknownBundleEvent(event);
    }

    private void hookupBundleListener() {
        BundleContext bundleContext = this.getBundleContext();
        BundleListener listener = this.getBundleListener();
        bundleContext.addBundleListener(listener);
    }

    public final boolean isStarted() {
        return this.started;
    }

    protected final void logUnknownBundleEvent(BundleEvent event) {
        String pattern = Messages.getString(UNKNOWN_BUNDLE_EVENT_KEY);
        Object[] values = new Object[2];
        Class<?> clazz = this.getClass();
        String name = clazz.getName();
        values[0] = name;
        values[1] = event;
        String message = MessageFormatter.format(pattern, values);
        LogUtility.logError(message);
    }

    private void setBundleContext(BundleContext bundleContext) {
        if (this.bundleContext != null) {
            this.unhookBundleListener();
        }
        this.bundleContext = bundleContext;
        if (this.bundleContext != null) {
            this.hookupBundleListener();
        }
    }

    private void setBundleListener(BundleListener bundleListener) {
        this.bundleListener = bundleListener;
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(BundleContext bundleContext) {
        Object lock;
        Assert.checkArgumentIsNotNull(bundleContext, "bundleContext");
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.checkShutdownIsAllowed(bundleContext);
            this.setStarted(false);
            this.handleManagerShutdown();
            this.setBundleContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startup(BundleContext bundleContext) {
        Object lock;
        Assert.checkArgumentIsNotNull(bundleContext, "bundleContext");
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setStarted(true);
            this.setBundleContext(bundleContext);
            this.handleManagerStarted();
        }
    }

    private void unhookBundleListener() {
        BundleContext bundleContext = this.getBundleContext();
        BundleListener listener = this.getBundleListener();
        bundleContext.removeBundleListener(listener);
    }
}

