/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.record.BundleProxyClassLoader;
import org.eclipse.soda.sat.core.internal.record.ServiceRecordDelegate;
import org.eclipse.soda.sat.core.internal.util.Assert;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ExportProxyServiceRecord
extends ServiceRecordDelegate
implements IExportProxyServiceRecord {
    private static final String UNRECOGNIZED_INVOCATION_HANDLER_KEY = "ExportProxyServiceRecord.UnrecognizedInvocationHandler";
    private static final String EQUALS_METHOD = "equals";
    private BundleContext bundleContext;
    private IProxyServiceHandler handler;
    private Object realService;

    public static Object unwrapProxy(Object serviceProxy) throws IllegalArgumentException {
        Assert.checkArgumentIsNotNull(serviceProxy, "serviceProxy");
        InvocationHandler handler = Proxy.getInvocationHandler(serviceProxy);
        boolean valid = handler instanceof ExportedServiceInvocationHandler;
        if (!valid) {
            String pattern = UNRECOGNIZED_INVOCATION_HANDLER_KEY;
            String message = MessageFormatter.format(pattern, handler);
            throw new IllegalArgumentException(message);
        }
        ExportedServiceInvocationHandler exportedServiceInvocationHandler = (ExportedServiceInvocationHandler)handler;
        Object realService = exportedServiceInvocationHandler.getRealService();
        return realService;
    }

    public ExportProxyServiceRecord(BundleContext bundleContext, Class[] interfaceTypes, IProxyServiceHandler handler, Dictionary properties) {
        this.setBundleContext(bundleContext);
        this.setHandler(handler);
        IExportServiceRecord record = this.createExportServiceRecord(bundleContext, interfaceTypes, properties);
        this.setServiceRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object basicGetRealService() {
        ExportProxyServiceRecord exportProxyServiceRecord = this;
        synchronized (exportProxyServiceRecord) {
            return this.realService;
        }
    }

    private ClassLoader createClassLoader() {
        Bundle bundle = this.getBundle();
        BundleProxyClassLoader classLoader = new BundleProxyClassLoader(bundle);
        return classLoader;
    }

    private IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, Class[] interfaceTypes, Dictionary properties) {
        String[] names = this.getServiceInterfaceNames(interfaceTypes);
        Object service = this.createProxyService(interfaceTypes);
        IExportServiceRecord record = this.createExportServiceRecord(bundleContext, names, service, properties);
        return record;
    }

    private IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, String[] names, Object service, Dictionary properties) {
        FactoryUtility utility = FactoryUtility.getInstance();
        IExportServiceRecord record = utility.createExportServiceRecord(bundleContext, names, service, properties);
        return record;
    }

    private Object createProxyService(Class[] interfaceTypes) {
        Assert.checkArgumentIsNotNull(interfaceTypes, "interfaceTypes");
        ClassLoader loader = this.createClassLoader();
        ExportedServiceInvocationHandler handler = new ExportedServiceInvocationHandler();
        Object service = Proxy.newProxyInstance(loader, interfaceTypes, (InvocationHandler)handler);
        return service;
    }

    private Object createRealService() {
        IProxyServiceHandler handler = this.getHandler();
        Object service = handler.createService();
        return service;
    }

    protected int createToStringBufferSize() {
        return super.createToStringBufferSize() + 100;
    }

    private Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        return bundle;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private IExportServiceRecord getExportServiceRecord() {
        IServiceRecord record = this.getServiceRecord();
        IExportServiceRecord exportServiceRecord = (IExportServiceRecord)record;
        return exportServiceRecord;
    }

    private IProxyServiceHandler getHandler() {
        return this.handler;
    }

    public String[] getNames() {
        IExportServiceRecord record = this.getExportServiceRecord();
        String[] names = record.getNames();
        return names;
    }

    public Dictionary getProperties() {
        IExportServiceRecord record = this.getExportServiceRecord();
        Dictionary properties = record.getProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRealService() {
        ExportProxyServiceRecord exportProxyServiceRecord = this;
        synchronized (exportProxyServiceRecord) {
            Object service = this.basicGetRealService();
            if (service == null) {
                service = this.createRealService();
                this.setRealService(service);
            }
            return this.realService;
        }
    }

    private String[] getServiceInterfaceNames(Class[] interfaceTypes) {
        Assert.checkArgumentIsNotNull(interfaceTypes, "interfaceTypes");
        int count = interfaceTypes.length;
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            String name;
            Class interfaceType = interfaceTypes[i];
            names[i] = name = interfaceType.getName();
            ++i;
        }
        return names;
    }

    public ServiceReference getServiceReference() {
        IExportServiceRecord record = this.getExportServiceRecord();
        ServiceReference reference = record.getServiceReference();
        return reference;
    }

    private Throwable handleException(Throwable exception) throws Throwable {
        boolean rethrow;
        boolean bl = rethrow = !(exception instanceof InvocationTargetException);
        if (rethrow) {
            String message = exception.getMessage();
            LogUtility.logError(message, exception);
            throw exception;
        }
        InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
        Throwable throwable = invocationTargetException.getTargetException();
        return throwable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invoke(Method method, Object[] args) throws Throwable {
        Object result;
        block7: {
            result = null;
            Throwable throwable = null;
            Object data = this.preInvoke(method, args);
            try {
                try {
                    String name = method.getName();
                    boolean isEqualsMethod = name.equals(EQUALS_METHOD);
                    if (isEqualsMethod) {
                        Object parameter = args[0];
                        result = this.invokeEquals(parameter);
                    }
                    if (result == null) {
                        Object service = this.getRealService();
                        result = method.invoke(service, args);
                    }
                }
                catch (Throwable exception) {
                    throwable = this.handleException(exception);
                }
            }
            catch (Throwable throwable2) {
                Object var9_11 = null;
                this.postInvoke(method, args, throwable, data);
                throw throwable2;
            }
            {
                Object var9_12 = null;
                this.postInvoke(method, args, throwable, data);
                if (throwable == null) break block7;
            }
            throw throwable;
        }
        return result;
    }

    private Object invokeEquals(Object parameter) {
        Object parameterService;
        if (parameter == null) {
            return null;
        }
        try {
            parameterService = ExportProxyServiceRecord.unwrapProxy(parameter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        Object service = this.getRealService();
        boolean equal = service.equals(parameterService);
        Boolean result = equal ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }

    public boolean isProxy() {
        return true;
    }

    public boolean isRegistered() {
        IExportServiceRecord record = this.getExportServiceRecord();
        boolean registered = record.isRegistered();
        return registered;
    }

    public boolean isServiceCreated() {
        Object service = this.basicGetRealService();
        boolean created = service != null;
        return created;
    }

    private void postInvoke(Method method, Object[] args, Throwable throwable, Object data) {
        IProxyServiceHandler handler = this.getHandler();
        Object service = this.getRealService();
        try {
            handler.postInvoke(service, method, args, throwable, data);
        }
        catch (Throwable exception) {
            String message = exception.getMessage();
            LogUtility.logError(message, exception);
        }
    }

    private Object preInvoke(Method method, Object[] args) {
        Object result = null;
        IProxyServiceHandler handler = this.getHandler();
        Object service = this.getRealService();
        try {
            result = handler.preInvoke(service, method, args);
        }
        catch (Throwable exception) {
            String message = exception.getMessage();
            LogUtility.logError(message, exception);
        }
        return result;
    }

    private void printHandlerOn(StringBuffer buffer) {
        IProxyServiceHandler handler = this.getHandler();
        buffer.append(", handler=");
        buffer.append(handler);
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printHandlerOn(buffer);
        this.printServiceOn(buffer);
        this.printRealServiceOn(buffer);
    }

    private void printRealServiceOn(StringBuffer buffer) {
        buffer.append(", realService=");
        boolean created = this.isServiceCreated();
        Object realService = created ? this.getRealService() : null;
        buffer.append(realService);
    }

    private void printServiceOn(StringBuffer buffer) {
        Object service = this.getService();
        buffer.append(", service=");
        this.printOn(buffer, service);
    }

    public void register() {
        IExportServiceRecord record = this.getExportServiceRecord();
        record.register();
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void setHandler(IProxyServiceHandler handler) {
        Assert.checkArgumentIsNotNull(handler, "handler");
        this.handler = handler;
    }

    public void setProperties(Dictionary properties) {
        IExportServiceRecord record = this.getExportServiceRecord();
        record.setProperties(properties);
    }

    private void setRealService(Object realService) {
        this.realService = realService;
    }

    public void unregister() {
        IExportServiceRecord record = this.getExportServiceRecord();
        record.unregister();
    }

    private class ExportedServiceInvocationHandler
    implements InvocationHandler {
        private ExportedServiceInvocationHandler() {
        }

        private Object getRealService() {
            Object service = ExportProxyServiceRecord.this.getRealService();
            return service;
        }

        public Object invoke(Object service, Method method, Object[] args) throws Throwable {
            Object result = ExportProxyServiceRecord.this.invoke(method, args);
            return result;
        }
    }
}

