/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;

public final class Assert {
    private static final String ARGUMENT_MUST_NOT_BE_NULL_KEY = "Assert.ArgumentMustNotBeNull";
    private static final String ARGUMENT_MUST_BE_IN_RANGE_KEY = "Assert.ArgumentMustBeInRange";
    private static final String ARGUMENT_1_MUST_BE_LESS_THAN_OR_EQUAL_TO_ARGUMENT_2_KEY = "Assert.Argument1MustBeLessThanOrEqualToArgument2";

    public static void checkArgumentIsNotNull(Object value, String name) throws IllegalArgumentException {
        Assert.checkIsNotNull(value, ARGUMENT_MUST_NOT_BE_NULL_KEY, name);
    }

    private static void checkIsLessThanOrEqualTo(int value1, String name1, int value2, String name2) throws IllegalArgumentException {
        if (value1 <= value2) {
            return;
        }
        String pattern = ARGUMENT_1_MUST_BE_LESS_THAN_OR_EQUAL_TO_ARGUMENT_2_KEY;
        Object[] values = new Object[]{name1, new Integer(value1), name2, new Integer(value2)};
        String message = MessageFormatter.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    public static void checkIsNotNull(Object value, String messageKey) throws IllegalArgumentException {
        Assert.checkIsNotNull(value, messageKey, null);
    }

    public static void checkIsNotNull(Object value, String messageKey, Object messageParameter) throws IllegalArgumentException {
        if (value != null) {
            return;
        }
        String message = Messages.getString(messageKey);
        if (messageParameter != null) {
            message = MessageFormatter.format(message, messageParameter);
        }
        throw new IllegalArgumentException(message);
    }

    public static void checkRange(int value, String name, int beginRange, int endRange) throws IllegalArgumentException {
        Assert.checkIsLessThanOrEqualTo(beginRange, "beginRange", endRange, "endRange");
        if (value >= beginRange) {
            return;
        }
        if (value <= endRange) {
            return;
        }
        Object[] values = new Object[]{name, new Integer(value), new Integer(beginRange), new Integer(endRange)};
        String pattern = Messages.getString(ARGUMENT_MUST_BE_IN_RANGE_KEY);
        String message = MessageFormatter.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    private Assert() {
    }
}

