/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.interfaces.IDependencyTracker;
import org.eclipse.soda.sat.core.internal.util.Assert;
import org.eclipse.soda.sat.core.internal.util.DependencyTrackerXmlConverter;
import org.eclipse.soda.sat.core.util.MiscUtility;

public class DependencyTracker
implements IDependencyTracker {
    private static final int VALUE_CONTAINER_CAPACITY = 20;
    private static final int MAP_SIZE = 251;
    private Map dependentsMap;
    private Map prerequisitesMap;
    private final Object lock = new Object();

    public DependencyTracker() {
        this(251);
    }

    public DependencyTracker(int size) {
        this(size, size);
    }

    public DependencyTracker(int prerequisites, int dependents) {
        this.setPrerequisitesMap(new HashMap(this.estimateHashedCollectionSize(prerequisites)));
        this.setDependentsMap(new HashMap(this.estimateHashedCollectionSize(dependents)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object dependent, Object prerequisite) {
        Object lock;
        Assert.checkArgumentIsNotNull(dependent, "dependent");
        Assert.checkArgumentIsNotNull(prerequisite, "prerequisite");
        boolean added = false;
        Object object = lock = this.getLock();
        synchronized (object) {
            Collection dependents;
            Collection prerequisites = this.prerequisitesOf(dependent);
            if (!prerequisites.contains(prerequisite)) {
                prerequisites.add(prerequisite);
                added = true;
            }
            if (!(dependents = this.dependentsOf(prerequisite)).contains(dependent)) {
                dependents.add(dependent);
                added = true;
            }
        }
        return added;
    }

    private void addAll(Collection source, Set target) {
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            target.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDependents(Object prerequisite, Collection results) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            Map map = this.getPrerequisitesMap();
            Collection dependents = (Collection)map.get(prerequisite);
            if (dependents == null) {
                return;
            }
            Iterator iterator = dependents.iterator();
            while (iterator.hasNext()) {
                Object dependent = iterator.next();
                if (results.contains(dependent)) continue;
                results.add(dependent);
                this.collectDependents(dependent, results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectPrerequisites(Object dependent, List results) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            Map map = this.getDependentsMap();
            Collection prerequisites = (Collection)map.get(dependent);
            if (prerequisites == null) {
                return;
            }
            Iterator iterator = prerequisites.iterator();
            while (iterator.hasNext()) {
                Object prerequisite = iterator.next();
                if (results.contains(prerequisite)) continue;
                results.add(prerequisite);
                this.collectPrerequisites(prerequisite, results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection dependentsOf(Object prerequisite) {
        ArrayList dependents;
        Object lock;
        Map map = this.getPrerequisitesMap();
        Object object = lock = this.getLock();
        synchronized (object) {
            dependents = (ArrayList)map.get(prerequisite);
            if (dependents == null) {
                dependents = new ArrayList(20);
                map.put(prerequisite, dependents);
            }
        }
        return dependents;
    }

    private int estimateHashedCollectionSize(int capacity) {
        MiscUtility utility = MiscUtility.getInstance();
        int size = utility.estimateHashedCollectionSize(capacity);
        return size;
    }

    public List getAllDependents(Object prerequisite) {
        Assert.checkArgumentIsNotNull(prerequisite, "prerequisite");
        int size = this.getMaxMapSize();
        ArrayList dependents = new ArrayList(size);
        this.collectDependents(prerequisite, dependents);
        return dependents;
    }

    public List getAllPrerequisites(Object dependent) {
        Assert.checkArgumentIsNotNull(dependent, "dependent");
        int size = this.getMaxMapSize();
        ArrayList prerequisites = new ArrayList(size);
        this.collectPrerequisites(dependent, prerequisites);
        return prerequisites;
    }

    public List getDependents() {
        Map map = this.getDependentsMap();
        List result = this.getKeys(map);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependents(Object prerequisite) {
        ArrayList result;
        Object lock;
        Assert.checkArgumentIsNotNull(prerequisite, "prerequisite");
        Object object = lock = this.getLock();
        synchronized (object) {
            Map map = this.getPrerequisitesMap();
            Collection dependents = (Collection)map.get(prerequisite);
            if (dependents == null) {
                result = new ArrayList(0);
            } else {
                int size = dependents.size();
                result = new ArrayList(size);
                result.addAll(dependents);
            }
        }
        return result;
    }

    private Map getDependentsMap() {
        return this.dependentsMap;
    }

    private List getKeys(Map map) {
        int size = map.size();
        ArrayList result = new ArrayList(size);
        Set keys = map.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            result.add(key);
        }
        return result;
    }

    private Object getLock() {
        return this.lock;
    }

    private int getMaxMapSize() {
        Map dependentsMap = this.getDependentsMap();
        int dependentsMapSize = dependentsMap.size();
        Map prerequisitesMap = this.getPrerequisitesMap();
        int prerequisitesMapSize = prerequisitesMap.size();
        int maxSize = Math.max(dependentsMapSize, prerequisitesMapSize);
        return maxSize;
    }

    public List getPrerequisites() {
        Map map = this.getPrerequisitesMap();
        List result = this.getKeys(map);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPrerequisites(Object dependent) {
        ArrayList result;
        Object lock;
        Assert.checkArgumentIsNotNull(dependent, "dependent");
        Object object = lock = this.getLock();
        synchronized (object) {
            Map map = this.getDependentsMap();
            Collection prerequisites = (Collection)map.get(dependent);
            if (prerequisites == null) {
                result = new ArrayList(0);
            } else {
                int size = prerequisites.size();
                result = new ArrayList(size);
                result.addAll(prerequisites);
            }
        }
        return result;
    }

    private Map getPrerequisitesMap() {
        return this.prerequisitesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getValues() {
        HashSet set;
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            Map prerequisitesMap = this.getPrerequisitesMap();
            int prerequisitesMapSize = prerequisitesMap.size();
            Map dependentsMap = this.getDependentsMap();
            int dependentsMapSize = dependentsMap.size();
            int size = prerequisitesMapSize + dependentsMapSize;
            set = new HashSet(size * 3);
            Set keys = prerequisitesMap.keySet();
            this.addAll(keys, set);
            keys = dependentsMap.keySet();
            this.addAll(keys, set);
        }
        int size = set.size();
        ArrayList list = new ArrayList(size);
        list.addAll(set);
        return list;
    }

    public boolean hasCircularReferences(Object entry) {
        Assert.checkArgumentIsNotNull(entry, "entry");
        int size = this.getMaxMapSize();
        ArrayList references = new ArrayList(size);
        this.collectDependents(entry, references);
        boolean result = references.contains(entry);
        return result;
    }

    public boolean hasDependents() {
        Map map = this.getDependentsMap();
        boolean result = !map.isEmpty();
        return result;
    }

    public boolean hasPrerequisites() {
        Map map = this.getPrerequisitesMap();
        boolean result = !map.isEmpty();
        return result;
    }

    public boolean isEmpty() {
        Map prerequisitesMap = this.getPrerequisitesMap();
        Map dependentsMap = this.getDependentsMap();
        boolean result = prerequisitesMap.isEmpty() && dependentsMap.isEmpty();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection prerequisitesOf(Object dependent) {
        ArrayList prerequisites;
        Object lock;
        Map map = this.getDependentsMap();
        Object object = lock = this.getLock();
        synchronized (object) {
            prerequisites = (ArrayList)map.get(dependent);
            if (prerequisites == null) {
                prerequisites = new ArrayList(20);
                map.put(dependent, prerequisites);
            }
        }
        return prerequisites;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream stream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entry) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.removePrerequisite(entry);
            this.removeDependent(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object dependent, Object prerequisite) {
        Object lock;
        Assert.checkArgumentIsNotNull(dependent, "dependent");
        Assert.checkArgumentIsNotNull(prerequisite, "prerequisite");
        Object object = null;
        boolean removed = false;
        Object object2 = lock = this.getLock();
        synchronized (object2) {
            Collection dependents;
            Collection prerequisites = this.prerequisitesOf(dependent);
            removed = prerequisites.remove(prerequisite);
            if (prerequisites.isEmpty()) {
                Map map = this.getDependentsMap();
                object = map.remove(dependent);
                removed = object != null || removed;
            }
            boolean bl = removed = (dependents = this.dependentsOf(prerequisite)).remove(dependent) || removed;
            if (dependents.isEmpty()) {
                Map map = this.getPrerequisitesMap();
                object = map.remove(dependent);
                removed = object != null || removed;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object lock;
        Map prerequisitesMap = this.getPrerequisitesMap();
        Map dependentsMap = this.getDependentsMap();
        Object object = lock = this.getLock();
        synchronized (object) {
            prerequisitesMap.clear();
            dependentsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependent(Object entry) {
        Object lock;
        Assert.checkArgumentIsNotNull(entry, "entry");
        Object object = lock = this.getLock();
        synchronized (object) {
            Map dependentsMap = this.getDependentsMap();
            Collection prerequisites = (Collection)dependentsMap.get(entry);
            if (prerequisites == null) {
                return;
            }
            Iterator iterator = prerequisites.iterator();
            Map prerequisitesMap = this.getPrerequisitesMap();
            while (iterator.hasNext()) {
                Object prerequisite = iterator.next();
                Collection dependents = (Collection)prerequisitesMap.get(prerequisite);
                if (dependents == null) continue;
                dependents.remove(entry);
                boolean empty = dependents.isEmpty();
                if (!empty) continue;
                prerequisitesMap.remove(prerequisite);
            }
            dependentsMap.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrerequisite(Object entry) {
        Object lock;
        Assert.checkArgumentIsNotNull(entry, "entry");
        Object object = lock = this.getLock();
        synchronized (object) {
            Map prerequisitesMap = this.getPrerequisitesMap();
            Collection dependents = (Collection)prerequisitesMap.get(entry);
            if (dependents == null) {
                return;
            }
            Iterator iterator = dependents.iterator();
            Map dependentsMap = this.getDependentsMap();
            while (iterator.hasNext()) {
                Object dependent = iterator.next();
                Collection prerequisites = (Collection)dependentsMap.get(dependent);
                if (prerequisites == null) continue;
                prerequisites.remove(entry);
                boolean empty = prerequisites.isEmpty();
                if (!empty) continue;
                dependentsMap.remove(dependent);
            }
            prerequisitesMap.remove(entry);
        }
    }

    public List removeWithAllPrerequisites(Object entry) {
        List prerequisites = this.removeWithPrerequisites(entry, true);
        return prerequisites;
    }

    public List removeWithPrerequisites(Object entry) {
        List prerequisites = this.removeWithPrerequisites(entry, false);
        return prerequisites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List removeWithPrerequisites(Object entry, boolean removeAll) {
        Object lock;
        Assert.checkArgumentIsNotNull(entry, "entry");
        int size = this.getMaxMapSize();
        ArrayList results = new ArrayList(size);
        Object object = lock = this.getLock();
        synchronized (object) {
            this.removePrerequisite(entry);
            this.removeWithPrerequisites(entry, results, removeAll);
        }
        return results;
    }

    private void removeWithPrerequisites(Object dependent, Collection prerequisites, boolean removeAll) {
        Map map = this.getDependentsMap();
        ArrayList prerequisitesOfDependent = (ArrayList)map.get(dependent);
        if (prerequisitesOfDependent == null) {
            return;
        }
        Collection clone = (Collection)prerequisitesOfDependent.clone();
        Iterator iterator = clone.iterator();
        while (iterator.hasNext()) {
            Object prerequisite = iterator.next();
            this.removeWithPrerequisites(prerequisite, dependent, prerequisites, removeAll);
        }
        map.remove(dependent);
    }

    private void removeWithPrerequisites(Object prerequisite, Object dependent, Collection prerequisites, boolean removeAll) {
        Map prerequisitesMap = this.getPrerequisitesMap();
        Collection dependentsOfPrerequisite = (Collection)prerequisitesMap.get(prerequisite);
        if (dependentsOfPrerequisite == null) {
            return;
        }
        dependentsOfPrerequisite.remove(dependent);
        if (!dependentsOfPrerequisite.isEmpty()) {
            return;
        }
        prerequisitesMap.remove(prerequisite);
        if (prerequisites.contains(prerequisite)) {
            return;
        }
        prerequisites.add(prerequisite);
        if (!removeAll) {
            return;
        }
        this.removeWithPrerequisites(prerequisite, prerequisites, removeAll);
    }

    private void setDependentsMap(Map dependentsMap) {
        this.dependentsMap = dependentsMap;
    }

    private void setPrerequisitesMap(Map prerequisitesMap) {
        this.prerequisitesMap = prerequisitesMap;
    }

    public int size() {
        List values = this.getValues();
        int size = values.size();
        return size;
    }

    public String toXml(String name) {
        String xml = this.toXml(name, 0);
        return xml;
    }

    public String toXml(String name, IDependencyTracker.IXmlProvider xmlProvider) {
        String xml = this.toXml(name, 0, xmlProvider);
        return xml;
    }

    public String toXml(String name, int indent) {
        DependencyTrackerXmlConverter xmlConverter = new DependencyTrackerXmlConverter(this, name);
        String xml = xmlConverter.toXml(indent);
        return xml;
    }

    public String toXml(String name, int indent, IDependencyTracker.IXmlProvider xmlProvider) {
        DependencyTrackerXmlConverter xmlConverter = new DependencyTrackerXmlConverter(this, name, xmlProvider);
        String xml = xmlConverter.toXml(indent);
        return xml;
    }
}

