/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.internal.util.Assert;

public class LineWriter
implements ILineWriter {
    private BufferedWriter bufferedWriter;

    public LineWriter(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public LineWriter(OutputStream outputStream, int size) {
        this.setBufferWriter(this.createBufferedWriter(outputStream, size));
    }

    public void close() throws IOException {
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        bufferedWriter.close();
    }

    private BufferedWriter createBufferedWriter(OutputStream outputStream, int size) {
        Assert.checkArgumentIsNotNull(outputStream, "outputStream");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, size);
        return bufferedWriter;
    }

    public void flush() throws IOException {
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        bufferedWriter.flush();
    }

    private BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public void newLine() throws IOException {
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        bufferedWriter.newLine();
    }

    private void setBufferWriter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public void write(String line) throws IOException {
        Assert.checkArgumentIsNotNull(line, "line");
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        int length = line.length();
        bufferedWriter.write(line, 0, length);
    }

    public void writeLine(String line) throws IOException {
        this.write(line);
        this.newLine();
    }
}

