/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.Assert;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public final class BundleUtility {
    private static final String ACTIVE_STATE_KEY = "BundleUtility.ActiveState";
    private static final String INSTALLED_STATE_KEY = "BundleUtility.InstalledState";
    private static final String RESOLVED_STATE_KEY = "BundleUtility.ResolvedState";
    private static final String STARTING_STATE_KEY = "BundleUtility.StartingState";
    private static final String STOPPING_STATE_KEY = "BundleUtility.StoppingState";
    private static final String UNINSTALLED_STATE_KEY = "BundleUtility.UninstalledState";
    private static final String UNKNOWN_STATE_KEY = "Common.Unknown";
    private static final BundleUtility INSTANCE = new BundleUtility();

    public static BundleUtility getInstance() {
        return INSTANCE;
    }

    private BundleUtility() {
    }

    public ServiceReference getServiceInstanceOf(Bundle bundle, String name) {
        Assert.checkArgumentIsNotNull(bundle, "bundle");
        ServiceReference[] services = bundle.getRegisteredServices();
        if (services == null) {
            return null;
        }
        int size = services.length;
        boolean match = false;
        int index = 0;
        ServiceReference service = null;
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        while (!match && index < size) {
            service = services[index];
            match = utility.isServiceInstanceOf(service, name);
            ++index;
        }
        return match ? service : null;
    }

    private boolean includesServiceReference(ServiceReference[] services, ServiceReference serviceReference) {
        boolean match = false;
        if (services == null) {
            return match;
        }
        int size = services.length;
        int index = 0;
        while (!match && index < size) {
            ServiceReference service = services[index];
            match = service.equals(serviceReference);
            ++index;
        }
        return match;
    }

    public boolean isBundleState(Bundle bundle, int state) {
        int currentState = bundle.getState();
        boolean result = (currentState & state) != 0;
        return result;
    }

    public boolean isRegisteredService(Bundle bundle, ServiceReference serviceReference) {
        ServiceReference[] services = bundle.getRegisteredServices();
        boolean match = this.includesServiceReference(services, serviceReference);
        return match;
    }

    public boolean isRegisteredService(Bundle bundle, String name) {
        ServiceReference service = this.getServiceInstanceOf(bundle, name);
        boolean result = service != null;
        return result;
    }

    public boolean isServiceInUse(Bundle bundle, ServiceReference serviceReference) {
        ServiceReference[] services = bundle.getServicesInUse();
        boolean match = this.includesServiceReference(services, serviceReference);
        return match;
    }

    public String toBundleStateString(Bundle bundle) {
        String key;
        int state = bundle.getState();
        switch (state) {
            case 1: {
                key = UNINSTALLED_STATE_KEY;
                break;
            }
            case 2: {
                key = INSTALLED_STATE_KEY;
                break;
            }
            case 4: {
                key = RESOLVED_STATE_KEY;
                break;
            }
            case 8: {
                key = STARTING_STATE_KEY;
                break;
            }
            case 16: {
                key = STOPPING_STATE_KEY;
                break;
            }
            case 32: {
                key = ACTIVE_STATE_KEY;
                break;
            }
            default: {
                key = UNKNOWN_STATE_KEY;
            }
        }
        String value = Messages.getString(key);
        return value;
    }
}

