/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IDependencyTracker;
import org.eclipse.soda.sat.core.framework.interfaces.IFileLog;
import org.eclipse.soda.sat.core.framework.interfaces.ILineReader;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceAdvisor;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleActivationManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.ManagedServiceActivationManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.ManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.internal.record.ExportProxyServiceRecord;
import org.eclipse.soda.sat.core.internal.record.ExportServiceRecord;
import org.eclipse.soda.sat.core.internal.record.ImportServiceRecord;
import org.eclipse.soda.sat.core.internal.record.ServiceDetecter;
import org.eclipse.soda.sat.core.internal.record.container.ExportServiceRecordContainer;
import org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer;
import org.eclipse.soda.sat.core.internal.util.Assert;
import org.eclipse.soda.sat.core.internal.util.DependencyTracker;
import org.eclipse.soda.sat.core.internal.util.FileLog;
import org.eclipse.soda.sat.core.internal.util.LineReader;
import org.eclipse.soda.sat.core.internal.util.LineWriter;
import org.eclipse.soda.sat.core.internal.util.Queue;
import org.eclipse.soda.sat.core.internal.util.Tokenizer;
import org.eclipse.soda.sat.core.record.container.interfaces.IExportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

public final class FactoryUtility {
    private static final FactoryUtility INSTANCE = new FactoryUtility();

    public static FactoryUtility getInstance() {
        return INSTANCE;
    }

    private FactoryUtility() {
    }

    public IBundleActivationManager createBundleActivationManager() {
        BundleActivationManager manager = new BundleActivationManager();
        return manager;
    }

    public IDependencyTracker createDependencyTracker(int prerequisites, int dependents) {
        DependencyTracker tracker = new DependencyTracker(prerequisites, dependents);
        return tracker;
    }

    public IExportProxyServiceRecord createExportProxyServiceRecord(BundleContext bundleContext, Class interfaceType, IProxyServiceHandler handler, Dictionary properties) {
        Assert.checkArgumentIsNotNull(interfaceType, "interfaceType");
        Class[] interfaceTypes = new Class[]{interfaceType};
        IExportProxyServiceRecord record = this.createExportProxyServiceRecord(bundleContext, interfaceTypes, handler, properties);
        return record;
    }

    public IExportProxyServiceRecord createExportProxyServiceRecord(BundleContext bundleContext, Class[] interfaceTypes, IProxyServiceHandler handler, Dictionary properties) {
        ExportProxyServiceRecord record = new ExportProxyServiceRecord(bundleContext, interfaceTypes, handler, properties);
        return record;
    }

    public IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, String name, Object service, Dictionary properties) {
        Assert.checkArgumentIsNotNull(name, "name");
        String[] names = new String[]{name};
        IExportServiceRecord record = this.createExportServiceRecord(bundleContext, names, service, properties);
        return record;
    }

    public IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, String[] names, Object service, Dictionary properties) {
        ExportServiceRecord record = new ExportServiceRecord(bundleContext, names, service, properties);
        return record;
    }

    public IExportServiceRecordContainer createExportServiceRecordContainer() {
        ExportServiceRecordContainer container = new ExportServiceRecordContainer();
        return container;
    }

    public IFileLog createFileLog(File file) {
        FileLog fileLog = new FileLog(file);
        return fileLog;
    }

    public IImportServiceRecord createImportServiceRecord(BundleContext bundleContext, String name, Filter filter) {
        ImportServiceRecord record = new ImportServiceRecord(bundleContext, name, filter);
        return record;
    }

    public IImportServiceRecordContainer createImportServiceRecordContainer() {
        ImportServiceRecordContainer container = new ImportServiceRecordContainer();
        return container;
    }

    public ILineReader createLineReader(InputStream stream) {
        LineReader reader = new LineReader(stream);
        return reader;
    }

    public ILineReader createLineReader(InputStream stream, ILineReader.IAdvisor advisor) {
        LineReader reader = new LineReader(stream, advisor);
        return reader;
    }

    public ILineReader createLineReader(InputStream stream, int size) {
        LineReader reader = new LineReader(stream, size);
        return reader;
    }

    public ILineReader createLineReader(InputStream stream, int size, ILineReader.IAdvisor advisor) {
        LineReader reader = new LineReader(stream, size, advisor);
        return reader;
    }

    public ILineWriter createLineWriter(OutputStream stream) {
        LineWriter writer = new LineWriter(stream);
        return writer;
    }

    public ILineWriter createLineWriter(OutputStream stream, int size) {
        LineWriter writer = new LineWriter(stream, size);
        return writer;
    }

    public IManagedServiceActivationManager createManagedServiceActivationManager(IManagedServiceAdvisor advisor) {
        ManagedServiceActivationManager manager = new ManagedServiceActivationManager(advisor);
        return manager;
    }

    public IManagedServiceFactoryActivationManager createManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor) {
        ManagedServiceFactoryActivationManager manager = new ManagedServiceFactoryActivationManager(name, advisor);
        return manager;
    }

    public IManagedServiceFactoryActivationManager createManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor, int numberOfConfigurationsHint) {
        ManagedServiceFactoryActivationManager manager = new ManagedServiceFactoryActivationManager(name, advisor, numberOfConfigurationsHint);
        return manager;
    }

    public IQueue createQueue(int capacity) {
        Queue queue = new Queue(capacity);
        return queue;
    }

    public IServiceDetecter createServiceDetecter(BundleContext bundleContext, String name) {
        ServiceDetecter composite = new ServiceDetecter(bundleContext, name);
        return composite;
    }

    public ITokenizer createTokenizer(String value) {
        Tokenizer tokenizer = new Tokenizer(value);
        return tokenizer;
    }

    public ITokenizer createTokenizer(String value, char delimiter) {
        Tokenizer tokenizer = new Tokenizer(value, delimiter);
        return tokenizer;
    }

    public ITokenizer createTokenizer(String value, char delimiter, int index) {
        Tokenizer tokenizer = new Tokenizer(value, delimiter, index);
        return tokenizer;
    }

    public ITokenizer createTokenizer(String value, int index) {
        Tokenizer tokenizer = new Tokenizer(value, index);
        return tokenizer;
    }
}

