/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.internal.util.Assert;
import org.osgi.framework.ServiceReference;

public final class ServiceReferenceUtility {
    private static final ServiceReferenceUtility INSTANCE = new ServiceReferenceUtility();

    public static ServiceReferenceUtility getInstance() {
        return INSTANCE;
    }

    private ServiceReferenceUtility() {
    }

    private int getIndexOfHighestServiceRank(int[] ranks) {
        int length = ranks.length;
        if (length == 0) {
            return -1;
        }
        int index = 0;
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < length) {
            int rank = ranks[i];
            if (rank > max) {
                index = i;
                max = rank;
            }
            ++i;
        }
        return index;
    }

    private int getIndexOfLowestServiceId(int[] ranks, long[] ids, int start) {
        int index = start;
        int length = ids.length;
        int rank = ranks[start];
        long min = ids[start];
        int i = start + 1;
        while (i < length) {
            long id;
            if (ranks[i] == rank && (id = ids[i]) < min) {
                index = i;
                min = id;
            }
            ++i;
        }
        return index;
    }

    public long getServiceId(ServiceReference reference) {
        Assert.checkArgumentIsNotNull(reference, "reference");
        Number wrapper = (Number)reference.getProperty("service.id");
        long id = wrapper.intValue();
        return id;
    }

    public long[] getServiceIds(ServiceReference[] references) {
        Assert.checkArgumentIsNotNull(references, "references");
        int length = references.length;
        long[] ids = new long[length];
        int i = 0;
        while (i < length) {
            long id;
            ServiceReference reference = references[i];
            ids[i] = id = this.getServiceId(reference);
            ++i;
        }
        return ids;
    }

    public List getServiceNames(ServiceReference reference) {
        Assert.checkArgumentIsNotNull(reference, "reference");
        String[] names = (String[])reference.getProperty("objectClass");
        ArrayList<String> list = new ArrayList<String>(names.length);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            list.add(name);
            ++i;
        }
        return list;
    }

    public List getServiceNames(ServiceReference[] references) {
        Assert.checkArgumentIsNotNull(references, "references");
        ArrayList list = new ArrayList(references.length * 4);
        int i = 0;
        while (i < references.length) {
            ServiceReference reference = references[i];
            List names = this.getServiceNames(reference);
            list.addAll(names);
            ++i;
        }
        list.trimToSize();
        return list;
    }

    private int[] getServiceRanks(ServiceReference[] references) {
        int length = references.length;
        int[] ranks = new int[length];
        int i = 0;
        while (i < length) {
            int ranking;
            ServiceReference reference = references[i];
            Object value = reference.getProperty("service.ranking");
            if (value instanceof Integer) {
                Number wrapper = (Number)value;
                ranking = wrapper.intValue();
            } else {
                ranking = 0;
            }
            ranks[i] = ranking;
            ++i;
        }
        return ranks;
    }

    public boolean isServiceInstanceOf(ServiceReference reference, String name) {
        Assert.checkArgumentIsNotNull(reference, "reference");
        Assert.checkArgumentIsNotNull(name, "name");
        boolean match = false;
        List serviceNames = this.getServiceNames(reference);
        Iterator iterator = serviceNames.iterator();
        while (!match && iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            match = name.equals(serviceName);
        }
        return match;
    }

    private boolean isServiceRankTied(int[] ranks, int start) {
        boolean tied = false;
        int rank = ranks[start];
        int index = start + 1;
        int length = ranks.length;
        while (!tied && index < length) {
            tied = ranks[index] == rank;
            ++index;
        }
        return tied;
    }

    public ServiceReference select(ServiceReference[] references) {
        Assert.checkArgumentIsNotNull(references, "references");
        int[] ranks = this.getServiceRanks(references);
        int index = this.getIndexOfHighestServiceRank(ranks);
        if (index == -1) {
            return null;
        }
        boolean tied = this.isServiceRankTied(ranks, index);
        if (tied) {
            long[] ids = this.getServiceIds(references);
            index = this.getIndexOfLowestServiceId(ranks, ids, index);
        }
        ServiceReference result = references[index];
        return result;
    }
}

