/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.dependency.internal.nls;

import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.dependency.internal.nls.Messages;

public class MessageFormatter {
    private static final String PLACEHOLDER_CANNOT_BE_FOUND_KEY = "MessageFormatter.PlaceholderCannotBeFound";
    static /* synthetic */ Class class$0;

    public static String format(String pattern, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Object[] values = new Object[]{value};
        String message = MessageFormatter.format(pattern, values);
        return message;
    }

    public static String format(String pattern, Object[] values) {
        int last;
        int first;
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        if (values == null) {
            throw new IllegalArgumentException();
        }
        int length = pattern.length() * 2;
        StringBuffer buffer = new StringBuffer(length);
        int index = 0;
        int copyIndex = 0;
        while ((first = pattern.indexOf(123, index)) != -1 && (last = pattern.indexOf(125, first)) != -1) {
            index = first + 1;
            if (last >= first + 3) continue;
            MessageFormatter.format(pattern, values, buffer, copyIndex, first, last);
            copyIndex = last + 1;
        }
        buffer.append(pattern.substring(copyIndex));
        String message = buffer.toString();
        return message;
    }

    private static void format(String pattern, Object[] values, StringBuffer buffer, int patternIndex, int placeholderBegin, int placeholderEnd) {
        String number = pattern.substring(placeholderBegin + 1, placeholderEnd);
        int valueIndex = Integer.parseInt(number);
        Object chunk = pattern.substring(patternIndex, placeholderBegin);
        buffer.append(chunk);
        if (valueIndex < values.length) {
            chunk = values[valueIndex];
        } else {
            MessageFormatter.logPlaceholderCannotBeFoundError(pattern, valueIndex);
            chunk = pattern.substring(placeholderBegin, placeholderEnd + 1);
        }
        buffer.append(chunk);
    }

    private static void logPlaceholderCannotBeFoundError(String pattern, int index) {
        String errorPattern = Messages.getString(PLACEHOLDER_CANNOT_BE_FOUND_KEY);
        String valueString = Integer.toString(index);
        Object[] values = new Object[]{valueString, pattern};
        String message = MessageFormatter.format(errorPattern, values);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.dependency.internal.nls.MessageFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LogUtility.logError((Object)clazz, (String)message);
    }

    private MessageFormatter() {
    }
}

