/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.dependency.internal.servlet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.dependency.internal.model.interfaces.IBundleDependencyModel;
import org.eclipse.soda.sat.dependency.internal.servlet.BundleDependencyHttpProcessor;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class BundleDependencyServlet
extends HttpServlet {
    private static final String SERVLET_ALIAS_PROPERTY_KEY = "org.eclipse.soda.sat.dependency.servlet.alias";
    private static final String SERVLET_CONTAINER_PATH_KEY = "org.eclipse.soda.sat.dependency.servlet.container.path";
    private static final String DEFAULT_SERVLET_ALIAS_PROPERTY = "/bds";
    private static final String DEFAULT_SERVLET_CONTAINER_PATH_PROPERTY = new String();
    private static final String SERVLET_ALIAS = BundleDependencyServlet.initializeServletAlias();
    private static final String SERVLET_CONTAINER_PATH = BundleDependencyServlet.initializeServletContainerPath();
    private static final String RESOURCE_ALIAS = "/dependency/servlet/html/resource";
    private static final String RESOURCE_PATH = "/org/eclipse/soda/sat/dependency/internal/servlet/html/resource";
    private static final long serialVersionUID = 919428339454657596L;
    private HttpService server;
    private int port;
    private BundleDependencyHttpProcessor processor;

    public static String getResourceAlias() {
        return RESOURCE_ALIAS;
    }

    public static String getResourcePath() {
        return RESOURCE_PATH;
    }

    public static String getServletAlias() {
        return SERVLET_ALIAS;
    }

    public static String getServletContainerPath() {
        return SERVLET_CONTAINER_PATH;
    }

    private static String initializeServletAlias() {
        String servletAlias = System.getProperty(SERVLET_ALIAS_PROPERTY_KEY);
        servletAlias = servletAlias == null ? DEFAULT_SERVLET_ALIAS_PROPERTY : BundleDependencyServlet.validatePath(servletAlias);
        return servletAlias;
    }

    private static String initializeServletContainerPath() {
        String servletContainerPath = System.getProperty(SERVLET_CONTAINER_PATH_KEY);
        servletContainerPath = servletContainerPath == null ? DEFAULT_SERVLET_CONTAINER_PATH_PROPERTY : BundleDependencyServlet.validatePath(servletContainerPath);
        return servletContainerPath;
    }

    private static String validatePath(String servletAlias) {
        int last;
        char forwardSlash = '/';
        StringBuffer buffer = new StringBuffer(servletAlias);
        if (buffer.charAt(0) != forwardSlash) {
            buffer.insert(0, forwardSlash);
        }
        if (buffer.charAt(last = buffer.length() - 1) == forwardSlash) {
            buffer.deleteCharAt(last);
        }
        String value = buffer.toString();
        return value;
    }

    public BundleDependencyServlet() {
        this.setProcessor(new BundleDependencyHttpProcessor());
    }

    public void bind(HttpService server, int port, IBundleDependencyModel model) {
        this.setServer(server);
        this.setPort(port);
        BundleDependencyHttpProcessor processor = this.getProcessor();
        processor.bind(model);
        this.register();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BundleDependencyHttpProcessor processor = this.getProcessor();
        processor.process(request, response);
    }

    private String getHost() {
        String host = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            host = address.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            host = "localhost";
        }
        return host;
    }

    private int getPort() {
        return this.port;
    }

    private BundleDependencyHttpProcessor getProcessor() {
        return this.processor;
    }

    private HttpService getServer() {
        return this.server;
    }

    private void logServletUrl() {
        String host = this.getHost();
        int port = this.getPort();
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("Servlet URL: ");
        buffer.append("http://");
        buffer.append(host);
        buffer.append(':');
        buffer.append(port);
        buffer.append(BundleDependencyServlet.getServletContainerPath());
        buffer.append(BundleDependencyServlet.getServletAlias());
        buffer.append('?');
        buffer.append("action");
        buffer.append('=');
        buffer.append("browse");
        String message = buffer.toString();
        LogUtility.logInfo((Object)((Object)this), (String)message);
    }

    private void logSystemPropertyDetails() {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("Change the servlet alias using the system propertis: ");
        buffer.append('\n');
        buffer.append(' ');
        buffer.append(' ');
        buffer.append("-D");
        buffer.append(SERVLET_CONTAINER_PATH_KEY);
        buffer.append('=');
        buffer.append("<servlet container path>");
        buffer.append('\n');
        buffer.append(' ');
        buffer.append(' ');
        buffer.append("-D");
        buffer.append(SERVLET_ALIAS_PROPERTY_KEY);
        buffer.append('=');
        buffer.append("<servlet alias>");
        String message = buffer.toString();
        LogUtility.logInfo((Object)((Object)this), (String)message);
    }

    private void register() {
        HttpService server = this.getServer();
        try {
            server.registerServlet(BundleDependencyServlet.getServletAlias(), (Servlet)this, null, null);
            server.registerResources(BundleDependencyServlet.getResourceAlias(), BundleDependencyServlet.getResourcePath(), null);
        }
        catch (ServletException exception) {
            exception.printStackTrace();
        }
        catch (NamespaceException exception) {
            exception.printStackTrace();
        }
        this.logServletUrl();
        this.logSystemPropertyDetails();
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setProcessor(BundleDependencyHttpProcessor processor) {
        this.processor = processor;
    }

    private void setServer(HttpService server) {
        this.server = server;
    }

    public void unbind() {
        this.unregister();
        this.setServer(null);
    }

    private void unregister() {
        HttpService server = this.getServer();
        server.unregister(BundleDependencyServlet.getServletAlias());
        server.unregister(BundleDependencyServlet.getResourceAlias());
    }
}

