/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal;

import org.eclipse.osgi.framework.console.CommandProvider;

abstract class AbstractCommandProvider
implements CommandProvider {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char INDENT = '\t';
    private StringBuffer buffer;

    AbstractCommandProvider() {
        this.setBuffer(new StringBuffer(4096));
    }

    final void append(char value) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(value);
    }

    final void append(Object value) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(value);
    }

    final void appendIndent() {
        this.append('\t');
    }

    final void appendLine(Object value) {
        this.append(value);
        this.appendNewLine();
    }

    final void appendNewLine() {
        this.append(LINE_SEPARATOR);
    }

    final StringBuffer getBuffer() {
        return this.buffer;
    }

    final String getBufferContents() {
        StringBuffer buffer = this.getBuffer();
        int length = buffer.length();
        String value = buffer.toString();
        buffer.delete(0, length);
        return value;
    }

    abstract String[] getCommandHelpLines();

    public final String getHelp() {
        String decoration = "---";
        String title = this.getTitle();
        this.append(decoration);
        this.append(title);
        this.appendLine(decoration);
        String[] lines = this.getCommandHelpLines();
        int length = lines.length;
        int i = 0;
        while (i < length) {
            String line = lines[i];
            this.appendIndent();
            this.appendLine(line);
            ++i;
        }
        String result = this.getBufferContents();
        return result;
    }

    abstract String getTitle();

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

