/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.BundleUtility;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.AbstractCommandProvider;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleDependencyCommandProvider
extends AbstractCommandProvider {
    private static final String ALL_DEPENDENTS_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.AllDependentsOfBundle";
    private static final String ALL_PREREQUISITES_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.AllPrerequisitesOfBundle";
    private static final String BUNDLE_LIST_HEADER_KEY = "BundleDependencyCommandProvider.BundleListHeader";
    private static final String CANNOT_FIND_BUNDLE_KEY = "BundleDependencyCommandProvider.CannotFindBundle";
    private static final String DEPEND_ALL_DESCRIPTION_KEY = "BundleDependencyCommandProvider.DependAllDescription";
    private static final String DEPEND_DESCRIPTION_KEY = "BundleDependencyCommandProvider.DependDescription";
    private static final String DEPENDENTS_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.DependentsOfBundle";
    private static final String ID_KEY = "BundleDependencyCommandProvider.Id";
    private static final String NO_BUNDLE_SPECIFIED_KEY = "BundleDependencyCommandProvider.NoBundleSpecified";
    private static final String NONE_KEY = "BundleDependencyCommandProvider.None";
    private static final String PARAMETER_MUST_BE_BUNDLE_ID_KEY = "BundleDependencyCommandProvider.ParameterMustBeBundleId";
    private static final String PREREQ_ALL_DESCRIPTION_KEY = "BundleDependencyCommandProvider.PrereqAllDescription";
    private static final String PREREQ_DESCRIPTION_KEY = "BundleDependencyCommandProvider.PrereqDescription";
    private static final String PREREQUISITES_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.PrerequisitesOfBundle";
    private static final String TITLE_KEY = "BundleDependencyCommandProvider.Title";
    private static final String ALL_DEPENDENTS_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.AllDependentsOfBundle");
    private static final String ALL_PREREQUISITES_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.AllPrerequisitesOfBundle");
    private static final String BUNDLE_LIST_HEADER = Messages.getString("BundleDependencyCommandProvider.BundleListHeader");
    private static final String CANNOT_FIND_BUNDLE = Messages.getString("BundleDependencyCommandProvider.CannotFindBundle");
    private static final String DEPEND_ALL_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.DependAllDescription");
    private static final String DEPEND_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.DependDescription");
    private static final String DEPENDENTS_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.DependentsOfBundle");
    private static final String ID = Messages.getString("BundleDependencyCommandProvider.Id");
    private static final String NO_BUNDLE_SPECIFIED = Messages.getString("BundleDependencyCommandProvider.NoBundleSpecified");
    private static final String NONE = Messages.getString("BundleDependencyCommandProvider.None");
    private static final String PARAMETER_MUST_BE_BUNDLE_ID = Messages.getString("BundleDependencyCommandProvider.ParameterMustBeBundleId");
    private static final String PREREQ_ALL_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.PrereqAllDescription");
    private static final String PREREQ_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.PrereqDescription");
    private static final String PREREQUISITES_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.PrerequisitesOfBundle");
    private static final String TITLE = Messages.getString("BundleDependencyCommandProvider.Title");
    private static final String BUNDLE_LIST_ROW = "{0}\t{1}{2}{3}_{4}";
    private static final String DEPEND_ALL_COMMAND_HELP = "dependall <{0}> - {1}";
    private static final String DEPEND_COMMAND_HELP = "depend <{0}> - {1}";
    private static final String PREREQ_ALL_COMMAND_HELP = "prereqall <{0}> - {1}";
    private static final String PREREQ_COMMAND_HELP = "prereq <{0}> - {1}";
    private static final char IS_REGISTERED_AS_UNINSTALLABLE_FLAG = '*';
    private static final String NO_VERSION = "0.0.0";
    private static final char SPACE = ' ';
    private BundleContext bundleContext;
    private BundleDependencyService model;
    private Comparator bundleComparator;

    public BundleDependencyCommandProvider(BundleContext bundleContext, BundleDependencyService bundleDependencyService) {
        this.setBundleContext(bundleContext);
        this.setModel(bundleDependencyService);
        this.setBundleComparator(this.createBundleComparator());
    }

    public void _dep(CommandInterpreter interpreter) throws Exception {
        this._depend(interpreter);
    }

    public void _depa(CommandInterpreter interpreter) throws Exception {
        this._dependall(interpreter);
    }

    public void _depend(CommandInterpreter interpreter) throws Exception {
        Bundle bundle = this.getNextArgumentBundle(interpreter);
        if (bundle == null) {
            return;
        }
        String bundleSymbolicName = bundle.getSymbolicName();
        String message = MessageFormatter.format(DEPENDENTS_OF_BUNDLE, bundleSymbolicName);
        this.appendLine(message);
        List list = this.getDependentsOf(bundle);
        this.appendBundles(list);
        String value = this.getBufferContents();
        interpreter.println((Object)value);
    }

    public void _dependall(CommandInterpreter interpreter) throws Exception {
        Bundle bundle = this.getNextArgumentBundle(interpreter);
        if (bundle == null) {
            return;
        }
        String bundleSymbolicName = bundle.getSymbolicName();
        String message = MessageFormatter.format(ALL_DEPENDENTS_OF_BUNDLE, bundleSymbolicName);
        this.appendLine(message);
        List list = this.getAllDependentsOf(bundle);
        this.appendBundles(list);
        String value = this.getBufferContents();
        interpreter.println((Object)value);
    }

    public void _pre(CommandInterpreter interpreter) throws Exception {
        this._prereq(interpreter);
    }

    public void _prea(CommandInterpreter interpreter) throws Exception {
        this._prereqall(interpreter);
    }

    public void _prereq(CommandInterpreter interpreter) throws Exception {
        Bundle bundle = this.getNextArgumentBundle(interpreter);
        if (bundle == null) {
            return;
        }
        String bundleSymbolicName = bundle.getSymbolicName();
        String message = MessageFormatter.format(PREREQUISITES_OF_BUNDLE, bundleSymbolicName);
        this.appendLine(message);
        List list = this.getPrerequisitesOf(bundle);
        this.appendBundles(list);
        String value = this.getBufferContents();
        interpreter.println((Object)value);
    }

    public void _prereqall(CommandInterpreter interpreter) throws Exception {
        Bundle bundle = this.getNextArgumentBundle(interpreter);
        if (bundle == null) {
            return;
        }
        String bundleSymbolicName = bundle.getSymbolicName();
        String message = MessageFormatter.format(ALL_PREREQUISITES_OF_BUNDLE, bundleSymbolicName);
        this.appendLine(message);
        List list = this.getAllPrerequisitesOf(bundle);
        this.appendBundles(list);
        String value = this.getBufferContents();
        interpreter.println((Object)value);
    }

    private void appendBundles(List list) {
        boolean empty = list.isEmpty();
        if (empty) {
            this.appendIndent();
            this.appendLine(NONE);
        } else {
            this.appendNewLine();
            this.appendLine(BUNDLE_LIST_HEADER);
            Comparator comparator = this.getBundleComparator();
            Collections.sort(list, comparator);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Bundle bundle = (Bundle)iterator.next();
                String id = this.toBundleIdString(bundle);
                String state = this.toBundleStateString(bundle);
                String padding = this.createBundleStatePadding(bundle, state);
                String name = bundle.getSymbolicName();
                String version = this.getBundleVersion(bundle);
                Object[] values = new Object[]{id, state, padding, name, version};
                String message = MessageFormatter.format(BUNDLE_LIST_ROW, values);
                this.appendLine(message);
            }
        }
    }

    private int compare(Bundle leftBundle, Bundle rightBundle) {
        long rightBundleId;
        long leftBundleId = leftBundle.getBundleId();
        if (leftBundleId < (rightBundleId = rightBundle.getBundleId())) {
            return -1;
        }
        if (leftBundleId > rightBundleId) {
            return 1;
        }
        return 0;
    }

    private Comparator createBundleComparator() {
        return new Comparator(){

            public int compare(Object left, Object right) {
                Bundle leftBundle = (Bundle)left;
                Bundle rightBundle = (Bundle)right;
                int result = BundleDependencyCommandProvider.this.compare(leftBundle, rightBundle);
                return result;
            }
        };
    }

    private String createBundleStatePadding(Bundle bundle, String state) {
        int stateLength = state.length();
        int length = 12 - stateLength;
        char[] chars = new char[length];
        Arrays.fill(chars, ' ');
        boolean uninstallable = this.isRegisteredAsUninstallable(bundle);
        if (uninstallable) {
            chars[length - 2] = 42;
        }
        String padding = new String(chars);
        return padding;
    }

    private List getAllDependentsOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getAllDependentsOf(bundle);
        return list;
    }

    private List getAllPrerequisitesOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getAllPrerequisitesOf(bundle);
        return list;
    }

    private Bundle getBundle(long id) {
        BundleContext context = this.getBundleContext();
        Bundle bundle = context.getBundle(id);
        return bundle;
    }

    private Comparator getBundleComparator() {
        return this.bundleComparator;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private String getBundleVersion(Bundle bundle) {
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String version = utility.getBundleVersion(bundle);
        if (version == null) {
            version = NO_VERSION;
        }
        return version;
    }

    protected String[] getCommandHelpLines() {
        return new String[]{this.getDependCommandHelpLine(), this.getDependAllCommandHelpLine(), this.getPrereqCommandHelpLine(), this.getPrereqAllCommandHelpLine()};
    }

    private String getDependAllCommandHelpLine() {
        Object[] values = new Object[]{ID, DEPEND_ALL_DESCRIPTION};
        String result = MessageFormatter.format(DEPEND_ALL_COMMAND_HELP, values);
        return result;
    }

    private String getDependCommandHelpLine() {
        Object[] values = new Object[]{ID, DEPEND_DESCRIPTION};
        String result = MessageFormatter.format(DEPEND_COMMAND_HELP, values);
        return result;
    }

    private List getDependentsOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getDependentsOf(bundle);
        return list;
    }

    private BundleDependencyService getModel() {
        return this.model;
    }

    private Bundle getNextArgumentBundle(CommandInterpreter interpreter) {
        long id;
        String argument = interpreter.nextArgument();
        if (argument == null) {
            interpreter.println((Object)NO_BUNDLE_SPECIFIED);
            return null;
        }
        try {
            id = Long.parseLong(argument);
        }
        catch (NumberFormatException numberFormatException) {
            interpreter.println((Object)PARAMETER_MUST_BE_BUNDLE_ID);
            return null;
        }
        Bundle bundle = this.getBundle(id);
        if (bundle == null) {
            String message = MessageFormatter.format(CANNOT_FIND_BUNDLE, argument);
            interpreter.println((Object)message);
            return null;
        }
        return bundle;
    }

    private String getPrereqAllCommandHelpLine() {
        Object[] values = new Object[]{ID, PREREQ_ALL_DESCRIPTION};
        String result = MessageFormatter.format(PREREQ_ALL_COMMAND_HELP, values);
        return result;
    }

    private String getPrereqCommandHelpLine() {
        Object[] values = new Object[]{ID, PREREQ_DESCRIPTION};
        String result = MessageFormatter.format(PREREQ_COMMAND_HELP, values);
        return result;
    }

    private List getPrerequisitesOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getPrerequisitesOf(bundle);
        return list;
    }

    protected String getTitle() {
        return TITLE;
    }

    private boolean isRegisteredAsUninstallable(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        boolean uninstallable = bds.isRegisteredAsUninstallable(bundle);
        return uninstallable;
    }

    private void setBundleComparator(Comparator bundleComparator) {
        this.bundleComparator = bundleComparator;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void setModel(BundleDependencyService model) {
        this.model = model;
    }

    private String toBundleIdString(Bundle bundle) {
        long id = bundle.getBundleId();
        String value = String.valueOf(id);
        return value;
    }

    private String toBundleStateString(Bundle bundle) {
        BundleUtility utility = BundleUtility.getInstance();
        String value = utility.toBundleStateString(bundle);
        return value;
    }
}

