/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal;

import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.AbstractCommandProvider;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.Messages;

public class LogCommandProvider
extends AbstractCommandProvider {
    private static final String DEBUG_LOG_LEVEL_KEY = "LogCommandProvider.DebugLogLevel";
    private static final String ERROR_LOG_LEVEL_KEY = "LogCommandProvider.ErrorLogLevel";
    private static final String INFO_LOG_LEVEL_KEY = "LogCommandProvider.InfoLogLevel";
    private static final String LOG_LEVEL_DESCRIPTION_KEY = "LogCommandProvider.LogLevelDescription";
    private static final String LOG_LEVEL_IS_KEY = "LogCommandProvider.LogLevelIs";
    private static final String OFF_KEY = "LogCommandProvider.Off";
    private static final String ON_KEY = "LogCommandProvider.On";
    private static final String TITLE_KEY = "LogCommandProvider.Title";
    private static final String TRACE_DESCRIPTION_KEY = "LogCommandProvider.TraceDescription";
    private static final String TRACING_IS_KEY = "LogCommandProvider.TracingIs";
    private static final String UNKNOWN_LOG_LEVEL_KEY = "LogCommandProvider.UnknownLogLevel";
    private static final String VALID_LOG_LEVEL_PARAMETERS_KEY = "LogCommandProvider.ValidLogLevelParameters";
    private static final String VALID_TRACE_PARAMETERS_KEY = "LogCommandProvider.ValidTraceParameters";
    private static final String WARNING_LOG_LEVEL_KEY = "LogCommandProvider.WarningLogLevel";
    private static final String DEBUG_LOG_LEVEL = Messages.getString("LogCommandProvider.DebugLogLevel");
    private static final String ERROR_LOG_LEVEL = Messages.getString("LogCommandProvider.ErrorLogLevel");
    private static final String INFO_LOG_LEVEL = Messages.getString("LogCommandProvider.InfoLogLevel");
    private static final String LOG_LEVEL_DESCRIPTION = Messages.getString("LogCommandProvider.LogLevelDescription");
    private static final String LOG_LEVEL_IS = Messages.getString("LogCommandProvider.LogLevelIs");
    private static final String OFF = Messages.getString("LogCommandProvider.Off");
    private static final String ON = Messages.getString("LogCommandProvider.On");
    private static final String TITLE = Messages.getString("LogCommandProvider.Title");
    private static final String TRACE_DESCRIPTION = Messages.getString("LogCommandProvider.TraceDescription");
    private static final String TRACING_IS = Messages.getString("LogCommandProvider.TracingIs");
    private static final String UNKNOWN_LOG_LEVEL = Messages.getString("LogCommandProvider.UnknownLogLevel");
    private static final String VALID_LOG_LEVEL_PARAMETERS = Messages.getString("LogCommandProvider.ValidLogLevelParameters");
    private static final String VALID_TRACE_PARAMETERS = Messages.getString("LogCommandProvider.ValidTraceParameters");
    private static final String WARNING_LOG_LEVEL = Messages.getString("LogCommandProvider.WarningLogLevel");
    private static final String LOG_LEVEL_COMMAND_HELP = "loglevel {({0}|{1}|{2}|{3})} - {4}";
    private static final String TRACE_COMMAND_HELP = "trace {({0}|{1})} - {2}";

    public void _ll(CommandInterpreter interpreter) {
        this._loglevel(interpreter);
    }

    public void _loglevel(CommandInterpreter interpreter) {
        String argument = interpreter.nextArgument();
        if (argument == null) {
            this.appendLogLevel();
        } else {
            int level = this.toLogLevel(argument);
            if (level != -1) {
                LogUtility.setLoggingLevel((int)level);
                this.appendLogLevel();
            } else {
                Object[] values = new Object[]{DEBUG_LOG_LEVEL, INFO_LOG_LEVEL, WARNING_LOG_LEVEL, ERROR_LOG_LEVEL};
                String value = MessageFormatter.format(VALID_LOG_LEVEL_PARAMETERS, values);
                this.appendLine(value);
            }
        }
        String value = this.getBufferContents();
        interpreter.print((Object)value);
    }

    public void _tr(CommandInterpreter interpreter) {
        this._trace(interpreter);
    }

    public void _trace(CommandInterpreter interpreter) {
        String argument = interpreter.nextArgument();
        if (argument == null) {
            this.appendTracingState();
        } else if (argument.equalsIgnoreCase(ON)) {
            this.setTracing(true);
        } else if (argument.equalsIgnoreCase(OFF)) {
            this.setTracing(false);
        } else {
            this.appendValidTraceParameters();
        }
        String value = this.getBufferContents();
        interpreter.print((Object)value);
    }

    private void appendLogLevel() {
        int level = LogUtility.getLoggingLevel();
        String value = this.toString(level);
        String message = MessageFormatter.format(LOG_LEVEL_IS, value);
        this.appendLine(message);
    }

    private void appendTracingState() {
        String state = LogUtility.isTracing() ? ON : OFF;
        String message = MessageFormatter.format(TRACING_IS, state);
        this.appendLine(message);
    }

    private void appendValidTraceParameters() {
        Object[] values = new Object[]{ON, OFF};
        String value = MessageFormatter.format(VALID_TRACE_PARAMETERS, values);
        this.appendLine(value);
    }

    protected String[] getCommandHelpLines() {
        return new String[]{this.getLogLevelCommandHelpLine(), this.getTraceCommandHelpLine()};
    }

    private String getLogLevelCommandHelpLine() {
        Object[] values = new Object[]{DEBUG_LOG_LEVEL, INFO_LOG_LEVEL, WARNING_LOG_LEVEL, ERROR_LOG_LEVEL, LOG_LEVEL_DESCRIPTION};
        String help = MessageFormatter.format(LOG_LEVEL_COMMAND_HELP, values);
        return help;
    }

    protected String getTitle() {
        return TITLE;
    }

    private String getTraceCommandHelpLine() {
        Object[] values = new Object[]{ON, OFF, TRACE_DESCRIPTION};
        String help = MessageFormatter.format(TRACE_COMMAND_HELP, values);
        return help;
    }

    private void setTracing(boolean tracing) {
        LogUtility.setTracing((boolean)tracing);
        this.appendTracingState();
    }

    private int toLogLevel(String value) {
        if (value.equalsIgnoreCase(DEBUG_LOG_LEVEL)) {
            return 4;
        }
        if (value.equalsIgnoreCase(INFO_LOG_LEVEL)) {
            return 3;
        }
        if (value.equalsIgnoreCase(WARNING_LOG_LEVEL)) {
            return 2;
        }
        if (value.equalsIgnoreCase(ERROR_LOG_LEVEL)) {
            return 1;
        }
        return -1;
    }

    private String toString(int level) {
        if (level == 4) {
            return DEBUG_LOG_LEVEL;
        }
        if (level == 3) {
            return INFO_LOG_LEVEL;
        }
        if (level == 2) {
            return WARNING_LOG_LEVEL;
        }
        if (level == 1) {
            return ERROR_LOG_LEVEL;
        }
        String message = MessageFormatter.format(UNKNOWN_LOG_LEVEL, new Integer(level));
        throw new IllegalArgumentException(message);
    }
}

