/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soda.sat.plugin.activator.ActivatorWizardModelListener;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActivatorWizardPage
extends WizardPage
implements IActivatorWizardPage {
    private static final String TITLE_KEY = "AbstractActivatorWizardPage.Title";
    protected static final IType[] NO_TYPES = new IType[0];
    private IActivatorWizard parent;
    private boolean limitServicesToInterfaceTypes;
    private boolean limitServicesToTypesVisibleToProject;
    private ActivatorWizardModelListener modelListener;

    protected AbstractActivatorWizardPage(String name, IActivatorWizard parent) {
        super(name);
        this.setParent(parent);
        this.setTitle(this.getTitleString());
        this.setMessage(this.getMessageString());
    }

    protected final void addBundleDependencyFor(IType type) {
        IActivatorWizard wizard = this.getParent();
        wizard.addBundleDependencyFor(type);
    }

    protected final void asyncExec(Runnable runnable) {
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        Display display = shell.getDisplay();
        display.asyncExec(runnable);
    }

    protected abstract void buildPage(Composite var1);

    protected final void buildSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        GridData data = new GridData(4, 0, true, false);
        data.heightHint = 10;
        data.horizontalSpan = this.getColumns();
        label.setLayoutData((Object)data);
    }

    final Button createButton(Composite parent, int style, String textKey, SelectionListener listener) {
        Button button = this.createButton(parent, style, textKey, null, listener);
        return button;
    }

    protected final Button createButton(Composite parent, int style, String textKey, String toolTipKey, SelectionListener listener) {
        Button button = new Button(parent, style);
        String value = Messages.getString(textKey);
        button.setText(value);
        if (toolTipKey != null) {
            String toolTip = Messages.getString(toolTipKey);
            button.setToolTipText(toolTip);
        }
        GridData data = new GridData(4, 4, false, false);
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    final Composite createComposite(Composite parent, int columns) {
        boolean grabExcessHorizontalSpace = true;
        boolean grabExcessVerticalSpace = true;
        Composite composite = this.createComposite(parent, columns, grabExcessHorizontalSpace, grabExcessVerticalSpace);
        return composite;
    }

    final Composite createComposite(Composite parent, int columns, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        Composite composite = new Composite(parent, 0);
        Layout layout = this.createCompositeLayout(columns);
        composite.setLayout(layout);
        Object data = this.createCompositeLayoutData(grabExcessHorizontalSpace, grabExcessVerticalSpace);
        composite.setLayoutData(data);
        return composite;
    }

    private Layout createCompositeLayout(int columns) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    private Object createCompositeLayoutData(boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        GridData data = new GridData(4, 4, grabExcessHorizontalSpace, grabExcessVerticalSpace);
        data.horizontalSpan = this.getColumns();
        return data;
    }

    public final void createControl(Composite parent) {
        int columns = this.getColumns();
        Composite composite = this.createComposite(parent, columns);
        int pixels = 8;
        this.setMarginWidth(composite, pixels);
        this.setMarginHeight(composite, pixels);
        this.setHorizontalSpacing(composite, pixels);
        this.buildPage(composite);
        this.setControl((Control)composite);
        this.hookupModelListener();
    }

    protected final Label createLabel(Composite parent, String textKey) {
        return this.createLabel(parent, textKey, 1);
    }

    final Label createLabel(Composite parent, String textKey, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        if (textKey != null) {
            String value = Messages.getString(textKey);
            label.setText(value);
        }
        GridData data = new GridData(1, 0x1000000, false, false, horizontalSpan, 1);
        label.setLayoutData((Object)data);
        return label;
    }

    private ActivatorWizardModelListener createModelListener() {
        return new ActivatorWizardModelListener(){

            public void handleBundleDependenciesChanged(List<String> bundleDependencies) {
                AbstractActivatorWizardPage.this.safelyHandleBundleDependenciesChanged(bundleDependencies);
            }

            public void handleBundleSymbolicNameChanged(String bundleSymbolicName) {
                AbstractActivatorWizardPage.this.safelyHandleBundleSymbolicNameChanged(bundleSymbolicName);
            }

            public void handleClassNameChanged(String className) {
                AbstractActivatorWizardPage.this.safelyHandleClassNameChanged(className);
            }

            public void handleCreateBundleActivatorLazilyChanged(boolean selection) {
                AbstractActivatorWizardPage.this.safelyHandleCreateBundleActivatorLazilyChanged(selection);
            }

            public void handleCustomStartAndStopChanged(boolean selection) {
                AbstractActivatorWizardPage.this.safelyHandleCustomStartAndStopChanged(selection);
            }

            public void handleExportedServicesChanged(List<IExportedServiceDetails> details) {
                AbstractActivatorWizardPage.this.safelyHandleExportedServicesChanged(details);
            }

            public void handleImportedServicesChanged(List<IImportedServiceDetails> details) {
                AbstractActivatorWizardPage.this.safelyHandleImportedServicesChanged(details);
            }

            public void handleLazyBundleActivatorPropertiesFilenameChanged(String lazyBundleActivatorPropertiesFilename) {
                AbstractActivatorWizardPage.this.safelyHandleLazyBundleActivatorPropertiesFilenameChanged(lazyBundleActivatorPropertiesFilename);
            }

            public void handleLoadPropertiesPolicyChanged(int policy) {
                AbstractActivatorWizardPage.this.safelyHandleLoadPropertiesPolicyChanged(policy);
            }

            public void handlePackageNameChanged(String packageName) {
                AbstractActivatorWizardPage.this.safelyHandlePackageNameChanged(packageName);
            }

            public void handlePropertiesFilenameChanged(String propertiesFilename) {
                AbstractActivatorWizardPage.this.safelyHandlePropertiesFilenameChanged(propertiesFilename);
            }

            public void handleStartAsynchronouslyChanged(boolean selection) {
                AbstractActivatorWizardPage.this.safelyHandleStartAsynchronouslyChanged(selection);
            }

            public void handleStartAsynchronouslyNormalPriorityDeltaChanged(int startAsynchronouslyNormalPriorityDelta) {
                AbstractActivatorWizardPage.this.safelyHandleStartAsynchronouslyNormalPriorityDeltaChanged(startAsynchronouslyNormalPriorityDelta);
            }

            public void handleUninstallPolicyChanged(int policy) {
                AbstractActivatorWizardPage.this.safelyHandleUninstallPolicyChanged(policy);
            }
        };
    }

    private IJavaSearchScope createProjectScope() {
        IJavaProject project = this.getJavaProject();
        IJavaProject[] elements = new IJavaProject[]{project};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        return scope;
    }

    final TableViewer createTableViewer(Composite parent, int style, ITableLabelProvider labelProvider, IContentProvider contentProvider, ISelectionChangedListener selectionChangedListener) {
        TableViewer viewer = new TableViewer(parent, style);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setContentProvider(contentProvider);
        viewer.addSelectionChangedListener(selectionChangedListener);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        return viewer;
    }

    protected final Text createText(Composite parent, ModifyListener listener, String toolTipKey) {
        Text text = new Text(parent, 2048);
        if (listener != null) {
            text.addModifyListener(listener);
        }
        if (toolTipKey != null) {
            String value = Messages.getString(toolTipKey);
            text.setToolTipText(value);
        }
        GridData data = new GridData(4, 0x1000000, true, false);
        text.setLayoutData((Object)data);
        return text;
    }

    @Override
    public void finish() {
        this.unhookModelListener();
    }

    protected int getColumns() {
        return 1;
    }

    protected abstract String getHelpContextId();

    final IJavaProject getJavaProject() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IJavaProject project = (IJavaProject)root.getAncestor(2);
        return project;
    }

    protected boolean getLimitServicesToInterfaceTypes() {
        return this.limitServicesToInterfaceTypes;
    }

    protected boolean getLimitServicesToTypesVisibleToProject() {
        return this.limitServicesToTypesVisibleToProject;
    }

    protected boolean getMakeColumnWidthsEqual() {
        return false;
    }

    protected abstract String getMessageString();

    final IActivatorWizardModel getModel() {
        IActivatorWizard parent = this.getParent();
        IActivatorWizardModel model = parent.getModel();
        return model;
    }

    private ActivatorWizardModelListener getModelListener() {
        return this.modelListener;
    }

    protected final IPackageFragmentRoot getPackageFragmentRoot() {
        IActivatorWizard parent = this.getParent();
        IPackageFragmentRoot root = parent.getPackageFragmentRoot();
        return root;
    }

    private IActivatorWizard getParent() {
        return this.parent;
    }

    protected final IActivatorWizardPreferences getPreferences() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences preferences = utility.getPreferences();
        return preferences;
    }

    protected String getTitleString() {
        return Messages.getString(TITLE_KEY);
    }

    protected void handleBundleDependenciesChanged(List<String> bundleDependencies) {
    }

    protected void handleBundleSymbolicNameChanged(String bundleSymbolicName) {
    }

    protected void handleClassNameChanged(String className) {
    }

    protected void handleCreateBundleActivatorLazilyChanged(boolean selection) {
    }

    protected void handleCustomStartAndStopChanged(boolean selection) {
    }

    protected void handleExportedServiceDetailsChanged(List<IExportedServiceDetails> details) {
    }

    protected void handleImportedServiceDetailsChanged(List<IImportedServiceDetails> details) {
    }

    protected void handleLazyBundleActivatorPropertiesFilenameChanged(String lazyBundleActivatorPropertiesFilename) {
    }

    protected void handleLoadPropertiesPolicyChanged(int policy) {
    }

    protected void handlePackageNameChanged(String packageName) {
    }

    protected void handlePropertiesFilenameChanged(String propertiesFilename) {
    }

    protected void handleStartAsynchronouslyChanged(boolean selection) {
    }

    protected void handleStartAsynchronouslyNormalPriorityDeltaChanged(int startAsynchronouslyNormalPriorityDelta) {
    }

    protected void handleUninstallPolicyChanged(int policy) {
    }

    private void hookupModelListener() {
        IActivatorWizardModel model = this.getModel();
        ActivatorWizardModelListener listener = this.createModelListener();
        this.setModelListener(listener);
        model.addActivatorWizardModelListener(listener);
    }

    protected final boolean isOnUserInterfaceThread() {
        UiUtility utility = UiUtility.getInstance();
        boolean result = utility.isOnUserInterfaceThread();
        return result;
    }

    protected final void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    protected final IType[] openSelectTypeDialog(String titleKey, String messageKey) {
        IType[] types = this.openSelectTypeDialog(titleKey, messageKey, new String(), true);
        return types;
    }

    final IType[] openSelectTypeDialog(String titleKey, String messageKey, String filter, boolean multipleSelection) {
        boolean state = this.getLimitServicesToInterfaceTypes();
        int style = state ? 4 : 512;
        boolean projectScope = this.getLimitServicesToTypesVisibleToProject();
        IType[] types = this.openSelectTypeDialog(titleKey, messageKey, filter, multipleSelection, style, projectScope);
        return types;
    }

    protected final IType[] openSelectTypeDialog(String titleKey, String messageKey, String filter, boolean multipleSelection, int style, boolean projectScope) {
        IType[] types;
        SelectionDialog dialog;
        Shell parent = this.getShell();
        ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
        IJavaSearchScope scope = projectScope ? this.createProjectScope() : SearchEngine.createWorkspaceScope();
        try {
            dialog = JavaUI.createTypeDialog((Shell)parent, (IRunnableContext)context, (IJavaSearchScope)scope, (int)style, (boolean)multipleSelection, (String)filter);
        }
        catch (JavaModelException exception) {
            this.logError(exception);
            return NO_TYPES;
        }
        String title = Messages.getString(titleKey);
        dialog.setTitle(title);
        String message = Messages.getString(messageKey);
        dialog.setMessage(message);
        int result = dialog.open();
        if (result == 0) {
            Object[] objects = dialog.getResult();
            int size = objects.length;
            types = new IType[size];
            System.arraycopy(objects, 0, types, 0, size);
        } else {
            types = NO_TYPES;
        }
        return types;
    }

    final void removeBundleDependencyFor(String fullyQualifiedName) {
        IActivatorWizard wizard = this.getParent();
        wizard.removeBundleDependencyFor(fullyQualifiedName);
    }

    private void safelyHandleBundleDependenciesChanged(final List<String> bundleDependencies) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleBundleDependenciesChanged(bundleDependencies);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleBundleDependenciesChanged(bundleDependencies);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleBundleSymbolicNameChanged(final String bundleSymbolicName) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleBundleSymbolicNameChanged(bundleSymbolicName);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleBundleSymbolicNameChanged(bundleSymbolicName);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleClassNameChanged(final String className) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleClassNameChanged(className);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleClassNameChanged(className);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleCreateBundleActivatorLazilyChanged(final boolean createBundleActivatorLazily) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleCreateBundleActivatorLazilyChanged(createBundleActivatorLazily);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleCreateBundleActivatorLazilyChanged(createBundleActivatorLazily);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleCustomStartAndStopChanged(final boolean customStartAndStop) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleCustomStartAndStopChanged(customStartAndStop);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleCustomStartAndStopChanged(customStartAndStop);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleExportedServicesChanged(final List<IExportedServiceDetails> details) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleExportedServiceDetailsChanged(details);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleExportedServiceDetailsChanged(details);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleImportedServicesChanged(final List<IImportedServiceDetails> details) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleImportedServiceDetailsChanged(details);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleImportedServiceDetailsChanged(details);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleLazyBundleActivatorPropertiesFilenameChanged(final String lazyBundleActivatorPropertiesFilename) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleLazyBundleActivatorPropertiesFilenameChanged(lazyBundleActivatorPropertiesFilename);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleLazyBundleActivatorPropertiesFilenameChanged(lazyBundleActivatorPropertiesFilename);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleLoadPropertiesPolicyChanged(final int policy) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleLoadPropertiesPolicyChanged(policy);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleLoadPropertiesPolicyChanged(policy);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandlePackageNameChanged(final String packageName) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handlePackageNameChanged(packageName);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handlePackageNameChanged(packageName);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandlePropertiesFilenameChanged(final String propertiesFilename) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handlePropertiesFilenameChanged(propertiesFilename);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handlePropertiesFilenameChanged(propertiesFilename);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleStartAsynchronouslyChanged(final boolean startAsynchronously) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleStartAsynchronouslyChanged(startAsynchronously);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleStartAsynchronouslyChanged(startAsynchronously);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleStartAsynchronouslyNormalPriorityDeltaChanged(final int startAsynchronouslyNormalPriorityDelta) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleStartAsynchronouslyNormalPriorityDeltaChanged(startAsynchronouslyNormalPriorityDelta);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleStartAsynchronouslyNormalPriorityDeltaChanged(startAsynchronouslyNormalPriorityDelta);
                }
            };
            this.asyncExec(runnable);
        }
    }

    private void safelyHandleUninstallPolicyChanged(final int policy) {
        boolean safe = this.isOnUserInterfaceThread();
        if (safe) {
            this.handleUninstallPolicyChanged(policy);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractActivatorWizardPage.this.handleUninstallPolicyChanged(policy);
                }
            };
            this.asyncExec(runnable);
        }
    }

    protected final void setControl(Control control) {
        super.setControl(control);
        Dialog.applyDialogFont((Control)control);
        this.setHelp(control);
    }

    private void setHelp(Control control) {
        String contextId = this.getHelpContextId();
        if (contextId == null) {
            return;
        }
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp(control, contextId);
    }

    protected final void setHorizontalSpacing(Composite composite, int pixels) {
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.horizontalSpacing = pixels;
    }

    protected void setLimitServicesToInterfaceTypes(boolean limitServicesToInterfaceTypes) {
        this.limitServicesToInterfaceTypes = limitServicesToInterfaceTypes;
    }

    protected void setLimitServicesToTypesVisibleToProject(boolean limitServicesToTypesVisibleToProject) {
        this.limitServicesToTypesVisibleToProject = limitServicesToTypesVisibleToProject;
    }

    protected final void setMarginHeight(Composite composite, int pixels) {
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginHeight = pixels;
    }

    protected final void setMarginWidth(Composite composite, int pixels) {
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = pixels;
    }

    private void setModelListener(ActivatorWizardModelListener modelListener) {
        this.modelListener = modelListener;
    }

    protected final void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        IActivatorWizard parent = this.getParent();
        parent.setPackageFragmentRoot(packageFragmentRoot);
    }

    private void setParent(IActivatorWizard parent) {
        this.parent = parent;
    }

    final void setVerticalSpacing(Composite composite, int pixels) {
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = pixels;
    }

    final String toUnqualifiedTypeName(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        String result = name.substring(index + 1);
        return result;
    }

    private void unhookModelListener() {
        IActivatorWizardModel model = this.getModel();
        ActivatorWizardModelListener listener = this.getModelListener();
        model.removeActivatorWizardModelListener(listener);
        this.setModelListener(null);
    }
}

