/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ExportedServicesCompositeBuilder;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ImportedServicesCompositeBuilder;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String CLASSES_AND_INTERFACES_KEY = "ServicesActivatorWizardPage.ClassesAndInterfaces";
    private static final String DESCRIPTION_KEY = "ServicesActivatorWizardPage.Description";
    private static final String EDIT_TYPE_SCOPE_KEY = "ServicesActivatorWizardPage.EditTypeScope";
    private static final String INTERFACES_KEY = "ServicesActivatorWizardPage.Interfaces";
    private static final String PROJECT_KEY = "ServicesActivatorWizardPage.Project";
    private static final String TITLE_KEY = "ServicesActivatorWizardPage.Title";
    private static final String TYPE_SCOPE_PREFERENCES_PROMPT_KEY = "ServicesActivatorWizardPage.TypeScopePreferencesPrompt";
    private static final String TYPE_SCOPE_PREFERENCES_TITLE_KEY = "ServicesActivatorWizardPage.TypeScopePreferencesTitle";
    private static final String TYPE_SCOPE_TEMPLATE_KEY = "ServicesActivatorWizardPage.TypeScopeTemplateKey";
    private static final String WORKSPACE_KEY = "ServicesActivatorWizardPage.Workspace";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.servicesActivatorWizardPage";
    private static final String PAGE_NAME = ServicesActivatorWizardPage.class.getName();
    private boolean storeExportedServicesInFields;
    private boolean exportServicesWithProperties;
    private boolean createExportedProxyServices;
    private boolean optionallyImportServices;
    private ImportedServicesCompositeBuilder importedServicesCompositeBuilder;
    private ExportedServicesCompositeBuilder exportedServicesCompositeBuilder;
    private Button editTypeScopeButton;

    public ServicesActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
        this.initializeFromPreferences();
    }

    private void buildEditTypeScopeRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleEditTypeScopeButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, EDIT_TYPE_SCOPE_KEY, (SelectionListener)listener);
        this.setEditTypeScopeButton(button);
        this.updateEditTypeScopeButtonToolTip();
        GridData data = new GridData(1, 1, false, false);
        button.setLayoutData((Object)data);
    }

    private void buildExportedServicesRow(SashForm form) {
        ExportedServicesCompositeBuilder builder = new ExportedServicesCompositeBuilder(this);
        this.setExportedServicesCompositeBuilder(builder);
        builder.build(form);
    }

    private void buildImportedServicesRow(SashForm form) {
        ImportedServicesCompositeBuilder builder = new ImportedServicesCompositeBuilder(this);
        this.setImportedServicesCompositeBuilder(builder);
        builder.build(form);
    }

    @Override
    protected void buildPage(Composite parent) {
        SashForm form = this.createSashForm(parent);
        this.buildImportedServicesRow(form);
        this.buildExportedServicesRow(form);
        this.buildSeparator(parent);
        this.buildEditTypeScopeRow(parent);
    }

    private SashForm createSashForm(Composite parent) {
        SashForm form = new SashForm(parent, 512);
        GridData data = new GridData(4, 4, true, true);
        form.setLayoutData((Object)data);
        return form;
    }

    @Override
    public void finish() {
        this.updatePreferences();
        super.finish();
    }

    boolean getCreateExportedProxyServices() {
        return this.createExportedProxyServices;
    }

    private Button getEditTypeScopeButton() {
        return this.editTypeScopeButton;
    }

    private ExportedServicesCompositeBuilder getExportedServicesCompositeBuilder() {
        return this.exportedServicesCompositeBuilder;
    }

    boolean getExportServicesWithProperties() {
        return this.exportServicesWithProperties;
    }

    @Override
    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private ImportedServicesCompositeBuilder getImportedServicesCompositeBuilder() {
        return this.importedServicesCompositeBuilder;
    }

    @Override
    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    boolean getOptionallyImportServices() {
        return this.optionallyImportServices;
    }

    boolean getStoreExportedServicesInFields() {
        return this.storeExportedServicesInFields;
    }

    @Override
    protected String getTitleString() {
        return Messages.getString(TITLE_KEY);
    }

    private void handleEditTypeScopeButtonClicked() {
        String limitServicesToInterfaceTypesLabel = Messages.getString("TypeScopePreferencesCompositeBuilder.LimitServicesToInterfaceTypes");
        String limitServicesToTypesVisibleToProjectLabel = Messages.getString("TypeScopePreferencesCompositeBuilder.LimitServicesToTypesVisibleToTheProject");
        Object[] values = new Object[]{limitServicesToInterfaceTypesLabel, limitServicesToTypesVisibleToProjectLabel};
        String pattern = Messages.getString(TYPE_SCOPE_PREFERENCES_PROMPT_KEY);
        String prompt = MessageFormat.format(pattern, values);
        Shell shell = this.getShell();
        FactoryUtility utility = FactoryUtility.getInstance();
        IHandyPromptDialog dialog = utility.createHandyPromptDialog(shell, prompt);
        String title = Messages.getString(TYPE_SCOPE_PREFERENCES_TITLE_KEY);
        dialog.setTitle(title);
        dialog.setYesButtonText(String.valueOf('&') + IDialogConstants.OK_LABEL);
        dialog.setNoButtonText(null);
        dialog.defaultButtonIsYes();
        dialog.setSize(525, 299);
        boolean limitServicesToInterfaceTypes = this.getLimitServicesToInterfaceTypes();
        int limitServicesToInterfaceTypesCheckboxId = dialog.addCheckbox(limitServicesToInterfaceTypesLabel, limitServicesToInterfaceTypes);
        boolean limitServicesToTypesVisibleToProject = this.getLimitServicesToTypesVisibleToProject();
        int limitServicesToTypesVisibleToProjectCheckboxId = dialog.addCheckbox(limitServicesToTypesVisibleToProjectLabel, limitServicesToTypesVisibleToProject);
        int rc = dialog.open();
        if (rc == 1) {
            return;
        }
        limitServicesToInterfaceTypes = dialog.isCheckboxSelected(limitServicesToInterfaceTypesCheckboxId);
        this.setLimitServicesToInterfaceTypes(limitServicesToInterfaceTypes);
        limitServicesToTypesVisibleToProject = dialog.isCheckboxSelected(limitServicesToTypesVisibleToProjectCheckboxId);
        this.setLimitServicesToTypesVisibleToProject(limitServicesToTypesVisibleToProject);
        this.updateEditTypeScopeButtonToolTip();
    }

    @Override
    protected void handleExportedServiceDetailsChanged(List<IExportedServiceDetails> details) {
        ExportedServicesCompositeBuilder builder = this.getExportedServicesCompositeBuilder();
        builder.handleServiceDetailsChanged(details);
    }

    @Override
    protected void handleImportedServiceDetailsChanged(List<IImportedServiceDetails> details) {
        ImportedServicesCompositeBuilder builder = this.getImportedServicesCompositeBuilder();
        builder.handleServiceDetailsChanged(details);
    }

    private void initializeFromPreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = preferences.getStoreExportedServicesInFields();
        this.setStoreExportedServicesInFields(state);
        state = preferences.getExportServicesWithProperties();
        this.setExportServicesWithProperties(state);
        state = preferences.getCreateExportedProxyServices();
        this.setCreateExportedProxyServices(state);
        state = preferences.getOptionallyImportServices();
        this.setOptionallyImportServices(state);
        state = preferences.getLimitServicesToInterfaceTypes();
        this.setLimitServicesToInterfaceTypes(state);
        state = preferences.getLimitServicesToTypesVisibleToTheProject();
        this.setLimitServicesToTypesVisibleToProject(state);
    }

    private void setCreateExportedProxyServices(boolean exportedProxyService) {
        this.createExportedProxyServices = exportedProxyService;
    }

    private void setEditTypeScopeButton(Button editTypeScopeButton) {
        this.editTypeScopeButton = editTypeScopeButton;
    }

    private void setExportedServicesCompositeBuilder(ExportedServicesCompositeBuilder exportedServicesCompositeBuilder) {
        this.exportedServicesCompositeBuilder = exportedServicesCompositeBuilder;
    }

    private void setExportServicesWithProperties(boolean exportedServiceHasProperties) {
        this.exportServicesWithProperties = exportedServiceHasProperties;
    }

    private void setImportedServicesCompositeBuilder(ImportedServicesCompositeBuilder importedServicesCompositeBuilder) {
        this.importedServicesCompositeBuilder = importedServicesCompositeBuilder;
    }

    private void setOptionallyImportServices(boolean importedServiceIsOptional) {
        this.optionallyImportServices = importedServiceIsOptional;
    }

    private void setStoreExportedServicesInFields(boolean exportedServiceIsStoredInField) {
        this.storeExportedServicesInFields = exportedServiceIsStoredInField;
    }

    private void updateEditTypeScopeButtonToolTip() {
        boolean limitServicesToInterfaceTypes = this.getLimitServicesToInterfaceTypes();
        String key0 = limitServicesToInterfaceTypes ? INTERFACES_KEY : CLASSES_AND_INTERFACES_KEY;
        String value0 = Messages.getString(key0);
        boolean limitServicesToTypesVisibleToProject = this.getLimitServicesToTypesVisibleToProject();
        String key1 = limitServicesToTypesVisibleToProject ? PROJECT_KEY : WORKSPACE_KEY;
        String value1 = Messages.getString(key1);
        Object[] values = new Object[]{value0, value1};
        String pattern = Messages.getString(TYPE_SCOPE_TEMPLATE_KEY);
        String toolTip = MessageFormat.format(pattern, values);
        Button button = this.getEditTypeScopeButton();
        button.setToolTipText(toolTip);
    }

    private void updatePreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = this.getLimitServicesToInterfaceTypes();
        preferences.setLimitServicesToInterfaceTypes(state);
        state = this.getLimitServicesToTypesVisibleToProject();
        preferences.setLimitServicesToTypesVisibleToTheProject(state);
    }
}

