/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.ui.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.soda.sat.plugin.dependency.BundleDependencyModelListener;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyModel;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.BundleDependencyViewConfigurationDialog;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.BundleTableLabelProvider;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.soda.sat.plugin.ui.util.IHandyTextDialog;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDependencyView
extends ViewPart {
    private static final String CONFIGURE_KEY = "BundleDependencyView.Configure";
    private static final String COPY_KEY = "BundleDependencyView.Copy";
    private static final String DEPENDENT_BUNDLES_KEY = "BundleDependencyView.DependentBundles";
    private static final String DO_NOT_REMIND_ME_AGAIN_KEY = "BundleDependencyView.DoNotRemindMeAgain";
    private static final String HORIZONTAL_ORIENTATION_KEY = "BundleDependencyView.HorizontalOrientation";
    private static final String INSTALL_BUNDLES_KEY = "BundleDependencyView.InstalledBundles";
    private static final String LOCK_ORIENTATION_KEY = "BundleDependencyView.LockOrientation";
    private static final String MANIFEST_FOR_DIALOG_TITLE_KEY = "BundleDependencyView.ManifestForDialogTitle";
    private static final String OPEN_BROWSER_KEY = "BundleDependencyView.OpenBrowser";
    private static final String POLL_KEY = "BundleDependencyView.Poll";
    private static final String PREREQUISITE_BUNDLES_KEY = "BundleDependencyView.PrerequisiteBundles";
    private static final String REFRESH_KEY = "BundleDependencyView.Refresh";
    private static final String REMINDER_DIALOG_TITLE_KEY = "BundleDependencyView.ReminderDialogTitle";
    private static final String REMINDER_KEY = "BundleDependencyView.Reminder";
    private static final String REMINDER1_KEY = "BundleDependencyView.Reminder1";
    private static final String REMINDER2_KEY = "BundleDependencyView.Reminder2";
    private static final String RESET_LAYOUT_PROPORTIONS_KEY = "BundleDependencyView.ResetLayoutProportions";
    private static final String SELECT_ALL_KEY = "BundleDependencyView.SelectAll";
    private static final String SHOW_ALL_BUNDLES_KEY = "Common.ShowAllBundles";
    private static final String VERTICAL_ORIENTATION_KEY = "BundleDependencyView.VerticalOrientation";
    private static final String VIEW_MANIFEST_KEY = "BundleDependencyView.ViewManifest";
    private static final String MEMENTO_KEY_ORIENTATION_LOCKED = "orientationLocked";
    private static final String MEMENTO_KEY_ORIENTATION = "orientation";
    private static final String MEMENTO_KEY_POLLING = "polling";
    private static final String MEMENTO_KEY_SHOW_ALL_BUNDLES = "showAllBundles";
    private static final String MEMENTO_VALUE_ORIENTATION_HORIZONTAL = "horizontal";
    private static final String MEMENTO_VALUE_ORIENTATION_VERTICAL = "vertical";
    private static final String ACTION_PARAMETER = "action";
    private static final String BROWSE_ACTION = "browse";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.dependency.ui.view";
    private Cursor busyCursor;
    private TableViewer dependentBundlesTableViewer;
    private TableViewer installedBundlesTableViewer;
    private ILabelProvider labelProvider;
    private IMemento memento;
    private IBundleDependencyModel model;
    private BundleDependencyModelListener modelListener;
    private IAction openBrowserAction;
    private IAction orientationLockAction;
    private boolean orientationLocked;
    private Composite parent;
    private TableViewer prerequisiteBundlesTableViewer;
    private Runnable refreshRunnable;
    private SashForm sashForm;
    private IAction toggleOrientationAction;
    private IAction togglePollingAction;
    private IAction toggleShowAllBundlesAction;

    private static IBundleDependencyModel createModel() {
        org.eclipse.soda.sat.plugin.dependency.bundle.Activator activator = org.eclipse.soda.sat.plugin.dependency.bundle.Activator.getDefault();
        IBundleDependencyModel model = activator.createBundleDependencyModel();
        return model;
    }

    public BundleDependencyView() {
        this(BundleDependencyView.createModel());
    }

    public BundleDependencyView(IBundleDependencyModel model) {
        this.setModel(model);
        this.setModelListener(this.createModelListener());
        this.setLabelProvider(this.createLabelProvider());
        this.updateTitle();
        this.setOrientationLocked(false);
    }

    private void addCopyMenuItem(Table table, Menu menu) {
        boolean legal;
        int count = table.getSelectionCount();
        boolean bl = legal = count > 0;
        if (!legal) {
            return;
        }
        String label = Messages.getString(COPY_KEY);
        final String[] bundles = this.getSelectedBundles(table);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BundleDependencyView.this.handleCopyToClipboard(bundles);
            }
        };
        Image image = this.getCopyImage();
        this.createMenuItem(menu, label, (SelectionListener)listener, image);
    }

    private void addPopupMenu(Control control, MenuListener listener) {
        Shell shell = control.getShell();
        Menu menu = new Menu((Decorations)shell, 8);
        menu.addMenuListener(listener);
        control.setMenu(menu);
    }

    private void addSelectAllMenuItem(final Table table, Menu menu) {
        boolean legal;
        int count = table.getItemCount();
        boolean bl = legal = count > 1;
        if (!legal) {
            return;
        }
        String label = Messages.getString(SELECT_ALL_KEY);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BundleDependencyView.this.handleSelectAll(table);
            }
        };
        Image image = null;
        this.createMenuItem(menu, label, (SelectionListener)listener, image);
    }

    private void addViewManifestMenuItem(Table table, Menu menu) {
        boolean legal;
        int count = table.getSelectionCount();
        boolean bl = legal = count == 1;
        if (!legal) {
            return;
        }
        String label = Messages.getString(VIEW_MANIFEST_KEY);
        String[] bundles = this.getSelectedBundles(table);
        final String bundle = bundles[0];
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BundleDependencyView.this.handleViewManifest(bundle);
            }
        };
        Image image = this.getManifestImage();
        this.createMenuItem(menu, label, (SelectionListener)listener, image);
    }

    private Cursor basicGetBusyCursor() {
        return this.busyCursor;
    }

    private void buildActions() {
        IMenuManager menuManager = this.getMenuManager();
        IToolBarManager toolBarManager = this.getToolBarManager();
        IAction action = this.createToggleShowAllBundlesAction();
        this.setToggleShowAllBundlesAction(action);
        toolBarManager.add(action);
        menuManager.add(action);
        action = this.createTogglePollingAction();
        this.setTogglePollingAction(action);
        toolBarManager.add(action);
        menuManager.add(action);
        action = this.createRefreshAction();
        toolBarManager.add(action);
        menuManager.add((IContributionItem)new Separator());
        action = this.getToggleOrientationAction();
        menuManager.add(action);
        action = this.getLockOrientationAction();
        menuManager.add(action);
        action = this.createResetLayoutProportionsActions();
        menuManager.add(action);
        menuManager.add((IContributionItem)new Separator());
        action = this.getOpenBrowserAction();
        menuManager.add(action);
        menuManager.add((IContributionItem)new Separator());
        action = this.createConfigureAction();
        menuManager.add(action);
    }

    private void buildGlobalActions() {
        IActionBars actionBars = this.getActionBars();
        IAction copyGlobalAction = this.createGlobalCopyAction();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyGlobalAction);
        IAction selectAllGlobalAction = this.createGlobalSelectAllAction();
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAllGlobalAction);
    }

    private void buildSashForm(Composite parent) {
        SashForm form = new SashForm(parent, 512);
        this.setSashForm(form);
        GridData data = new GridData(4, 4, true, true);
        form.setLayoutData((Object)data);
        ControlListener controlListener = this.createSashFormControlListener();
        form.addControlListener(controlListener);
        this.createBundleTableViewers((Composite)form);
        this.setSashFormLayoutProportions();
    }

    private String createBrowserUrl() {
        IBundleDependencyModel model = this.getModel();
        String host = model.getHost();
        String port = model.getPort();
        String servletAlias = model.getServletAlias();
        StringBuffer buffer = new StringBuffer(150);
        buffer.append(HTTP_PROTOCOL);
        buffer.append(host);
        buffer.append(':');
        buffer.append(port);
        buffer.append(servletAlias);
        buffer.append('?');
        buffer.append(ACTION_PARAMETER);
        buffer.append('=');
        buffer.append(BROWSE_ACTION);
        String url = buffer.toString();
        return url;
    }

    private void createBundleTableViewers(Composite parent) {
        IDoubleClickListener listener = this.createTableViewerDoubleClickListener();
        this.createPrerequisiteBundlesTableViewer(parent, listener);
        this.createInstalledBundlesTableViewer(parent);
        this.createDependentBundlesTableViewer(parent, listener);
    }

    private Cursor createBusyCursor() {
        Shell shell = this.getShell();
        Display device = shell.getDisplay();
        Cursor cursor = new Cursor((Device)device, 1);
        return cursor;
    }

    private IAction createConfigureAction() {
        String label = Messages.getString(CONFIGURE_KEY);
        Action action = new Action(label){

            public void run() {
                BundleDependencyView.this.handleConfigure();
            }
        };
        action.setToolTipText(label);
        ImageDescriptor descriptor = this.getImageDescriptor("configure");
        action.setImageDescriptor(descriptor);
        return action;
    }

    private void createDependentBundlesTableViewer(Composite parent, IDoubleClickListener listener) {
        String text = Messages.getString(DEPENDENT_BUNDLES_KEY);
        TableViewer viewer = this.createTableViewer(parent, text);
        viewer.addDoubleClickListener(listener);
        this.setDependentBundlesTableViewer(viewer);
    }

    private IAction createGlobalCopyAction() {
        return new Action(){

            public void run() {
                BundleDependencyView.this.handleGlobalCopyToClipboard();
            }
        };
    }

    private IAction createGlobalSelectAllAction() {
        return new Action(){

            public void run() {
                BundleDependencyView.this.handleGlobalSelectAll();
            }
        };
    }

    private ISelectionChangedListener createInstalledBundlesListSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BundleDependencyView.this.handleInstalledBundleSelected();
            }
        };
    }

    private void createInstalledBundlesTableViewer(Composite parent) {
        String text = Messages.getString(INSTALL_BUNDLES_KEY);
        TableViewer viewer = this.createTableViewer(parent, text);
        ISelectionChangedListener listener = this.createInstalledBundlesListSelectionListener();
        viewer.addSelectionChangedListener(listener);
        this.setInstalledBundlesTableViewer(viewer);
    }

    private ILabelProvider createLabelProvider() {
        IBundleDependencyModel model = this.getModel();
        BundleTableLabelProvider provider = new BundleTableLabelProvider(model);
        return provider;
    }

    private MenuItem createMenuItem(Menu menu, String label, SelectionListener listener, Image image) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(label);
        menuItem.setImage(image);
        menuItem.addSelectionListener(listener);
        return menuItem;
    }

    private BundleDependencyModelListener createModelListener() {
        return new BundleDependencyModelListener(){

            public void bundleDependenciesChanged() {
                BundleDependencyView.this.updateBundleDependencies();
            }

            public void pollingChanged() {
                BundleDependencyView.this.updatePollAction();
            }

            public void showAllBundlesChanged() {
                BundleDependencyView.this.updateShowAllBundlesAction();
            }
        };
    }

    private IAction createOpenBrowserAction() {
        String label = Messages.getString(OPEN_BROWSER_KEY);
        Action action = new Action(label){

            public void run() {
                BundleDependencyView.this.handleOpenBrowser();
            }
        };
        action.setToolTipText(label);
        action.setEnabled(false);
        return action;
    }

    private IAction createOrientationLockAction() {
        String label = Messages.getString(LOCK_ORIENTATION_KEY);
        Action action = new Action(label, 2){

            public void run() {
                BundleDependencyView.this.handleLockOrientation();
            }
        };
        boolean locked = this.isOrientationLocked();
        action.setChecked(locked);
        action.setToolTipText(label);
        ImageDescriptor descriptor = this.getImageDescriptor("lock");
        action.setImageDescriptor(descriptor);
        return action;
    }

    public void createPartControl(Composite parent) {
        this.setParent(parent);
        this.updateTitle();
        this.buildSashForm(parent);
        this.buildActions();
        this.buildGlobalActions();
        this.loadStateFromMemento();
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp((Control)parent, HELP_CONTEXT_ID);
        boolean local = this.isLocalhost();
        if (!local) {
            return;
        }
        this.refresh();
    }

    private void createPrerequisiteBundlesTableViewer(Composite parent, IDoubleClickListener listener) {
        String text = Messages.getString(PREREQUISITE_BUNDLES_KEY);
        TableViewer viewer = this.createTableViewer(parent, text);
        viewer.addDoubleClickListener(listener);
        this.setPrerequisiteBundlesTableViewer(viewer);
    }

    private IAction createRefreshAction() {
        String label = Messages.getString(REFRESH_KEY);
        Action action = new Action(label){

            public void run() {
                BundleDependencyView.this.handleRefresh();
            }
        };
        action.setToolTipText(label);
        ImageDescriptor descriptor = this.getImageDescriptor("refresh");
        action.setImageDescriptor(descriptor);
        return action;
    }

    private Runnable createRefreshRunnable() {
        return new Runnable(){

            public void run() {
                BundleDependencyView.this.handleRefresh();
            }
        };
    }

    private String createReminderMessage() {
        IBundleDependencyModel model = this.getModel();
        String host = model.getHost();
        String port = model.getPort();
        String servletAlias = model.getServletAlias();
        String pattern = Messages.getString(REMINDER_KEY);
        String reminder1 = Messages.getString(REMINDER1_KEY);
        String reminder2 = Messages.getString(REMINDER2_KEY);
        String message = MessageFormat.format(pattern, reminder1, host, port, servletAlias, reminder2);
        return message;
    }

    private Runnable createReminderRunnable() {
        return new Runnable(){

            public void run() {
                BundleDependencyView.this.openReminderDialog();
            }
        };
    }

    private IAction createResetLayoutProportionsActions() {
        String label = Messages.getString(RESET_LAYOUT_PROPORTIONS_KEY);
        Action action = new Action(label){

            public void run() {
                BundleDependencyView.this.setSashFormLayoutProportions();
            }
        };
        return action;
    }

    private ControlListener createSashFormControlListener() {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                BundleDependencyView.this.layout();
            }
        };
    }

    private ControlListener createTableControlListener(final Table table) {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                BundleDependencyView.this.handleTableResized(table);
            }
        };
    }

    private MenuListener createTablePopupMenuListener(final Table table) {
        return new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                BundleDependencyView.this.handleTableMenuShownEvent(table);
            }
        };
    }

    private TableViewer createTableViewer(Composite parent, String name) {
        TableViewer viewer = new TableViewer(parent, 2);
        ArrayContentProvider contentProvider = new ArrayContentProvider();
        viewer.setContentProvider((IContentProvider)contentProvider);
        ILabelProvider labelProvider = this.getLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(name);
        column.setWidth(400);
        this.setTableColumnSelectionListener(viewer, column);
        ControlListener listener = this.createTableControlListener(table);
        parent.addControlListener(listener);
        MenuListener menuListener = this.createTablePopupMenuListener(table);
        this.addPopupMenu((Control)table, menuListener);
        return viewer;
    }

    private IDoubleClickListener createTableViewerDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableViewer viewer = (TableViewer)event.getSource();
                BundleDependencyView.this.handleTableViewerMouseDoubleClickEvent(viewer);
            }
        };
    }

    private IAction createToggleOrientationAction() {
        return new Action(){

            public void run() {
                BundleDependencyView.this.handleToggleOrientation();
            }
        };
    }

    private IAction createTogglePollingAction() {
        String label = Messages.getString(POLL_KEY);
        Action action = new Action(label, 2){

            public void run() {
                BundleDependencyView.this.handleTogglePolling();
            }
        };
        action.setToolTipText(label);
        ImageDescriptor descriptor = this.getImageDescriptor("poll");
        action.setImageDescriptor(descriptor);
        return action;
    }

    private IAction createToggleShowAllBundlesAction() {
        String label = Messages.getString(SHOW_ALL_BUNDLES_KEY);
        Action action = new Action(label, 2){

            public void run() {
                BundleDependencyView.this.handleToggleShowAllBundles();
            }
        };
        action.setToolTipText(label);
        ImageDescriptor descriptor = this.getImageDescriptor("show-all-bundles");
        action.setImageDescriptor(descriptor);
        IBundleDependencyModel model = this.getModel();
        boolean showAllBundles = model.getShowAllBundles();
        action.setChecked(showAllBundles);
        return action;
    }

    private ViewerSorter createViewerSorterByBundleId() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object element1, Object element2) {
                int id2;
                int id1 = this.getBundleId(element1);
                int result = id1 < (id2 = this.getBundleId(element2)) ? -1 : (id1 == id2 ? 0 : 1);
                return result;
            }

            private int getBundleId(Object element) {
                String value = (String)element;
                int start = value.indexOf(91) + 1;
                if (start == -1) {
                    return 0;
                }
                int stop = value.indexOf(93, start);
                if (stop == -1) {
                    return 0;
                }
                String idValue = value.substring(start, stop);
                int id = Integer.parseInt(idValue);
                return id;
            }
        };
    }

    private ViewerSorter createViewerSorterByName() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object element1, Object element2) {
                String string1 = (String)element1;
                String string2 = (String)element2;
                return string1.compareTo(string2);
            }
        };
    }

    private void disableOpenBrowserAction() {
        IAction action = this.getOpenBrowserAction();
        action.setEnabled(false);
    }

    private void displayInstallDependencyServletReminder() {
        IBundleDependencyPreferences preferences = this.getPreferences();
        boolean doNotRemindMe = preferences.getDoNotRemindMeToInstallDependencyServlet();
        if (doNotRemindMe) {
            return;
        }
        IBundleDependencyModel model = this.getModel();
        boolean polling = model.isPolling();
        if (polling) {
            return;
        }
        Runnable runnable = this.createReminderRunnable();
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        display.asyncExec(runnable);
    }

    public void dispose() {
        IBundleDependencyModel model = this.getModel();
        model.stopPolling();
        BundleDependencyModelListener modelListener = this.getModelListener();
        model.removeBundleDependencyModelListener(modelListener);
        this.setModel(null);
        this.setModelListener(null);
        this.setSashForm(null);
        this.setPrerequisiteBundlesTableViewer(null);
        this.setInstalledBundlesTableViewer(null);
        this.setDependentBundlesTableViewer(null);
        this.setLabelProvider(null);
        this.setOrientationLockAction(null);
        this.setToggleOrientationAction(null);
        this.setTogglePollingAction(null);
        this.setToggleShowAllBundlesAction(null);
        this.setRefreshRunnable(null);
        this.disposeBusyCursor();
        super.dispose();
    }

    private void disposeBusyCursor() {
        Cursor cursor = this.basicGetBusyCursor();
        if (cursor == null) {
            return;
        }
        cursor.dispose();
        this.setBusyCursor(null);
    }

    private void enableOpenBrowserAction() {
        IAction action = this.getOpenBrowserAction();
        action.setEnabled(true);
    }

    private int findIndexOfBundleInTable(String bundle, Table table) {
        TableItem[] items = table.getItems();
        int count = items.length;
        boolean found = false;
        int index = 0;
        while (!found && index < count) {
            TableItem item = items[index];
            String text = this.getBundleNameFromTableItem(item);
            found = text.equals(bundle);
            ++index;
        }
        index = found ? index - 1 : -1;
        return index;
    }

    private IActionBars getActionBars() {
        IViewSite site = this.getViewSite();
        IActionBars actionBars = site.getActionBars();
        return actionBars;
    }

    private String getBundleNameFromTableItem(TableItem item) {
        return item.getText(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor getBusyCursor() {
        Cursor cursor;
        BundleDependencyView bundleDependencyView = this;
        synchronized (bundleDependencyView) {
            cursor = this.basicGetBusyCursor();
            if (cursor == null) {
                cursor = this.createBusyCursor();
                this.setBusyCursor(cursor);
            }
        }
        return cursor;
    }

    private Control getControlWithFocus() {
        UiUtility utility = UiUtility.getInstance();
        Composite parent = this.getParent();
        Control result = utility.getControlWithFocus((Control)parent);
        return result;
    }

    private Image getCopyImage() {
        return this.getImage("copy");
    }

    private TableViewer getDependentBundlesTableViewer() {
        return this.dependentBundlesTableViewer;
    }

    private Image getImage(String name) {
        Activator activator = Activator.getDefault();
        Image image = activator.getImage(name);
        return image;
    }

    private ImageDescriptor getImageDescriptor(String filename) {
        Activator activator = Activator.getDefault();
        ImageDescriptor descriptor = activator.getImageDescriptor(filename);
        return descriptor;
    }

    private TableViewer getInstalledBundlesTableViewer() {
        return this.installedBundlesTableViewer;
    }

    private ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAction getLockOrientationAction() {
        BundleDependencyView bundleDependencyView = this;
        synchronized (bundleDependencyView) {
            if (this.orientationLockAction == null) {
                IAction action = this.createOrientationLockAction();
                this.setOrientationLockAction(action);
            }
        }
        return this.orientationLockAction;
    }

    private Image getManifestImage() {
        return this.getImage("manifest");
    }

    private IMemento getMemento() {
        return this.memento;
    }

    private IMenuManager getMenuManager() {
        IViewSite site = this.getViewSite();
        IActionBars bars = site.getActionBars();
        IMenuManager manager = bars.getMenuManager();
        return manager;
    }

    private IBundleDependencyModel getModel() {
        return this.model;
    }

    private BundleDependencyModelListener getModelListener() {
        return this.modelListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAction getOpenBrowserAction() {
        BundleDependencyView bundleDependencyView = this;
        synchronized (bundleDependencyView) {
            if (this.openBrowserAction == null) {
                IAction action = this.createOpenBrowserAction();
                this.setOpenBrowserAction(action);
            }
        }
        return this.openBrowserAction;
    }

    private Composite getParent() {
        return this.parent;
    }

    private IBundleDependencyPreferences getPreferences() {
        org.eclipse.soda.sat.plugin.dependency.bundle.Activator activator = org.eclipse.soda.sat.plugin.dependency.bundle.Activator.getDefault();
        IBundleDependencyPreferences preferences = activator.getPreferences();
        return preferences;
    }

    private TableViewer getPrerequisiteBundlesTableViewer() {
        return this.prerequisiteBundlesTableViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getRefreshRunnable() {
        BundleDependencyView bundleDependencyView = this;
        synchronized (bundleDependencyView) {
            if (this.refreshRunnable == null) {
                this.setRefreshRunnable(this.createRefreshRunnable());
            }
        }
        return this.refreshRunnable;
    }

    private SashForm getSashForm() {
        return this.sashForm;
    }

    private int getSashFormOrientation() {
        SashForm sashForm = this.getSashForm();
        int orientation = sashForm.getOrientation();
        return orientation;
    }

    private String getSelectedBundle(TableViewer viewer) {
        String bundle = null;
        Table table = viewer.getTable();
        int index = table.getSelectionIndex();
        if (index != -1) {
            TableItem item = table.getItem(index);
            bundle = item.getText();
        }
        return bundle;
    }

    private String[] getSelectedBundles(Table table) {
        TableItem[] items = table.getSelection();
        int size = items.length;
        String[] bundles = new String[size];
        int i = 0;
        while (i < size) {
            String bundle;
            TableItem item = items[i];
            bundles[i] = bundle = item.getText();
            ++i;
        }
        return bundles;
    }

    private String[] getSelectedInstalledBundles() {
        TableViewer viewer = this.getInstalledBundlesTableViewer();
        Table table = viewer.getTable();
        String[] bundles = this.getSelectedBundles(table);
        return bundles;
    }

    private Shell getShell() {
        Composite composite = this.getParent();
        Shell shell = composite.getShell();
        return shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAction getToggleOrientationAction() {
        BundleDependencyView bundleDependencyView = this;
        synchronized (bundleDependencyView) {
            if (this.toggleOrientationAction == null) {
                IAction action = this.createToggleOrientationAction();
                this.setToggleOrientationAction(action);
                this.updateToggleOrientationAction();
            }
        }
        return this.toggleOrientationAction;
    }

    private IAction getTogglePollingAction() {
        return this.togglePollingAction;
    }

    private IAction getToggleShowAllBundlesAction() {
        return this.toggleShowAllBundlesAction;
    }

    private IToolBarManager getToolBarManager() {
        IViewSite site = this.getViewSite();
        IActionBars bars = site.getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        return manager;
    }

    protected void handleConfigure() {
        IBundleDependencyModel model;
        Shell shell = this.getShell();
        BundleDependencyViewConfigurationDialog dialog = new BundleDependencyViewConfigurationDialog(shell, model = this.getModel());
        int result = dialog.open();
        if (result == 0) {
            this.disableOpenBrowserAction();
            this.updateTitle();
            this.refresh();
        }
    }

    private void handleCopyToClipboard(String[] items) {
        UiUtility utility = UiUtility.getInstance();
        utility.copyToClipboard(items);
    }

    private void handleGlobalCopyToClipboard() {
        Table table = (Table)this.getControlWithFocus();
        if (table == null) {
            return;
        }
        String[] bundles = this.getSelectedBundles(table);
        this.handleCopyToClipboard(bundles);
    }

    private void handleGlobalSelectAll() {
        Table table = (Table)this.getControlWithFocus();
        if (table == null) {
            return;
        }
        this.handleSelectAll(table);
    }

    private void handleInstalledBundleSelected() {
        String[] bundles = this.getSelectedInstalledBundles();
        int length = bundles.length;
        if (length == 0) {
            return;
        }
        IBundleDependencyModel model = this.getModel();
        TreeSet<String> prerequisiteBundles = new TreeSet<String>();
        TreeSet<String> dependentBundles = new TreeSet<String>();
        int i = 0;
        while (i < length) {
            String bundle = bundles[i];
            boolean exists = model.isBundle(bundle);
            if (exists) {
                List list = model.getPrerequisitesOf(bundle);
                prerequisiteBundles.addAll(list);
                list = model.getDependentsOf(bundle);
                dependentBundles.addAll(list);
            }
            ++i;
        }
        TableViewer prerequisiteBundlesTableViewer = this.getPrerequisiteBundlesTableViewer();
        this.populateTable(prerequisiteBundlesTableViewer, prerequisiteBundles);
        TableViewer dependentBundlesTableViewer = this.getDependentBundlesTableViewer();
        this.populateTable(dependentBundlesTableViewer, dependentBundles);
    }

    private void handleLockOrientation() {
        IAction action = this.getLockOrientationAction();
        boolean locked = action.isChecked();
        this.setOrientationLocked(locked);
        if (locked) {
            return;
        }
        this.layout();
    }

    private void handleOpenBrowser() {
        String url = this.createBrowserUrl();
        UiUtility utility = UiUtility.getInstance();
        utility.openBrowser(url);
    }

    private void handleRefresh() {
        this.refresh();
    }

    private void handleSelectAll(Table table) {
        table.selectAll();
        TableViewer viewer = this.getInstalledBundlesTableViewer();
        Table installedBundlesTable = viewer.getTable();
        if (installedBundlesTable != table) {
            return;
        }
        this.handleInstalledBundleSelected();
    }

    private void handleTableMenuShownEvent(Table table) {
        Menu menu = table.getMenu();
        this.removeAllMenuItems(menu);
        this.addViewManifestMenuItem(table, menu);
        this.addCopyMenuItem(table, menu);
        this.addSelectAllMenuItem(table, menu);
    }

    private void handleTableResized(Table table) {
        Rectangle area = table.getClientArea();
        int border = table.getBorderWidth();
        int width = area.width - border * 2;
        if (width == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        column.setWidth(width);
    }

    private void handleTableViewerMouseDoubleClickEvent(TableViewer viewer) {
        TableViewer installedBundlesTableViewer;
        Table installedBundlesTable;
        int index;
        String bundle = this.getSelectedBundle(viewer);
        if (bundle == null) {
            return;
        }
        int end = bundle.indexOf(42);
        if (end != -1) {
            bundle = bundle.substring(0, end);
        }
        if ((index = this.findIndexOfBundleInTable(bundle, installedBundlesTable = (installedBundlesTableViewer = this.getInstalledBundlesTableViewer()).getTable())) == -1) {
            return;
        }
        installedBundlesTable.setSelection(index);
        this.handleInstalledBundleSelected();
    }

    private void handleToggleOrientation() {
        SashForm sashForm = this.getSashForm();
        int orientation = sashForm.getOrientation();
        int value = orientation == 256 ? 512 : 256;
        this.setOrientation(value);
    }

    private void handleTogglePolling() {
        IBundleDependencyModel model = this.getModel();
        model.togglePolling();
    }

    private void handleToggleShowAllBundles() {
        IBundleDependencyModel model = this.getModel();
        model.toggleAllBundles();
        this.handleRefresh();
    }

    private void handleViewManifest(String item) {
        IBundleDependencyModel model = this.getModel();
        String manifest = model.getManifest(item);
        this.openManifestDialog(item, manifest);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.setMemento(memento);
        IBundleDependencyModel model = this.getModel();
        BundleDependencyModelListener modelListener = this.getModelListener();
        model.addBundleDependencyModelListener(modelListener);
    }

    private boolean isLocalhost() {
        IBundleDependencyModel model = this.getModel();
        String host = model.getHost();
        boolean local = host.equals("localhost");
        if (local) {
            return true;
        }
        local = host.equals("127.0.0.1");
        if (local) {
            return true;
        }
        try {
            InetAddress hostAddress = InetAddress.getByName(host);
            InetAddress localhost = InetAddress.getLocalHost();
            local = localhost.equals(hostAddress);
            if (local) {
                return true;
            }
        }
        catch (UnknownHostException exception) {
            this.log(4, exception);
        }
        return false;
    }

    private boolean isOrientationLocked() {
        return this.orientationLocked;
    }

    private void layout() {
        boolean locked = this.isOrientationLocked();
        if (locked) {
            return;
        }
        this.layoutSashForm();
    }

    private void layoutSashForm() {
        SashForm sashForm = this.getSashForm();
        Rectangle rectangle = sashForm.getBounds();
        int width = rectangle.width;
        int height = rectangle.height;
        int orientation = width > height ? 256 : 512;
        this.setOrientation(orientation);
    }

    private void loadOrientationLockedStateFromMemento() {
        IMemento memento = this.getMemento();
        String value = memento.getString(MEMENTO_KEY_ORIENTATION_LOCKED);
        Boolean wrapper = Boolean.valueOf(value);
        boolean state = wrapper;
        this.setOrientationLocked(state);
        IAction action = this.getLockOrientationAction();
        action.setChecked(state);
    }

    private void loadOrientationStateFromMemento() {
        IMemento memento = this.getMemento();
        String orientationValue = memento.getString(MEMENTO_KEY_ORIENTATION);
        int orientation = orientationValue != null && orientationValue.equals(MEMENTO_VALUE_ORIENTATION_HORIZONTAL) ? 256 : 512;
        this.setOrientation(orientation);
    }

    private void loadPollingFromMemento() {
        IMemento memento = this.getMemento();
        String value = memento.getString(MEMENTO_KEY_POLLING);
        Boolean wrapper = Boolean.valueOf(value);
        boolean state = wrapper;
        IBundleDependencyModel model = this.getModel();
        if (state) {
            model.startPolling();
        } else {
            model.stopPolling();
        }
    }

    private void loadShowAllBundlesFromMemento() {
        IMemento memento = this.getMemento();
        String value = memento.getString(MEMENTO_KEY_SHOW_ALL_BUNDLES);
        Boolean wrapper = Boolean.valueOf(value);
        boolean state = wrapper;
        IBundleDependencyModel model = this.getModel();
        model.setShowAllBundles(state);
    }

    private void loadStateFromMemento() {
        IMemento memento = this.getMemento();
        if (memento == null) {
            return;
        }
        this.loadShowAllBundlesFromMemento();
        this.loadPollingFromMemento();
        this.loadOrientationStateFromMemento();
        this.loadOrientationLockedStateFromMemento();
        this.setMemento(null);
    }

    private void log(int severity, Throwable throwable) {
        Activator activator = Activator.getDefault();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String message = clazz.getName();
        activator.log(severity, message, throwable);
    }

    private void openManifestDialog(String item, String manifest) {
        String pattern = Messages.getString(MANIFEST_FOR_DIALOG_TITLE_KEY);
        String title = MessageFormat.format(pattern, item);
        FactoryUtility utility = FactoryUtility.getInstance();
        Shell shell = this.getShell();
        IHandyTextDialog dialog = utility.createHandyTextDialog(shell);
        dialog.setText(manifest);
        dialog.setTitle(title);
        dialog.setTextControlStyle(266);
        dialog.setSize(650, 450);
        dialog.open();
    }

    private void openReminderDialog() {
        Shell shell = this.getShell();
        String message = this.createReminderMessage();
        String title = Messages.getString(REMINDER_DIALOG_TITLE_KEY);
        FactoryUtility utility = FactoryUtility.getInstance();
        IHandyPromptDialog dialog = utility.createHandyPromptDialog(shell, message);
        dialog.setTitle(title);
        dialog.setYesButtonText(null);
        dialog.setNoButtonText(null);
        dialog.setCancelButtonText(String.valueOf('&') + IDialogConstants.OK_LABEL);
        dialog.useWarningIcon();
        dialog.setHelpContextId("org.eclipse.soda.sat.plugin.dependency.ui.dependencies");
        String doNotRemindMeAgain = Messages.getString(DO_NOT_REMIND_ME_AGAIN_KEY);
        int id = dialog.addCheckbox(doNotRemindMeAgain, false);
        dialog.open();
        boolean selected = dialog.isCheckboxSelected(id);
        if (!selected) {
            return;
        }
        IBundleDependencyPreferences preferences = this.getPreferences();
        preferences.setDoNotRemindMeToInstallDependencyServlet(true);
        preferences.save();
    }

    private void populateTable(TableViewer table, Collection<String> bundles) {
        if (bundles == null) {
            return;
        }
        int size = bundles.size();
        String[] bundleNames = new String[size];
        bundles.toArray(bundleNames);
        table.setInput(bundles);
    }

    private void refresh() {
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        Cursor cursor = this.getBusyCursor();
        try {
            int count;
            shell.setCursor(cursor);
            TableViewer installBundlesTableViewer = this.getInstalledBundlesTableViewer();
            Table installedBundlesTable = installBundlesTableViewer.getTable();
            String bundle = null;
            int index = installedBundlesTable.getSelectionIndex();
            if (index != -1) {
                TableItem item = installedBundlesTable.getItem(index);
                bundle = this.getBundleNameFromTableItem(item);
            }
            IBundleDependencyModel model = this.getModel();
            List bundles = model.getBundles();
            this.populateTable(installBundlesTableViewer, bundles);
            TableViewer viewer = this.getPrerequisiteBundlesTableViewer();
            Table table = viewer.getTable();
            table.removeAll();
            viewer = this.getDependentBundlesTableViewer();
            table = viewer.getTable();
            table.removeAll();
            int size = bundles.size();
            if (size > 0) {
                index = bundle != null ? this.findIndexOfBundleInTable(bundle, installedBundlesTable) : 0;
                installedBundlesTable.setSelection(index);
                this.handleInstalledBundleSelected();
            }
            if ((count = (table = (viewer = this.getInstalledBundlesTableViewer()).getTable()).getItemCount()) == 0) {
                this.disableOpenBrowserAction();
                this.displayInstallDependencyServletReminder();
            } else {
                this.enableOpenBrowserAction();
            }
        }
        finally {
            shell.setCursor(null);
        }
    }

    private void removeAllMenuItems(Menu menu) {
        MenuItem[] items = menu.getItems();
        int count = items.length;
        int i = 0;
        while (i < count) {
            MenuItem menuItem = items[i];
            menuItem.dispose();
            ++i;
        }
    }

    private void saveOrientationLockedStateToMemento(IMemento memento) {
        boolean orientationLocked = this.isOrientationLocked();
        String value = String.valueOf(orientationLocked);
        memento.putString(MEMENTO_KEY_ORIENTATION_LOCKED, value);
    }

    private void saveOrientationStateToMemento(IMemento memento) {
        int orientation = this.getSashFormOrientation();
        String orientationValue = orientation == 256 ? MEMENTO_VALUE_ORIENTATION_HORIZONTAL : MEMENTO_VALUE_ORIENTATION_VERTICAL;
        memento.putString(MEMENTO_KEY_ORIENTATION, orientationValue);
    }

    private void savePollingStateToMemento(IMemento memento) {
        IBundleDependencyModel model = this.getModel();
        boolean polling = model.isPolling();
        String value = String.valueOf(polling);
        memento.putString(MEMENTO_KEY_POLLING, value);
    }

    private void saveShowAllBundlesStateToMemento(IMemento memento) {
        IBundleDependencyModel model = this.getModel();
        boolean showAllBundles = model.getShowAllBundles();
        String value = String.valueOf(showAllBundles);
        memento.putString(MEMENTO_KEY_SHOW_ALL_BUNDLES, value);
    }

    public void saveState(IMemento memento) {
        this.saveShowAllBundlesStateToMemento(memento);
        this.savePollingStateToMemento(memento);
        this.saveOrientationStateToMemento(memento);
        this.saveOrientationLockedStateToMemento(memento);
    }

    private void setBusyCursor(Cursor busyCursor) {
        this.busyCursor = busyCursor;
    }

    private void setDependentBundlesTableViewer(TableViewer dependentsTableViewer) {
        this.dependentBundlesTableViewer = dependentsTableViewer;
    }

    public void setFocus() {
        TableViewer viewer = this.getInstalledBundlesTableViewer();
        Table table = viewer.getTable();
        table.setFocus();
    }

    private void setInstalledBundlesTableViewer(TableViewer installedBundlesTableViewer) {
        this.installedBundlesTableViewer = installedBundlesTableViewer;
    }

    private void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    private void setMemento(IMemento memento) {
        this.memento = memento;
    }

    private void setModel(IBundleDependencyModel model) {
        this.model = model;
    }

    private void setModelListener(BundleDependencyModelListener modelListener) {
        this.modelListener = modelListener;
    }

    private void setOpenBrowserAction(IAction openBrowserAction) {
        this.openBrowserAction = openBrowserAction;
    }

    public void setOrientation(int orientation) {
        SashForm sashForm = this.getSashForm();
        int currentOrientation = sashForm.getOrientation();
        if (currentOrientation == orientation) {
            return;
        }
        sashForm.setOrientation(orientation);
        this.updateToggleOrientationAction();
    }

    private void setOrientationLockAction(IAction orientationLockAction) {
        this.orientationLockAction = orientationLockAction;
    }

    private void setOrientationLocked(boolean orientationLocked) {
        this.orientationLocked = orientationLocked;
    }

    private void setParent(Composite parent) {
        this.parent = parent;
    }

    private void setPrerequisiteBundlesTableViewer(TableViewer prerequisiteBundlesTableViewer) {
        this.prerequisiteBundlesTableViewer = prerequisiteBundlesTableViewer;
    }

    private void setRefreshRunnable(Runnable refreshRunnable) {
        this.refreshRunnable = refreshRunnable;
    }

    private void setSashForm(SashForm sashForm) {
        this.sashForm = sashForm;
    }

    private void setSashFormLayoutProportions() {
        SashForm form = this.getSashForm();
        int[] weights = new int[]{33, 34, 33};
        form.setWeights(weights);
    }

    private void setTableColumnSelectionListener(final TableViewer viewer, TableColumn column) {
        final ViewerSorter viewerSorterByBundleId = this.createViewerSorterByBundleId();
        final ViewerSorter viewerSorterByName = this.createViewerSorterByName();
        viewer.setSorter(viewerSorterByBundleId);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ViewerSorter currentSorter = viewer.getSorter();
                ViewerSorter sorter = currentSorter == viewerSorterByBundleId ? viewerSorterByName : viewerSorterByBundleId;
                viewer.setSorter(sorter);
            }
        };
        column.addSelectionListener((SelectionListener)listener);
    }

    private void setToggleOrientationAction(IAction toggleViewOrientationAction) {
        this.toggleOrientationAction = toggleViewOrientationAction;
    }

    private void setTogglePollingAction(IAction togglePollingAction) {
        this.togglePollingAction = togglePollingAction;
    }

    private void setToggleShowAllBundlesAction(IAction toggleShowAllBundlesAction) {
        this.toggleShowAllBundlesAction = toggleShowAllBundlesAction;
    }

    private void updateBundleDependencies() {
        Display display = Display.getDefault();
        Runnable runnable = this.getRefreshRunnable();
        display.asyncExec(runnable);
    }

    private void updatePollAction() {
        IBundleDependencyModel model = this.getModel();
        boolean state = model.isPolling();
        IAction action = this.getTogglePollingAction();
        action.setChecked(state);
    }

    private void updateShowAllBundlesAction() {
        IBundleDependencyModel model = this.getModel();
        boolean state = model.getShowAllBundles();
        IAction action = this.getToggleShowAllBundlesAction();
        action.setChecked(state);
    }

    private void updateTitle() {
        IBundleDependencyModel model = this.getModel();
        String host = model.getHost();
        String port = model.getPort();
        String servletAlias = model.getServletAlias();
        StringBuffer buffer = new StringBuffer(65);
        if (host != null) {
            buffer.append(' ');
            buffer.append('[');
            buffer.append(host);
            buffer.append(':');
            buffer.append(port);
            buffer.append(servletAlias);
            buffer.append(']');
        }
        String title = buffer.toString();
        this.setContentDescription(title);
    }

    private void updateToggleOrientationAction() {
        int orientation = this.getSashFormOrientation();
        String labelKey = null;
        String imageName = null;
        if (orientation == 256) {
            labelKey = HORIZONTAL_ORIENTATION_KEY;
            imageName = MEMENTO_VALUE_ORIENTATION_HORIZONTAL;
        } else if (orientation == 512) {
            labelKey = VERTICAL_ORIENTATION_KEY;
            imageName = MEMENTO_VALUE_ORIENTATION_VERTICAL;
        }
        if (labelKey == null || imageName == null) {
            return;
        }
        IAction action = this.getToggleOrientationAction();
        String label = Messages.getString(labelKey);
        action.setText(label);
        action.setToolTipText(label);
        ImageDescriptor descriptor = this.getImageDescriptor(imageName);
        action.setImageDescriptor(descriptor);
    }
}

