/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.soda.sat.plugin.dependency.BundleDependencyModelListener;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyModel;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.bundle.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDependencyModel
implements IBundleDependencyModel {
    private static final String GET_ALL_DEPENDENTS_OF_QUERY = "getAllDependentsOf";
    private static final String GET_ALL_PREREQUISITES_OF_QUERY = "getAllPrerequisitesOf";
    private static final String GET_BUNDLES_QUERY = "getBundles";
    private static final String GET_DEPENDENTS_OF_QUERY = "getDependentsOf";
    private static final String GET_MANIFEST_QUERY = "getManifest";
    private static final String GET_PREREQUISITES_OF_QUERY = "getPrerequisitesOf";
    private static final String GET_SERVICES_EXPORTED_BY_QUERY = "getServicesExportedBy";
    private static final String GET_SERVICES_IMPORTED_BY_QUERY = "getServicesImportedBy";
    private static final String GET_STATE_QUERY = "getState";
    private static final String IS_BUNDLE_QUERY = "isBundle";
    private static final String IS_EXPORTING_SERVICES_QUERY = "isExportingServices";
    private static final String IS_IMPORTING_SERVICES_QUERY = "isImportingServices";
    private static final String ACTION_PARAMETER = "action";
    private static final String BUNDLE_PARAMETER = "bundle";
    private StringBuffer buffer;
    private String host;
    private List<BundleDependencyModelListener> listeners;
    private String pollFrequency;
    private Thread pollingThread;
    private String port;
    private String servletAlias;
    private boolean showAllBundles;

    public BundleDependencyModel() {
        this.setListeners(new ArrayList<BundleDependencyModelListener>(5));
        this.applyPreferences();
    }

    @Override
    public void addBundleDependencyModelListener(BundleDependencyModelListener listener) {
        List<BundleDependencyModelListener> listeners = this.getListeners();
        boolean exists = listeners.contains(listener);
        if (exists) {
            return;
        }
        listeners.add(listener);
    }

    private void applyPreferences() {
        IBundleDependencyPreferences preferences = this.getPreferences();
        String host = preferences.getHost();
        this.setHost(host);
        String port = preferences.getPort();
        this.setPort(port);
        String servletAlias = preferences.getServletAlias();
        this.setServletAlias(servletAlias);
        String pollFrequency = preferences.getPollFrequency();
        this.setPollFrequency(pollFrequency);
        boolean showAllBundles = preferences.getShowAllBundles();
        this.setShowAllBundles(showAllBundles);
    }

    private Runnable createPollingRunnable() {
        return new Runnable(){

            private void delay() {
                String pollFrequency = BundleDependencyModel.this.getPollFrequency();
                long seconds = Long.parseLong(pollFrequency);
                try {
                    Thread.sleep(seconds * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }

            public void run() {
                while (BundleDependencyModel.this.isPolling()) {
                    BundleDependencyModel.this.poll();
                    this.delay();
                }
            }
        };
    }

    private Thread createPollingThread() {
        Runnable runnable = this.createPollingRunnable();
        return new Thread(runnable, "BundleDependencyModel-Polling");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createQuery(String action, String bundle) {
        String host = this.getHost();
        String port = this.getPort();
        String servletAlias = this.getServletAlias();
        StringBuffer buffer = this.getBuffer();
        String query = null;
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            buffer.append("http://");
            buffer.append(host);
            buffer.append(':');
            buffer.append(port);
            buffer.append(servletAlias);
            buffer.append('?');
            buffer.append(ACTION_PARAMETER);
            buffer.append('=');
            buffer.append(action);
            if (bundle != null) {
                buffer.append('&');
                buffer.append(BUNDLE_PARAMETER);
                buffer.append('=');
                buffer.append(bundle);
            }
            query = buffer.toString();
            buffer.setLength(0);
        }
        return query;
    }

    private String drain(InputStream stream) throws IOException {
        int size = 1024;
        StringBuffer buffer = new StringBuffer(size);
        Reader reader = null;
        try {
            int length;
            reader = new InputStreamReader(stream);
            reader = new BufferedReader(reader);
            char[] chars = new char[size];
            while ((length = reader.read(chars)) != -1) {
                buffer.append(chars, 0, length);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        String result = buffer.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getBuffer() {
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            if (this.buffer == null) {
                this.setBuffer(new StringBuffer(200));
            }
        }
        return this.buffer;
    }

    @Override
    public List<String> getBundles() {
        List<String> bundles = this.performServletListQuery(GET_BUNDLES_QUERY, null);
        return bundles;
    }

    @Override
    public List<String> getDependentsOf(String name) {
        boolean all = this.getShowAllBundles();
        String query = all ? GET_ALL_DEPENDENTS_OF_QUERY : GET_DEPENDENTS_OF_QUERY;
        List<String> bundles = this.performServletListQuery(query, name);
        return bundles;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    private List<BundleDependencyModelListener> getListeners() {
        return this.listeners;
    }

    @Override
    public String getManifest(String name) {
        String value = this.performServletQuery(GET_MANIFEST_QUERY, name);
        return value;
    }

    @Override
    public String getPollFrequency() {
        return this.pollFrequency;
    }

    private Thread getPollingThread() {
        return this.pollingThread;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    private IBundleDependencyPreferences getPreferences() {
        Activator activator = Activator.getDefault();
        IBundleDependencyPreferences preferences = activator.getPreferences();
        return preferences;
    }

    @Override
    public List<String> getPrerequisitesOf(String name) {
        boolean all = this.getShowAllBundles();
        String query = all ? GET_ALL_PREREQUISITES_OF_QUERY : GET_PREREQUISITES_OF_QUERY;
        List<String> bundles = this.performServletListQuery(query, name);
        return bundles;
    }

    @Override
    public List<String> getServicesExportedBy(String name) {
        List<String> services = this.performServletListQuery(GET_SERVICES_EXPORTED_BY_QUERY, name);
        return services;
    }

    @Override
    public List<String> getServicesImportedBy(String name) {
        List<String> services = this.performServletListQuery(GET_SERVICES_IMPORTED_BY_QUERY, name);
        return services;
    }

    @Override
    public String getServletAlias() {
        return this.servletAlias;
    }

    @Override
    public boolean getShowAllBundles() {
        return this.showAllBundles;
    }

    @Override
    public int getState(String name) {
        int result = this.performServletIntegerQuery(GET_STATE_QUERY, name);
        return result;
    }

    @Override
    public boolean isBundle(String name) {
        boolean result = this.performServletBooleanQuery(IS_BUNDLE_QUERY, name);
        return result;
    }

    @Override
    public boolean isExportingServices(String name) {
        boolean result = this.performServletBooleanQuery(IS_EXPORTING_SERVICES_QUERY, name);
        return result;
    }

    @Override
    public boolean isImportingServices(String name) {
        boolean result = this.performServletBooleanQuery(IS_IMPORTING_SERVICES_QUERY, name);
        return result;
    }

    @Override
    public boolean isPolling() {
        Thread pollingThread = this.getPollingThread();
        boolean polling = pollingThread != null;
        return polling;
    }

    private boolean performServletBooleanQuery(String action, String bundle) {
        String text = this.performServletQuery(action, bundle);
        Boolean wrapper = Boolean.valueOf(text);
        boolean result = wrapper;
        return result;
    }

    private int performServletIntegerQuery(String action, String bundle) {
        String text = this.performServletQuery(action, bundle);
        Integer wrapper = Integer.valueOf(text);
        int result = wrapper;
        return result;
    }

    private List<String> performServletListQuery(String action, String bundle) {
        String text = this.performServletQuery(action, bundle);
        List<String> bundles = this.tokenize(text);
        return bundles;
    }

    private String performServletQuery(String action, String bundle) {
        String query = this.createQuery(action, bundle);
        String line = null;
        try {
            URL url = new URL(query);
            InputStream stream = url.openStream();
            line = this.drain(stream);
        }
        catch (IOException iOException) {}
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        List<BundleDependencyModelListener> listeners = this.getListeners();
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            for (BundleDependencyModelListener listener : listeners) {
                listener.bundleDependenciesChanged();
            }
        }
    }

    @Override
    public void removeBundleDependencyModelListener(BundleDependencyModelListener listener) {
        List<BundleDependencyModelListener> listeners = this.getListeners();
        boolean exists = listeners.contains(listener);
        if (!exists) {
            return;
        }
        listeners.remove(listener);
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    private void setListeners(List<BundleDependencyModelListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void setPollFrequency(String pollingFrequency) {
        this.pollFrequency = pollingFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollingThread(Thread pollingThread) {
        if (this.pollingThread == pollingThread) {
            return;
        }
        this.pollingThread = pollingThread;
        List<BundleDependencyModelListener> listeners = this.getListeners();
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            for (BundleDependencyModelListener listener : listeners) {
                listener.pollingChanged();
            }
        }
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public void setServletAlias(String servletAlias) {
        this.servletAlias = servletAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShowAllBundles(boolean showAllBundles) {
        if (this.showAllBundles == showAllBundles) {
            return;
        }
        this.showAllBundles = showAllBundles;
        List<BundleDependencyModelListener> listeners = this.getListeners();
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            for (BundleDependencyModelListener listener : listeners) {
                listener.showAllBundlesChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPolling() {
        Thread thread = null;
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            boolean polling = this.isPolling();
            if (polling) {
                return;
            }
            thread = this.createPollingThread();
            this.setPollingThread(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPolling() {
        Thread thread = null;
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            boolean polling = this.isPolling();
            if (!polling) {
                return;
            }
            thread = this.getPollingThread();
            this.setPollingThread(null);
        }
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void toggleAllBundles() {
        boolean allBundles = this.getShowAllBundles();
        this.setShowAllBundles(!allBundles);
    }

    @Override
    public void togglePolling() {
        boolean polling = this.isPolling();
        if (!polling) {
            this.startPolling();
        } else {
            this.stopPolling();
        }
    }

    private List<String> tokenize(String value) {
        ArrayList<String> tokens = new ArrayList<String>(20);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                token = token.trim();
                tokens.add(token);
            }
        }
        tokens.trimToSize();
        return tokens;
    }
}

