/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormPage;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;

public class ExternalPage
extends DeviceKitFormPage {
    public ExternalPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = this.setup(managedForm, 3);
        DeviceKitTagModel dkFileModel = this.getTagModel();
        if (dkFileModel != null) {
            try {
                MainTagElement mainElement = dkFileModel.getMainElement();
                if (mainElement != null) {
                    int signalSize;
                    int measurementSize;
                    int mainType = mainElement.getTagCode();
                    List commandList = mainElement.getAllChildrenWithTagCodesAndId(new int[]{1, 19}, DeviceKitTagConstants.ALL_PARENT_CONTROLS);
                    List measurementList = mainElement.getAllChildrenWithTagCodesAndId(new int[]{2}, DeviceKitTagConstants.ALL_PARENT_CONTROLS);
                    List signalList = mainElement.getAllChildrenWithTagCodesAndId(new int[]{3}, DeviceKitTagConstants.ALL_PARENT_CONTROLS);
                    List dataList = mainElement.getAllChildrenWithTagCodesAndId(new int[]{76}, DeviceKitTagConstants.ALL_PARENT_CONTROLS);
                    int commandSize = commandList.size();
                    int size = commandSize + (measurementSize = measurementList.size()) + (signalSize = signalList.size());
                    if (size > 0 || 8 == mainType || 72 == mainType || 91 == mainType || 74 == mainType) {
                        Section commandsSection = this.createTagsSection(parent, commandList, "command");
                        SectionPart commandsPart = new SectionPart(commandsSection);
                        managedForm.addPart((IFormPart)commandsPart);
                        Section measurementsSection = this.createTagsSection(parent, measurementList, "measurement");
                        SectionPart measurementsPart = new SectionPart(measurementsSection);
                        managedForm.addPart((IFormPart)measurementsPart);
                        Section signalsSection = this.createTagsSection(parent, signalList, "signal");
                        SectionPart signalsPart = new SectionPart(signalsSection);
                        managedForm.addPart((IFormPart)signalsPart);
                    }
                    Section datasSection = this.createTagsSection(parent, dataList, "data");
                    SectionPart datasPart = new SectionPart(datasSection);
                    managedForm.addPart((IFormPart)datasPart);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

