/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.model.ant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.internal.model.ant.AntProperty;
import org.eclipse.soda.devicekit.generator.internal.model.ant.KeyPair;
import org.eclipse.soda.devicekit.generator.model.ant.IAntProperty;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;

public class AntTask
implements IAntTask {
    private List antElements;
    private String taskName;
    private List attributes;

    public AntTask(String taskName) {
        this.taskName = taskName;
        this.setElements(new ArrayList());
        this.setAttributes(new ArrayList());
    }

    public void addAttribute(String name, String value) {
        this.getAttributes().add(new KeyPair(name, value));
    }

    public IAntProperty createAntProperty(String name, String value) {
        AntProperty property = new AntProperty(name, value);
        this.getElements().add(property);
        return property;
    }

    public IAntTask createAntTask(String taskName) {
        AntTask task = new AntTask(taskName);
        this.getElements().add(task);
        return task;
    }

    public String getAttribute(String name) {
        int i = 0;
        while (i < this.getAttributes().size()) {
            KeyPair pair = (KeyPair)this.getAttributes().get(i);
            if (pair.getKey().equals(name)) {
                return pair.getValue();
            }
            ++i;
        }
        return null;
    }

    public String[] getAttributeNames() {
        String[] atts = new String[this.getAttributes().size()];
        int count = 0;
        int i = 0;
        while (i < this.getAttributes().size()) {
            KeyPair pair = (KeyPair)this.getAttributes().get(i);
            atts[count++] = pair.getKey();
            ++i;
        }
        return atts;
    }

    private List getAttributes() {
        return this.attributes;
    }

    public List getElements() {
        return this.antElements;
    }

    public int getElementType() {
        return 1;
    }

    public String getName() {
        return this.taskName;
    }

    private void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    private void setElements(List elements) {
        this.antElements = elements;
    }
}

