/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;

public class ConnectionModel {
    public static Map ConnectionMap = null;
    protected DeviceKitTagModel tagModel;
    static /* synthetic */ Class class$0;

    public ConnectionModel(DeviceKitTagModel tagModel) {
        this.setTagModel(tagModel);
    }

    public ConnectionModel(String type) {
        this(ConnectionModel.createTagModel(type));
    }

    public ConnectionModel(String type, String path) {
        this(ConnectionModel.createTagModel(type, path));
    }

    public static Map createConnectionMap() {
        Hashtable map;
        ConnectionMap = map = new Hashtable(101);
        ConnectionModel.updateConnectionMap("file");
        ConnectionModel.updateConnectionMap("randomaccessfile", "random.access.file");
        ConnectionModel.updateConnectionMap("serial");
        ConnectionModel.updateConnectionMap("tcpip");
        ConnectionModel.updateConnectionMap("tcpipserver", "tcpip.server");
        ConnectionModel.updateConnectionMap("tcpipmultiplex", "tcpip.multiplex");
        ConnectionModel.updateConnectionMap("tcpipservermultiplex", "tcpip.server.multiplex");
        ConnectionModel.updateConnectionMap("udp");
        ConnectionModel.updateConnectionMap("udpserver", "udp.server");
        ConnectionModel.updateConnectionMap("udpmultiplex", "udp.multiplex");
        ConnectionModel.updateConnectionMap("udpservermultiplex", "udp.server.multiplex");
        ConnectionModel.updateConnectionMap("url");
        return map;
    }

    protected static DeviceKitTagModel createTagModel(String type) {
        return ConnectionModel.createTagModel(type, type);
    }

    protected static DeviceKitTagModel createTagModel(String type, String path) {
        try {
            ArrayList references = new ArrayList();
            String pathFull = "org.eclipse.soda.dk." + path + ".connection";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.ConnectionModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream stream = clazz.getResource(String.valueOf(pathFull) + "/dk/connection.xml").openStream();
            DeviceKitTagModel deviceKitTagModel = new DeviceKitTagModel(stream, references);
            deviceKitTagModel.build(true);
            return deviceKitTagModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }

    public static ConnectionModel getConnection(String type) {
        return (ConnectionModel)ConnectionMap.get(type);
    }

    public static Map getConnectionMap() {
        if (ConnectionMap == null) {
            ConnectionMap = ConnectionModel.createConnectionMap();
        }
        return ConnectionMap;
    }

    public static String getValidMetaType(String type) {
        String ttype = type.toLowerCase();
        if (type.endsWith("[]")) {
            ttype = ttype.substring(0, ttype.length() - 2);
        }
        if ("string".equals(ttype)) {
            return "String";
        }
        if ("int".equals(ttype) || "integer".equals(ttype)) {
            return "Integer";
        }
        if ("boolean".equals(ttype) || "bool".equals(ttype)) {
            return "Boolean";
        }
        if ("char".equals(ttype) || "character".equals(ttype)) {
            return "Char";
        }
        if ("long".equals(ttype)) {
            return "Long";
        }
        if ("float".equals(ttype)) {
            return "Float";
        }
        if ("double".equals(ttype)) {
            return "Double";
        }
        if ("short".equals(ttype)) {
            return "Short";
        }
        if ("byte".equals(ttype)) {
            return "Byte";
        }
        if ("biginteger".equals(ttype)) {
            return "BigInteger";
        }
        if ("bigdecimal".equals(ttype)) {
            return "BigDecimal";
        }
        return type;
    }

    public static void main(String[] args) {
        ConnectionModel connectionModel = new ConnectionModel("serial");
        System.out.println(connectionModel);
    }

    public static void setConnectionMap(Map connectionMap) {
        ConnectionMap = connectionMap;
    }

    public static void updateConnectionMap(String type) {
        ConnectionMap.put(type, new ConnectionModel(type));
    }

    public static void updateConnectionMap(String type, String path) {
        ConnectionMap.put(type, new ConnectionModel(type, path));
    }

    public ConfigurationField[] getConfigurationFields() {
        try {
            DeviceKitTagModel deviceKitTagModel = this.getTagModel();
            MainTagElement mainElement = deviceKitTagModel.getMainElement();
            List list = mainElement.getAllChildrenWithTagCode(46);
            int size = list.size();
            ConfigurationField[] configurationFields = new ConfigurationField[size];
            int i = 0;
            while (i < size) {
                ConfigurationField configurationField;
                CustomParameterElement element = (CustomParameterElement)list.get(i);
                String name = element.getKey();
                String type = element.getValidMetaType();
                String value = element.getDefaultValue();
                configurationFields[i] = configurationField = new ConfigurationField(name, type, value);
                ++i;
            }
            return configurationFields;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ConfigurationField[0];
        }
    }

    public CustomParameterElement[] getCustomParameterElements() {
        try {
            DeviceKitTagModel deviceKitTagModel = this.getTagModel();
            MainTagElement mainElement = deviceKitTagModel.getMainElement();
            List list = mainElement.getAllChildrenWithTagCode(46);
            int size = list.size();
            CustomParameterElement[] customParametersElements = new CustomParameterElement[size];
            customParametersElements = list.toArray(customParametersElements);
            return customParametersElements;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new CustomParameterElement[0];
        }
    }

    public String getMetadataAttributes() {
        StringBuffer buffer = new StringBuffer(4096);
        try {
            CustomParameterElement[] list = this.getCustomParameterElements();
            int listSize = list.length;
            int i = 0;
            while (i < listSize) {
                CustomParameterElement element = list[i];
                String name = element.getKey();
                String key = name.toLowerCase();
                String displayName = element.getDisplayName();
                if (displayName != null && displayName.length() > 0) {
                    name = displayName;
                }
                buffer.append("\t\t<AD id=\"");
                buffer.append(key);
                buffer.append("\"\r\n");
                buffer.append("\t\t\tname=\"%");
                buffer.append(key);
                buffer.append("\"\r\n");
                String description = element.getDescription();
                if (description == null) {
                    description = "";
                }
                buffer.append("\t\t\tdescription=\"%");
                buffer.append(key);
                buffer.append("_description");
                buffer.append("\"\r\n");
                String type = element.getType();
                String validType = ConnectionModel.getValidMetaType(type);
                buffer.append("\t\t\ttype=\"");
                buffer.append(validType);
                buffer.append("\"\r\n");
                String cardinality = element.getCardinality();
                String size = element.getSize();
                String requiredValue = element.getRequired();
                String min = element.getMinimum();
                String max = element.getMaximum();
                String defaultValue = element.getDefaultValue();
                if (defaultValue != null) {
                    buffer.append("\t\t\tdefault=\"");
                    buffer.append(defaultValue);
                    buffer.append("\"\r\n");
                } else if (cardinality == null) {
                    buffer.append("\t\t\tdefault=\"\"\r\n");
                }
                if (cardinality != null) {
                    buffer.append("\t\t\tcardinality=\"");
                    if ("ARRAY".equals(cardinality)) {
                        if (size != null) {
                            buffer.append(size);
                        } else {
                            buffer.append(Integer.MAX_VALUE);
                        }
                    } else if (size != null) {
                        buffer.append('-');
                        buffer.append(size);
                    } else {
                        buffer.append(Integer.MIN_VALUE);
                    }
                    buffer.append("\"\r\n");
                } else {
                    buffer.append("\t\t\tcardinality=\"0\"\r\n");
                }
                if (min == null || min.length() > 0) {
                    buffer.append("\t\t\tmin=\"");
                    buffer.append(min);
                    buffer.append("\"\r\n");
                }
                if (max == null || max.length() > 0) {
                    buffer.append("\t\t\tmax=\"");
                    buffer.append(max);
                    buffer.append("\"\r\n");
                }
                buffer.append("\t\t\trequired=\"");
                if (requiredValue == null || requiredValue.length() == 0) {
                    buffer.append("false");
                } else {
                    buffer.append(requiredValue);
                }
                buffer.append('\"');
                boolean done = true;
                List enums = element.getAllChildrenWithTagCode(77);
                if (enums != null && enums.size() > 0) {
                    int j = 0;
                    while (j < enums.size()) {
                        EnumElement enumElement = (EnumElement)enums.get(j);
                        String enumKey = enumElement.getLabel();
                        String value = enumElement.getValue();
                        if (value == null) {
                            value = Integer.toString(j);
                        }
                        if (done) {
                            buffer.append(">\r\n");
                            done = false;
                        }
                        buffer.append("\t\t\t<Option value=\"");
                        buffer.append(value);
                        buffer.append("\" label=\"");
                        buffer.append(enumKey);
                        buffer.append("\"/>\r\n");
                        ++j;
                    }
                }
                if (done) {
                    buffer.append("/>\r\n");
                } else {
                    buffer.append("\t\t</AD>\r\n");
                }
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return buffer.toString();
    }

    public String getMetadataProperties() {
        StringBuffer buffer = new StringBuffer(4096);
        try {
            CustomParameterElement[] list = this.getCustomParameterElements();
            int listSize = list.length;
            int i = 0;
            while (i < listSize) {
                CustomParameterElement element = list[i];
                String name = element.getKey();
                String key = name.toLowerCase();
                String displayName = element.getDisplayName();
                if (displayName != null && displayName.length() > 0) {
                    name = displayName;
                }
                buffer.append(key);
                buffer.append('=');
                buffer.append(name);
                buffer.append('\r');
                buffer.append('\n');
                String description = element.getDescription();
                if (description == null) {
                    description = "";
                }
                buffer.append(key);
                buffer.append("_description");
                buffer.append('=');
                buffer.append(description);
                buffer.append('\r');
                buffer.append('\n');
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return buffer.toString();
    }

    public DeviceKitTagModel getTagModel() {
        return this.tagModel;
    }

    public void setTagModel(DeviceKitTagModel tagModel) {
        this.tagModel = tagModel;
    }
}

