/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkProfileGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkAgentGenerator
extends DkProfileGenerator {
    public DkAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_AGENT_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_AGENT_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_AGENT_BUNDLE_ACTIVATOR;
    }

    protected void initialize() {
        List services = this.getRootElement().getAllChildrenWithTagCode(91);
        AgentElement profile = (AgentElement)services.get(0);
        this.setDevice(profile);
        List devices = profile.getAllChildrenWithTagCode(8);
        if (devices.size() > 0) {
            TagElement device = (TagElement)devices.get(0);
            this.setTargetDevice(device);
        }
        this.setMainTagElement(profile);
        String className = DeviceKitUtilities.getClassNameFromTagElement(profile);
        this.setMainClassName(className);
        List adapters = this.getMainElement().getAllChildrenWithTagCode(72);
        if (adapters.size() > 0) {
            AdapterElement adapaterService = (AdapterElement)adapters.get(0);
            this.setTargetAdapter(adapaterService);
        }
        this.setPackageBase(profile.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (profile.getAttribute("lazy") == null || "false".equals(profile.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (profile.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = profile.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }
}

