/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkConnectionGenerator
extends DkDeviceGenerator {
    protected int bundleType = 0;

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected void codeBACreateService(IType ba) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE));
        String contents = this.getBACreateServiceContents();
        String[] comment = new String[]{"Creates the connection service using the specified property dictionary.", "", "@param dictionary The dictionary properties used to create the connection service.", "@return Object The connection service created by this bundle.", "@see " + this.getMainFqn()};
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage("java.util.Dictionary"), "dictionary");
        this.fBundleActivatorModel.addImport("java.util.Dictionary");
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeCommandsSignalsMeasurementsFields(IType device) {
    }

    protected void codeConstructors(IType device) throws IOException {
    }

    protected void codeDescriptionField(IType type, String fieldName) {
        super.codeDescriptionField(type, fieldName);
        String value = this.getConnectionType();
        this.codeField(type, "CONNECTION_TYPE", "String", 49L, "Define the connection type (String) constant.", this.quote(value));
    }

    protected void codeInitialize(IType device) {
    }

    protected void codeMethods(IType device) throws Exception {
    }

    protected void codeSetup(IType device) {
    }

    protected ConnectionElement findConnectionElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.get(i)).getTagCode()) {
                return (ConnectionElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void generateEscProperties() {
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.getMainElement().getType();
        this.fBundleActivatorModel.addImport(type);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append(" connection = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append("(dictionary);\n");
        buffer.append("return connection;\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_BA;
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected ConnectionElement getConnectionElement(TagElement parent) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.get(i)).getTagCode()) {
                return (ConnectionElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    public String getConnectionType() {
        ConnectionElement connectionElement = this.findConnectionElement();
        if (connectionElement != null) {
            return connectionElement.getConnectionType();
        }
        return null;
    }

    protected List getImportedServices() {
        return new ArrayList();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected List getManifestExportPackages() {
        List vector = super.getManifestExportPackages();
        vector.add(DeviceKitUtilities.extractPackage(this.getMainElement().getType()));
        vector.add(this.getServicePackage());
        return vector;
    }

    public Map getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE;
    }

    protected void initialize() {
        List connections = this.getRootElement().getAllChildrenWithTagCode(36);
        ConnectionElement connection = (ConnectionElement)connections.get(0);
        this.setDevice(connection);
        this.setMainTagElement(connection);
        String className = DeviceKitUtilities.getClassNameFromTagElement(connection);
        this.setMainClassName(className);
        this.setPackageBase(connection.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        this.setupExportedPackages();
        this.initializeGet();
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }

    public void setOtherManifestFiles(Map otherManifestFiles) {
        this.otherManifestFiles = otherManifestFiles;
    }
}

