/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.BytesGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public abstract class BlockElement
extends GeneralParameterElement {
    protected BlockElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getBytesCodeString() {
        if (this.getValueValue() == null) {
            return "";
        }
        BytesGenerator bytesGenerator = new BytesGenerator();
        this.updateBytes(bytesGenerator);
        StringBuffer buffer = new StringBuffer(1024);
        String comment = bytesGenerator.getCodeComment();
        if (comment.length() > 0) {
            buffer.append('\n');
            buffer.append(comment);
            buffer.append('\n');
        }
        buffer.append(bytesGenerator.getBytesCode());
        return buffer.toString();
    }

    public boolean isConstantParameter() {
        return true;
    }

    public void updateBytes(BytesGenerator bytesGenerator, boolean filterValid) {
        int length = this.getBitLengthValue(this.getLengthDefault());
        Object value = this.getValueValue();
        String comment = this.getId();
        if (comment == null && (comment = this.getIdRef()) == null) {
            comment = "";
        }
        if (value instanceof Double) {
            double doubleValue = ((Number)value).doubleValue();
            long longValue = Double.doubleToLongBits(doubleValue);
            bytesGenerator.add(length, longValue, true, comment);
        } else if (value instanceof Float) {
            float floatValue = ((Number)value).floatValue();
            long longValue = Float.floatToIntBits(floatValue);
            bytesGenerator.add(length, longValue, true, comment);
        } else if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            bytesGenerator.add(length, longValue, true, comment);
        } else {
            super.updateBytes(bytesGenerator, filterValid);
        }
    }
}

