/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public class CommandElement
extends ControlItem {
    public CommandElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        String implementation = this.getAttribute("implementation");
        boolean isCommandReceived = this.isCommandReceived(this);
        if (implementation != null) {
            return implementation;
        }
        if (this.hasChildWithTagCode(2)) {
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_MEASUREMENT;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_MEASUREMENT;
        }
        if (this.hasChildWithTagCode(5) || this.hasChildWithTagCode(23)) {
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_PARAMETER;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_PARAMETER;
        }
        if (this.hasTransformChild()) {
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_TRANSFORM;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_TRANSFORM;
        }
        if (this.hasChildWithTagCode(7)) {
            List messages = this.getAllChildrenWithTagCode(7);
            TagElement me = (TagElement)messages.get(0);
            if (me.hasChildWithTagCode(5) || me.hasChildWithTagCode(23)) {
                if (isCommandReceived) {
                    return DeviceKitGenerationConstants.CLASS_COMMAND_DATA;
                }
                return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_DATA;
            }
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_MESSAGE;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_MESSAGE;
        }
        if (this.hasMethodChild()) {
            return DeviceKitGenerationConstants.CLASS_METHOD_COMMAND;
        }
        return DeviceKitGenerationConstants.CLASS_COMMAND;
    }

    public String getFieldExtraComment(String fieldName) {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = TagElement.collection.getSignal(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        StringBuffer buffer = new StringBuffer(1024);
        if (realElement.getMessageChildren().size() > 0) {
            realElement.addFieldExtraCommentMessages(buffer, fieldName);
        } else {
            List list = realElement.getChildrenWithTagCode(1);
            if (list.size() == 1) {
                String field = this.getField();
                if (field != null && field.length() > 0) {
                    return ((TagElement)list.get(0)).getFieldExtraComment(field);
                }
                return ((TagElement)list.get(0)).getFieldExtraComment(fieldName);
            }
            List listMessage = realElement.getChildrenWithTagCode(7);
            if (listMessage.size() == 1) {
                String field = this.getField();
                if (field != null && field.length() > 0) {
                    return ((TagElement)listMessage.get(0)).getFieldExtraComment(field);
                }
                return ((TagElement)listMessage.get(0)).getFieldExtraComment(fieldName);
            }
            List listParameter = realElement.getChildrenWithTagCode(5);
            if (listParameter.size() == 1) {
                String field = this.getField();
                if (field != null && field.length() > 0) {
                    return ((TagElement)listParameter.get(0)).getFieldExtraComment(field);
                }
                return ((TagElement)listParameter.get(0)).getFieldExtraComment(fieldName);
            }
        }
        return buffer.toString();
    }

    public String getParameterDataType() {
        TagElement realElement = this.getRealElement();
        List messages = realElement.getMessageChildren();
        if (messages.size() > 0) {
            return ((TagElement)messages.get(0)).getParameterDataType();
        }
        List list = realElement.getChildrenWithTagCode(3);
        if (list.size() == 1) {
            TagElement fieldControl;
            String field = this.getField();
            if (field != null && field.length() > 0 && (fieldControl = ((TagElement)list.get(0)).lookupField(field)) != null) {
                return fieldControl.getParameterDataType();
            }
            return ((TagElement)list.get(0)).getParameterDataType();
        }
        return super.getParameterDataType();
    }

    public String getParameterDataTypeDocumentation() {
        TagElement realElement = this.getRealElement();
        List messages = realElement.getMessageChildren();
        if (messages.size() > 0) {
            return ((TagElement)messages.get(0)).getParameterDataTypeDocumentation();
        }
        List list = realElement.getChildrenWithTagCode(3);
        if (list.size() == 1) {
            TagElement fieldControl;
            String field = this.getField();
            if (field != null && field.length() > 0 && (fieldControl = ((TagElement)list.get(0)).lookupField(field)) != null) {
                return fieldControl.getParameterDataTypeDocumentation();
            }
            return ((TagElement)list.get(0)).getParameterDataTypeDocumentation();
        }
        return super.getParameterDataTypeDocumentation();
    }

    public TagElement getRealElement() {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = TagElement.collection.getCommand(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
                return realElement;
            }
            throw new IllegalArgumentException(idref);
        }
        return this;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE;
    }

    public int getTagCode() {
        return 1;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("measurement".equals(childNodeName)) {
            this.handleMeasurement(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleMeasurement(Node node) {
        this.addChild(new MeasurementElement(node, this));
    }

    private boolean isCommandReceived(TagElement element) {
        if (element == null) {
            return true;
        }
        TagElement parent = element.getParent();
        if (parent instanceof DeviceElement) {
            MainTagElement de = (MainTagElement)parent;
            return de.includeCommandRecevied();
        }
        return this.isCommandReceived(parent);
    }
}

